
<?php

if (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] === $_SERVER['SERVER_ADDR']) {
  $_SESSION['MM_Username'] = 'informes';
}

define('PERMITIDO', true);
require_once("../inc/init.php");
require('../lib/valido.php');
require_once('../lib/util.php');
require_once('../lib/connection.php');
require_once("../lib/config.php");

function obtenerFirmaUsuarioValidadorArea($idAtencion, $codigoAreaLaboratorio)
{
  global $mysqli;

  $query = $mysqli->prepare("SELECT u.FIRMA 
  FROM examenes_atenciones ea
  INNER JOIN examenes e ON ea.COD_EXAMEN = e.COD_INTERNO
  INNER JOIN usuarios u ON ea.USUARIO_VAL = u.ID_USUARIO 
  WHERE ea.ID_ATENCION = ? AND e.AREA_LAB = ? AND u.FIRMA IS NOT NULL AND ea.USUARIO_VAL != 12 
  GROUP BY ea.USUARIO_VAL");
  $query->bind_param('ii', $idAtencion, $codigoAreaLaboratorio);
  $query->execute();
  $query->bind_result($firmaUsuarioValidadorArea);
  $query->fetch();
  $query->close();
  return $firmaUsuarioValidadorArea;
}

$idAtencion = $_GET["id"];
$arrayDatosFirmaPorHoja = [];

$qAreas = $mysqli->prepare("SELECT ex.AREA_LAB, cg.DESCRIPCION_CG
FROM examenes_atenciones ea
INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
INNER JOIN codigos_generales cg ON ex.AREA_LAB = cg.CODIGO AND cg.COD_TABLA = 'SIS_AREAS'
WHERE ID_ATENCION = ? AND ea.F_HIJO IS NULL AND ea.FECHA_VAL IS NOT NULL
GROUP BY ex.AREA_LAB
ORDER BY ea.ID_EXATE ASC");
$qAreas->bind_param('i', $idAtencion);
$qAreas->execute();
$qAreas->bind_result($codigoAreaLaboratorio, $descripcionAreaLaboratorio);
$qAreas->store_result();

while ($qAreas->fetch()) {
  $firmaUsuarioValidadorArea = obtenerFirmaUsuarioValidadorArea($idAtencion, $codigoAreaLaboratorio);
  $flagHojaExtra = false;

  echo ".- $descripcionAreaLaboratorio<br>";

  $qExamenesTipoPerfil = $mysqli->prepare("SELECT ea.ID_EXATE, ea.COD_EXAMEN
  FROM examenes_atenciones ea
  INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO AND ex.AREA_LAB = ? AND ex.FLAG_PERFIL_EXAMENES = 1 AND ex.F_INF = 'S'
  LEFT JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA = cg.CODIGO AND cg.COD_TABLA = 'SIS_UNIMED'
  LEFT JOIN codigos_generales cg2 ON ex.TIPO_MUESTRA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPMUE'
  WHERE ea.ID_ATENCION = ? AND ea.FECHA_VAL IS NOT NULL AND ea.PADRE IS NULL
  ORDER BY ea.ID_EXATE ASC");
  $qExamenesTipoPerfil->bind_param('ii', $codigoAreaLaboratorio, $idAtencion);
  $qExamenesTipoPerfil->execute();
  $qExamenesTipoPerfil->bind_result($archivoFirmaUsuarioValidador, $codExamen);
  $qExamenesTipoPerfil->store_result();
  while ($qExamenesTipoPerfil->fetch()) {
    # echo "PERFIL $firmaUsuarioValidadorArea<br>";
    if ($codExamen == '00.00.069' || $codExamen == '00.00.166') $flagHojaExtra = true;
    $arrayDatosFirmaPorHoja[] = [
      "firma" => $firmaUsuarioValidadorArea,
      "cargo" => $firmaUsuarioValidadorArea,
      "ingles" => false,
      "asd" => "asd"
    ];
  }
  $qExamenesTipoPerfil->close();

  $qExamenes = $mysqli->prepare("SELECT ea.ID_EXATE, ea.COD_EXAMEN
  FROM examenes_atenciones ea
  INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO AND ex.AREA_LAB = ? AND ex.FLAG_PERFIL_EXAMENES = 0 AND ex.F_INF = 'S'
  LEFT JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA = cg.CODIGO AND cg.COD_TABLA = 'SIS_UNIMED'
  LEFT JOIN codigos_generales cg2 ON ex.TIPO_MUESTRA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPMUE'
  WHERE ea.ID_ATENCION = ? AND ea.FECHA_VAL IS NOT NULL AND ea.PADRE IS NULL
  ORDER BY ea.ID_EXATE ASC");
  $qExamenes->bind_param('ii', $codigoAreaLaboratorio, $idAtencion);
  $qExamenes->execute();
  $qExamenes->bind_result($archivoFirmaUsuarioValidador, $codExamen);
  $qExamenes->store_result();
  $nroExamenesArea = $qExamenes->num_rows;
  while ($qExamenes->fetch()) {
    if ($codExamen == '00.00.069' || $codExamen == '00.00.166') $flagHojaExtra = true;
  }
  if ($nroExamenesArea > 0) {
    # echo "TIENE EXAMENES NO-PERFIL $firmaUsuarioValidadorArea<br>";
    $arrayDatosFirmaPorHoja[] = [
      "firma" => $firmaUsuarioValidadorArea,
      "cargo" => $firmaUsuarioValidadorArea,
      "ingles" => false,
      "asd" => "asd"
    ];
  }
  $qExamenes->close();

  if ($flagHojaExtra === true) {
    $arrayDatosFirmaPorHoja[] = [
      "firma" => $firmaUsuarioValidadorArea,
      "cargo" => $firmaUsuarioValidadorArea,
      "ingles" => true,
      "asd" => "asd"
    ];
  }
  echo "<br>";
}
$qAreas->close();

echo "<br><br>";

echo "<pre>";
print_r($arrayDatosFirmaPorHoja);
echo "</pre>";
