<?php
define('PERMITIDO', true);

$pagina = 34;

require_once '../lib/valido.php';
require_once '../lib/util.php';
require_once '../lib/func.global.php';
require_once '../lib/connection.php';
require_once '../lib/config.php';
require_once '../assets/php/PHPExcel.php';

error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');

$fi = date('Y-m-d', strtotime('-1 week'));
if (isset($_GET['f_inicio'])) $fi = $_GET['f_inicio'];

$ft = date('Y-m-d');
if (isset($_GET['f_termino'])) $ft = $_GET['f_termino'];

$filtro = "";
if (isset($_GET['cod_examen_urgente']) && $_GET['cod_examen_urgente'] != "") $filtro = " AND ea.COD_EXAMEN = '{$_GET['cod_examen_urgente']}'";
else                                                                         $filtro = " AND (e.FLAG_URGENTE = 1 OR ea.COD_EXAMEN = '00.00.069')";

$sql_atenciones_urgentes = "SELECT a.ID_ATENCION, a.FECHA, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NOMBRES, p.NRO_RUT, p.DV_RUT, cc.NOMBRE, a.FECHA_R, a.HORA_R,
ea.FECHA_VAL, ea.COD_EXAMEN, IFNULL(e.NOMBRE_INF, e.NOMBRE)
FROM atenciones a
JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
JOIN examenes e ON e.COD_INTERNO = ea.COD_EXAMEN
JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
WHERE a.FECHA BETWEEN ? AND ? AND a.NIVEL_URGENCIA = 3
AND a.FLAG_ELIMINADO = 0 AND a.FECHA_R IS NOT NULL AND ea.FECHA_VAL IS NOT NULL AND a.HORA_R IS NOT NULL $filtro";
$resultado_atenciones_urgentes = $mysqli->prepare($sql_atenciones_urgentes);
$resultado_atenciones_urgentes->bind_param('ss', $fi, $ft);
$resultado_atenciones_urgentes->execute();
$resultado_atenciones_urgentes->bind_result($at_id, $at_fecha, $at_apellido_p, $at_apellido_m, $at_nombres, $at_nro_rut, $at_dv_rut, $at_local, $at_fecha_r, $at_hora_r,
$at_fecha_val, $at_cod_examen, $at_examen);
$resultado_atenciones_urgentes->store_result();

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);

$objPHPExcel->setActiveSheetIndex(0)
	->setCellValue('A1', 'NRO. ATENCIÓN')
	->setCellValue('B1', 'FECHA')
	->setCellValue('C1', 'PACIENTE')
	->setCellValue('D1', 'RUT')
	->setCellValue('E1', 'LOCAL')
	->setCellValue('F1', 'FECHA RECEPCIÓN')
	->setCellValue('G1', 'FECHA VALIDACIÓN')
	->setCellValue('H1', 'TIEMPO TRANSCURRIDO')
	->setCellValue('I1', 'CÓDIGO EXAMEN')
	->setCellValue('J1', 'EXAMEN')
	->setCellValue('K1', 'A/R');

$f = 2;
while ($resultado_atenciones_urgentes->fetch()) {
	$dt_fecha_r = DateTime::createFromFormat('Y-m-d H:i:s', "{$at_fecha_r} {$at_hora_r}");
	$dt_fecha_val = DateTime::createFromFormat('Y-m-d H:i:s', $at_fecha_val);
	$di_tiempo_trans = $dt_fecha_r->diff($dt_fecha_val);

	$fch = explode('-', $at_fecha);
	$fch = $fch[2] . '-' . $fch[1] . '-' . $fch[0];

  if ($at_cod_examen == "00.00.069") {
    $a_r = ($di_tiempo_trans->format('%h') >= 6 || $di_tiempo_trans->format('%a') >= 1) ?  "R" : "A";
  } else {
    $a_r = ($di_tiempo_trans->format('%h') >= 4 || $di_tiempo_trans->format('%a') >= 1) ?  "R" : "A";
  }
	
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $f, $at_id);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $f, $fch);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('C' . $f, "{$at_nombres} {$at_apellido_p} {$at_apellido_m}");
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $f, number_format($at_nro_rut, 0, ',', '.') . '-' . strtoupper($at_dv_rut));
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('E' . $f, $at_local);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F' . $f, "{$at_fecha_r} {$at_hora_r}");
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G' . $f, $at_fecha_val);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H' . $f, $di_tiempo_trans->format('%a días, %h horas, %i minutos'));
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I' . $f, $at_cod_examen);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('J' . $f, $at_examen);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('K' . $f, $a_r);
	$f++;
}
$resultado_atenciones_urgentes->close();

$objPHPExcel->getActiveSheet()->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="xls_urgentes.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');

die();
?>
