<?php

$pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../scripts/PHPMailer-master/PHPMailerAutoload.php');
require_once("../assets/php/correo.php"); #configuracion del correo
$ahora = date('Y-m-d H:i:s');

function RandomString()
{
	$characters = '123456789ABCDEFGHIJKLMNPQRSTUVWXYZ';
	$randstring = '';
	for ($i = 0; $i < 10; $i++) {
		$randstring .= $characters[rand(0, strlen($characters))];
	}
	return $randstring;
}

function pasarMayusculas($cadena)
{
	$cadena = strtoupper($cadena);
	$cadena = str_replace("á", "Á", $cadena);
	$cadena = str_replace("é", "É", $cadena);
	$cadena = str_replace("í", "Í", $cadena);
	$cadena = str_replace("ó", "Ó", $cadena);
	$cadena = str_replace("ú", "Ú", $cadena);
	$cadena = str_replace("ñ", "Ñ", $cadena);
	if ($cadena == "") return null;
	return $cadena;
}

function validarRut($rut)
{
	$rut = preg_replace('/[^k0-9]/i', '', $rut);
	$dv  = substr($rut, -1);
	$numero = substr($rut, 0, strlen($rut) - 1);
	$i = 2;
	$suma = 0;
	foreach (array_reverse(str_split($numero)) as $v) {
		if ($i == 8) $i = 2;
		$suma += $v * $i;
		++$i;
	}
	$dvr = 11 - ($suma % 11);
	if ($dvr == 11) $dvr = 0;
	if ($dvr == 10) $dvr = 'K';

	if ($dvr == strtoupper($dv)) return true;
	else return false;
}

function calcularDígitoVerificador($nroRut)
{
	$i = 2;
	$suma = 0;

	foreach (array_reverse(str_split($nroRut)) as $v) {
		if ($i == 8) $i = 2;
		$suma += $v * $i;
		$i++;
	}

	$dvr = 11 - ($suma % 11);
	if ($dvr == 11) $dvr = 0;
	if ($dvr == 10) $dvr = 'K';
	return $dvr;
}

function crearUsuario($_DATOS)
{
	global $mysqli, $ahora, $usuario_id;

	$rutArray = explode('-', $_DATOS["rut"]);
	$nro_rut = str_replace('.', '', $rutArray[0]);
	$dv_rut = $rutArray[1];

	$usuario_paciente = ($_DATOS['PAIS'] != "") ? $usuario_paciente = $_DATOS['PASAPORTE'] : $nro_rut;
	$contraseña_paciente = RandomString();

	$qInsertUsuario = $mysqli->prepare("INSERT INTO usuarios (NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO, NRO_RUT, DV_RUT, MAIL, USUARIO, CONTRASENA, PERFIL, FECHA_CREACION, ID_CREADOR)
	VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'PACIENTE', ?, ?)");
	$qInsertUsuario->bind_param(
		'sssssssssi',
		pasarMayusculas($_DATOS['NOMBRES']),
		pasarMayusculas($_DATOS['APELLIDO_PATERNO']),
		pasarMayusculas($_DATOS['APELLIDO_MATERNO']),
		$nro_rut,
		$dv_rut,
		$_DATOS['MAIL'],
		$usuario_paciente,
		$contraseña_paciente,
		$ahora,
		$usuario_id
	);
	$qInsertUsuario->execute();
	$qInsertUsuario->close();

	# ENVIO DE CORREO AUTOMATICO
	$nombrePaciente = pasarMayusculas($_DATOS['NOMBRES']) . ' ' . pasarMayusculas($_DATOS['APELLIDO_PATERNO']) . ' ' . pasarMayusculas($_DATOS['APELLIDO_MATERNO']);
	$envio = enviarCorreo($usuario_paciente, $contraseña_paciente, $nombrePaciente, $_DATOS['MAIL']);
	return $envio;
}

if ((isset($_POST["insertPersona"])) && ($_POST["insertPersona"] == "insertPersona")) {

	$rutArray = explode('-', $_POST["rut"]);
	if ((count($rutArray) != 2 || $rutArray[0] == "" || $rutArray[1] == "") && $_POST["generar_rut_provisorio"] != 1) mostrarMensajeError("Formato de RUT Inválido");

	$nro_rut = str_replace('.', '', $rutArray[0]);
	$dv_rut = $rutArray[1];
	$apellido_materno = $_POST["APELLIDO_MATERNO"] != "" ? $_POST["APELLIDO_MATERNO"] : null;
	$pasaporte = $_POST["PASAPORTE"] != "" ? $_POST["PASAPORTE"] : null;
	$direccion = $_POST["DIRECCION"] != "" ? $_POST["DIRECCION"] : null;
	$comuna = $_POST["COMUNA"] != "" ? $_POST["COMUNA"] : null;
	$fono_1 = $_POST["FONO_1"] != "" ? $_POST["FONO_1"] : null;
	$fono_2 = $_POST["FONO_2"] != "" ? $_POST["FONO_2"] : null;
	$mail = $_POST["MAIL"] != "" ? $_POST["MAIL"] : null;

	if (trim($_POST["rut"]) == "" && $_POST["generar_rut_provisorio"] != 1)	mostrarMensajeError("Ingrese un RUT o seleccione 'Generar RUT provisorio'");
	if (!validarRut($_POST["rut"])) mostrarMensajeError("El RUT ingresado es incorrecto");
	if (trim($_POST["APELLIDO_PATERNO"]) == "") mostrarMensajeError("Se necesita al menos el nombre y el apellido paterno");
	if ($_POST["FECHA_NACIMIENTO"] == "" && $_POST["FLAG_PACIENTE"] == "S")	mostrarMensajeError("Ingrese la fecha de nacimiento");
	if ($_POST["FLAG_MEDICO"] == 'N' && $_POST["FLAG_PACIENTE"] == "N") mostrarMensajeError("Seleccione si es paciente, médico o ambos");
	if ($_POST["FLAG_MEDICO"] == 'S' && $_POST["ESPECIALIDAD"] == "-") mostrarMensajeError("Si se ingresa un médico, debe seleccionar una especialidad");
	if ($mail != "" && !validarCorreo2($mail)) mostrarMensajeError("Error en el formato del correo electrónico");
	if (!isset($_POST["GENERO"]) || $_POST["GENERO"] == "") mostrarMensajeError("Seleccione el género");
	if (!isset($_POST["ID_PREVISION"]) || $_POST["ID_PREVISION"] == "") mostrarMensajeError("Seleccione la previsión");

	if ($pasaporte != "") {
		if ($_POST['PAIS'] == null) mostrarMensajeError("Si se ingresa pasaporte, debe seleccionar un país de procedencia");
		$flag_extranjero = "S";
		$pais = $_POST['PAIS'];
	} else {
		$flag_extranjero = "N";
		$pais = null;
	}

	$qRutYaExiste = $mysqli->prepare("SELECT ID_PERSONA, CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) FROM personas WHERE NRO_RUT = ?");
	$qRutYaExiste->bind_param('i', $nro_rut);
	$qRutYaExiste->execute();
	$qRutYaExiste->bind_result($id_personaRepetida, $nombre_personaRepetida);
	$qRutYaExiste->fetch();
	$qRutYaExiste->close();
	if ($id_personaRepetida != "") mostrarMensajeError("El RUT ingresado ya está siendo utilizado por un paciente.<br>Paciente: $nombre_personaRepetida");

	$qRutUsuario = $mysqli->prepare("SELECT CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) FROM usuarios WHERE NRO_RUT = ?");
	$qRutUsuario->bind_param('i', $nro_rut);
	$qRutUsuario->execute();
	$qRutUsuario->bind_result($usuarioConRutExistente);
	$qRutUsuario->fetch();
	$qRutUsuario->close();
	if (isset($_POST['crearUsuario']) && $nro_rut != "" && $usuarioConRutExistente != "") mostrarMensajeError("El RUT ingresado ya está siendo utilizado por un usuario.<br>Usuario: $usuarioConRutExistente");

	$qMailUsuario = $mysqli->prepare("SELECT CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) FROM usuarios WHERE MAIL = ?");
	$qMailUsuario->bind_param('s', $mail);
	$qMailUsuario->execute();
	$qMailUsuario->bind_result($usuarioConMailExistente);
	$qMailUsuario->fetch();
	$qMailUsuario->close();
	if (isset($_POST['crearUsuario']) && $mail != "" && $usuarioConMailExistente != "") mostrarMensajeError("El correo electrónico ingresado ya está siendo utilizado por otro usuario.<br>Usuario: $usuarioConMailExistente");

	if (isset($_POST["generar_rut_provisorio"])) {
		$insertSQL = $mysqli->prepare("INSERT INTO personas (NRO_RUT, DV_RUT, PASAPORTE, PAIS, FLAG_EXTRANJERO,
		NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO, FECHA_NACIMIENTO, GENERO, RAZA,
		FLAG_PACIENTE, FLAG_MEDICO, ID_PREVISION, ESPECIALIDAD, DIRECCION, COMUNA, FONO_1, FONO_2, MAIL, FECHA_CREACION, ID_CREADOR) 
		VALUES (obtener_rut_extranjero(), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		$insertSQL->bind_param(
			'ssissssssissississssi',
			$dv_rut,
			$pasaporte,
			$pais,
			$flag_extranjero,
			pasarMayusculas($_POST['NOMBRES']),
			pasarMayusculas($_POST['APELLIDO_PATERNO']),
			pasarMayusculas($apellido_materno),
			$_POST['FECHA_NACIMIENTO'],
			$_POST['GENERO'],
			$_POST['RAZA'],
			$_POST['FLAG_PACIENTE'],
			$_POST['FLAG_MEDICO'],
			$_POST['ID_PREVISION'],
			$_POST['ESPECIALIDAD'],
			$direccion,
			$comuna,
			$fono_1,
			$fono_2,
			$mail,
			$ahora,
			$usuario_id
		);
		$insertSQL->execute();
		$id = $insertSQL->insert_id;
		$insertSQL->close();
		$consulta = $mysqli->prepare("SELECT NRO_RUT FROM personas WHERE ID_PERSONA = ? LIMIT 1");
		$consulta->bind_param('i', $id);
		$consulta->execute();
		$consulta->bind_result($nroRut);
		$consulta->fetch();
		$consulta->close();
		$dvRut = calcularDígitoVerificador($nroRut);
		$sentenciaActualización = $mysqli->prepare("UPDATE personas SET DV_RUT = ? WHERE ID_PERSONA = ? LIMIT 1");
		$sentenciaActualización->bind_param('si', $dvRut, $id);
		$sentenciaActualización->execute();
		$sentenciaActualización->close();
	} else {
		$insertSQL = $mysqli->prepare("INSERT INTO personas (NRO_RUT, DV_RUT, PASAPORTE, PAIS, FLAG_EXTRANJERO,
		NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO, FECHA_NACIMIENTO, GENERO, RAZA,
		FLAG_PACIENTE, FLAG_MEDICO, ID_PREVISION, ESPECIALIDAD, DIRECCION, COMUNA, FONO_1, FONO_2, MAIL, FECHA_CREACION, ID_CREADOR) 
		VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		$insertSQL->bind_param(
			'ississssssissississssi',
			$nro_rut,
			$dv_rut,
			$pasaporte,
			$pais,
			$flag_extranjero,
			pasarMayusculas($_POST['NOMBRES']),
			pasarMayusculas($_POST['APELLIDO_PATERNO']),
			pasarMayusculas($apellido_materno),
			$_POST['FECHA_NACIMIENTO'],
			$_POST['GENERO'],
			$_POST['RAZA'],
			$_POST['FLAG_PACIENTE'],
			$_POST['FLAG_MEDICO'],
			$_POST['ID_PREVISION'],
			$_POST['ESPECIALIDAD'],
			$direccion,
			$comuna,
			$fono_1,
			$fono_2,
			$mail,
			$ahora,
			$usuario_id
		);
		$insertSQL->execute();
		$insertSQL->close();
	}

	# Luego de crear el paciente, si se selecciona el checkbox crearUsuario, se llama a la función crearUsuario()
	if (isset($_POST['crearUsuario'])) {
		$crearUsuario = crearUsuario($_POST);
		if ($crearUsuario != 'ok') mostrarMensajeError($crearUsuario);
	}

	$respuesta = array('exito' => true, 'mensaje' => $crearUsuario);
	echo json_encode($respuesta);
	exit(0);
}

if ((isset($_POST["updatePersona"])) && ($_POST["updatePersona"] == "updatePersona")) {

	$rutArray = explode('-', $_POST["rut"]);
	if ((count($rutArray) != 2 || $rutArray[0] == "" || $rutArray[1] == "") && $_POST["generar_rut_provisorio"] != 1) mostrarMensajeError("Formato de RUT Inválido");

	$nro_rut = str_replace('.', '', $rutArray[0]);
	$dv_rut = $rutArray[1];
	$apellido_materno = $_POST["APELLIDO_MATERNO"] != "" ? $_POST["APELLIDO_MATERNO"] : null;
	$pasaporte = $_POST["PASAPORTE"] != "" ? $_POST["PASAPORTE"] : null;
	$direccion = $_POST["DIRECCION"] != "" ? $_POST["DIRECCION"] : null;
	$comuna = $_POST["COMUNA"] != "" ? $_POST["COMUNA"] : null;
	$fono_1 = $_POST["FONO_1"] != "" ? $_POST["FONO_1"] : null;
	$fono_2 = $_POST["FONO_2"] != "" ? $_POST["FONO_2"] : null;
	$mail = $_POST["MAIL"] != "" ? $_POST["MAIL"] : null;

	if (trim($_POST["rut"]) == "" && $_POST["generar_rut_provisorio"] != 1)	mostrarMensajeError("Ingrese un RUT o seleccione 'Generar RUT provisorio'");
	if (!validarRut($_POST["rut"])) mostrarMensajeError("El RUT ingresado es incorrecto");
	if (trim($_POST["APELLIDO_PATERNO"]) == "") mostrarMensajeError("Se necesita al menos el nombre y el apellido paterno");
	if ($_POST["FECHA_NACIMIENTO"] == "" && $_POST["FLAG_PACIENTE"] == "S")	mostrarMensajeError("Ingrese la fecha de nacimiento");
	if ($_POST["FLAG_MEDICO"] == 'N' && $_POST["FLAG_PACIENTE"] == "N") mostrarMensajeError("Seleccione si es paciente, médico o ambos");
	if ($_POST["FLAG_MEDICO"] == 'S' && $_POST["ESPECIALIDAD"] == "-") mostrarMensajeError("Si se ingresa un médico, debe seleccionar una especialidad");
	if ($mail != "" && !validarCorreo2($mail)) mostrarMensajeError("Error en el formato del correo electrónico");

	if ($pasaporte != "") {
		if ($_POST['PAIS'] == null) mostrarMensajeError("Si se ingresa pasaporte, debe seleccionar un país de procedencia");
		$flag_extranjero = "S";
		$pais = $_POST['PAIS'];
	} else {
		$flag_extranjero = "N";
		$pais = null;
	}

	$qRutYaExiste = $mysqli->prepare("SELECT ID_PERSONA, CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) FROM personas WHERE NRO_RUT = ? AND ID_PERSONA != ?");
	$qRutYaExiste->bind_param('ii', $nro_rut, $_POST['ID_PERSONA']);
	$qRutYaExiste->execute();
	$qRutYaExiste->bind_result($id_personaRepetida, $nombre_personaRepetida);
	$qRutYaExiste->fetch();
	$qRutYaExiste->close();
	if ($id_personaRepetida != "") mostrarMensajeError("El RUT ingresado ya está siendo utilizado por un paciente.<br>Paciente: $nombre_personaRepetida");

	$qRutUsuario = $mysqli->prepare("SELECT CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) FROM usuarios WHERE NRO_RUT = ?");
	$qRutUsuario->bind_param('i', $nro_rut);
	$qRutUsuario->execute();
	$qRutUsuario->bind_result($usuarioConRutExistente);
	$qRutUsuario->fetch();
	$qRutUsuario->close();
	if (isset($_POST['crearUsuario']) && $nro_rut != "" && $usuarioConRutExistente != "") mostrarMensajeError("El RUT ingresado ya está siendo utilizado por un usuario.<br>Usuario: $usuarioConRutExistente");

	$qMailUsuario = $mysqli->prepare("SELECT CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) FROM usuarios WHERE MAIL = ?");
	$qMailUsuario->bind_param('s', $mail);
	$qMailUsuario->execute();
	$qMailUsuario->bind_result($usuarioConMailExistente);
	$qMailUsuario->fetch();
	$qMailUsuario->close();
	if (isset($_POST['crearUsuario']) && $mail != "" && $usuarioConMailExistente != "") mostrarMensajeError("El correo electrónico ingresado ya está siendo utilizado por otro usuario.<br>Usuario: $usuarioConMailExistente");

	# SI VIENE DE "MODIFICACIÓN DE PACIENTE" EN ATENCIONES Y CAMBIA LA PREVISION	
	if (isset($_POST['id_atencion']) && $_POST['ID_PREVISION_ORIGINAL'] != $_POST['ID_PREVISION']) {
		$qExate = $mysqli->prepare("SELECT COUNT(ID_EXATE) FROM examenes_atenciones WHERE ID_ATENCION = ?");
		$qExate->bind_param('i', $_POST['id_atencion']);
		$qExate->execute();
		$qExate->bind_result($nro_examenes_atencion);
		$qExate->store_result();
		$qExate->fetch();
		$qExate->close();
		if ($nro_examenes_atencion > 0) mostrarMensajeError("Debe eliminar los examenes para poder modificar la previsión");
		$qupdatePrevAte = $mysqli->prepare("UPDATE atenciones SET ID_PREVISION = ? WHERE ID_ATENCION = ?");
		$qupdatePrevAte->bind_param('ii', $_POST['ID_PREVISION'], $_POST['id_atencion']);
		$qupdatePrevAte->execute();
		$qupdatePrevAte->close();
	}
	# SI VIENE DE "MODIFICACIÓN DE PACIENTE" EN COTIZACIONES Y CAMBIA LA PREVISION
	if (isset($_POST['id_cotizacion']) && $_POST['ID_PREVISION_ORIGINAL'] != $_POST['ID_PREVISION']) {
		$qExate = $mysqli->prepare("SELECT COUNT(ID_EXCOT) FROM examenes_cotizaciones WHERE ID_COTIZACION = ?");
		$qExate->bind_param('i', $_POST['id_cotizacion']);
		$qExate->execute();
		$qExate->bind_result($nro_examenes_atencion);
		$qExate->store_result();
		$qExate->fetch();
		$qExate->close();
		if ($nro_examenes_atencion > 0) mostrarMensajeError("Debe eliminar los examenes para poder modificar la previsión");
		$qupdatePrevAte = $mysqli->prepare("UPDATE cotizaciones SET ID_PREVISION = ? WHERE ID_COTIZACION = ?");
		$qupdatePrevAte->bind_param('ii', $_POST['ID_PREVISION'], $_POST['id_cotizacion']);
		$qupdatePrevAte->execute();
		$qupdatePrevAte->close();
	}

	if (isset($_POST["generar_rut_provisorio"])) {
		$updateSQL = $mysqli->prepare("UPDATE personas
		SET NRO_RUT = obtener_rut_extranjero(), DV_RUT = ?, PASAPORTE = ?, PAIS = ?, FLAG_EXTRANJERO = ?, NOMBRES = ?, APELLIDO_PATERNO = ?, APELLIDO_MATERNO = ?, 
		FECHA_NACIMIENTO = ?, GENERO = ?, RAZA = ?, FLAG_PACIENTE = ?, FLAG_MEDICO = ?, ID_PREVISION = ?, ESPECIALIDAD = ?, DIRECCION = ?, COMUNA = ?,
		FONO_1 = ?, FONO_2 = ?, MAIL = ?, FECHA_ULTIMA_MODIFICACION = ?, ID_USUARIO_ULTIMA_MODIFICACION = ?
		WHERE ID_PERSONA = ? LIMIT 1");
		$updateSQL->bind_param(
			'ssissssssissississssii',
			$dv_rut,
			$pasaporte,
			$pais,
			$flag_extranjero,
			pasarMayusculas($_POST['NOMBRES']),
			pasarMayusculas($_POST['APELLIDO_PATERNO']),
			pasarMayusculas($apellido_materno),
			$_POST['FECHA_NACIMIENTO'],
			$_POST['GENERO'],
			$_POST['RAZA'],
			$_POST['FLAG_PACIENTE'],
			$_POST['FLAG_MEDICO'],
			$_POST['ID_PREVISION'],
			$_POST['ESPECIALIDAD'],
			$direccion,
			$comuna,
			$fono_1,
			$fono_2,
			$mail,
			$ahora,
			$usuario_id,
			$_POST['ID_PERSONA']
		);
		$updateSQL->execute();
		$updateSQL->close();
		$id = $_POST['ID_PERSONA'];
		$consulta = $mysqli->prepare("SELECT NRO_RUT FROM personas WHERE ID_PERSONA = ? LIMIT 1");
		$consulta->bind_param('i', $id);
		$consulta->execute();
		$consulta->bind_result($nroRut);
		$consulta->fetch();
		$consulta->close();
		$dvRut = calcularDígitoVerificador($nroRut);
		$sentenciaActualización = $mysqli->prepare("UPDATE personas SET DV_RUT = ? WHERE ID_PERSONA = ? LIMIT 1");
		$sentenciaActualización->bind_param('si', $dvRut, $id);
		$sentenciaActualización->execute();
		$sentenciaActualización->close();
	} else {
		$updateSQL = $mysqli->prepare("UPDATE personas
		SET NRO_RUT = ?, DV_RUT = ?, PASAPORTE = ?, PAIS = ?, FLAG_EXTRANJERO = ?, NOMBRES = ?, APELLIDO_PATERNO = ?, APELLIDO_MATERNO = ?, 
		FECHA_NACIMIENTO = ?, GENERO = ?, RAZA = ?, FLAG_PACIENTE = ?, FLAG_MEDICO = ?, ID_PREVISION = ?, ESPECIALIDAD = ?, DIRECCION = ?, COMUNA = ?,
		FONO_1 = ?, FONO_2 = ?, MAIL = ?, FECHA_ULTIMA_MODIFICACION = ?, ID_USUARIO_ULTIMA_MODIFICACION = ? 
		WHERE ID_PERSONA = ? LIMIT 1");
		$updateSQL->bind_param(
			'ississssssissississssii',
			$nro_rut,
			$dv_rut,
			$pasaporte,
			$pais,
			$flag_extranjero,
			pasarMayusculas($_POST['NOMBRES']),
			pasarMayusculas($_POST['APELLIDO_PATERNO']),
			pasarMayusculas($apellido_materno),
			$_POST['FECHA_NACIMIENTO'],
			$_POST['GENERO'],
			$_POST['RAZA'],
			$_POST['FLAG_PACIENTE'],
			$_POST['FLAG_MEDICO'],
			$_POST['ID_PREVISION'],
			$_POST['ESPECIALIDAD'],
			$direccion,
			$comuna,
			$fono_1,
			$fono_2,
			$mail,
			$ahora,
			$usuario_id,
			$_POST['ID_PERSONA']
		);
		$updateSQL->execute();
		$updateSQL->close();
	}

	# Luego de crear el paciente, si se selecciona el checkbox crearUsuario, se llama a la función crearUsuario()
	if (isset($_POST['crearUsuario'])) {
		$crearUsuario = crearUsuario($_POST);
		if ($crearUsuario != 'ok') mostrarMensajeError($crearUsuario);
	}

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['eliminarPersona']) && $_POST['eliminarPersona']) {
	$stmt = $mysqli->prepare('UPDATE personas SET FLAG_ELIMINADO = 1 WHERE ID_PERSONA = ? LIMIT 1');
	$stmt->bind_param('i', $_POST['idPersona']);
	$stmt->execute();
	$stmt->close();
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['restaurarPersona']) && $_POST['restaurarPersona']) {
	$stmt = $mysqli->prepare('UPDATE personas SET FLAG_ELIMINADO = NULL WHERE ID_PERSONA = ? LIMIT 1');
	$stmt->bind_param('i', $_POST['idPersona']);
	$stmt->execute();
	$stmt->close();
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}
