<?php
define('PERMITIDO', true);
require_once("../inc/init.php");
include('../pdfClasses/class.ezpdf.php');

if (!(isset($_GET['fch']) && isset($_GET['idp']))) die();

header("Content-type: application/force-download");

$pdf = new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(2.5, 1, 1, 1);
$pdf->ezStartPageNumbers(330, 5, 9, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);
date_default_timezone_set("America/Santiago");
$hora = time();

$qPlantilla=$mysqli->prepare("SELECT pl.id_plantilla, pl.obs, IFNULL(e.NOMBRE_E, 'NO APLICA'), e.NBR, cc.NOMBRE, IFNULL(cg.DESCRIPCION_CG, 'NO APLICA')
FROM plantillas pl
LEFT JOIN empresas e ON pl.id_convenio = e.ID_EMPRESA
LEFT JOIN centros_contacto cc ON pl.id_local = cc.ID_CENTRO_CONTACTO
LEFT JOIN codigos_generales cg ON pl.turno_dialisis = cg.CODIGO AND cg.COD_TABLA = 'SIS_TURDIA'
WHERE id_plantilla = ?");
$qPlantilla->bind_param('i', $_GET['idp']);
$qPlantilla->execute();
$qPlantilla->bind_result($p_idPlantilla, $p_observacion, $p_nombreConvenio, $p_nbrConvenio, $p_nombreProcedencia, $p_turnoDialisis);
$qPlantilla->store_result();
$qPlantilla->fetch();
$qPlantilla->close();

$qAtencionesPlanilla=$mysqli->prepare("SELECT a.ID_ATENCION, CONCAT_WS(' ', pe.NOMBRES, pe.APELLIDO_PATERNO, pe.APELLIDO_MATERNO), pe.NRO_RUT, pe.DV_RUT
FROM plantilla_pacientes pp
INNER JOIN personas pe ON pp.id_paciente = pe.ID_PERSONA
INNER JOIN atenciones a ON pe.ID_PERSONA = a.ID_CLIENTE
WHERE pp.id_plantilla = ? AND a.FECHA = ? AND a.FLAG_ELIMINADO = 0
ORDER BY a.ID_ATENCION");
$qAtencionesPlanilla->bind_param('is', $_GET['idp'], $_GET['fch']);
$qAtencionesPlanilla->execute();
$qAtencionesPlanilla->bind_result($ap_idAtencion, $ap_nombrePaciente, $ap_nroRutPaciente, $ap_dvRutPaciente);
$qAtencionesPlanilla->store_result();
$ap_numRows = $qAtencionesPlanilla->num_rows;

$sep = " ";
$nombre_archivo = "AtencionesPlantilla_{$p_nbrConvenio}_{$_GET['fch']}.pdf";
$informe = array('Content-Disposition' => $nombre_archivo);
$datacreator = array(
	'Title' => 'Atenciones de Plantilla',
	'Author' => 'SILCLE RIPIT',
	'Subject' => 'Atenciones de la Plantilla',
	'Creator' => '',
	'Producer' => 'www.ripit.cl'
	);
$pdf->addInfo($datacreator);

$logo_empresa = imagecreatefrompng('../assets/img/logo_empresa_informes.png');
$pdf->addImage($logo_empresa, 25, 730, null, 50);
$fch = explode('-', $_GET['fch']);
$fch = $fch[2] . '-' . $fch[1] . '-' . $fch[0];
$pdf->ezText("ATENCIONES DE PLANTILLA     <b>FECHA:</b> {$fch}\n", 9, array('justification' => 'left'));
$pdf->ezText("<b>CONVENIO:</b> $p_nombreConvenio\n", 8, array('justification' => 'left'));
$pdf->ezText("<b>PROCEDENCIA:</b> $p_nombreProcedencia\n", 8, array('justification' => 'left'));
$pdf->ezText("<b>TURNO DIÁLISIS:</b> $p_turnoDialisis\n", 8, array('justification' => 'left'));
$pdf->ezText("<b>OBSERVACIÓN:</b> $p_observacion\n", 8, array('justification' => 'left'));
$pdf->ezText("<b>Atenciones:</b> $ap_numRows\n", 8, array('justification' => 'left'));

$data = [];
while ($qAtencionesPlanilla->fetch()) {
	$data[] = array(
    'NRO_AT' => $ap_idAtencion,
    'PACIENTE' => $ap_nombrePaciente,
    'RUT' => number_format($ap_nroRutPaciente, 0, ',', '.') . '-' . $ap_dvRutPaciente,
    'V_1' => '', 'V_2' => '', 'V_3' => ''
  );
}
$qAtencionesPlanilla->close();

$titles = array(
	'NRO_AT' => '<b>N° Atención</b>',
	'PACIENTE' => '<b>Nombre Paciente</b>',
	'RUT' => '<b>RUT Paciente</b>',
	'V_1' => '', 'V_2' => '', 'V_3' => ''
);

$options = array(
	'shadeCol' => array(0.9, 0.9, 0.9),
	'showLines' => 2,
	'shaded' => 0,
	'xOrientation' => 'center',
	'width' => 560,
	'fontSize' => 8,
	'cols' => array(
		'NRO_AT' => array('justification' => 'left', 'width' => 60),
		'PACIENTE' => array('justification' => 'left', 'width' => 180),
		'RUT' => array('justification' => 'right', 'width' => 70),
		'V_1' => array('justification' => 'left', 'width' => 80),
		'V_2' => array('justification' => 'left', 'width' => 80),
		'V_3' => array('justification' => 'left', 'width' => 80)
	)
);

if ($ap_numRows > 0) $pdf->ezTable($data, $titles, '', $options);
else                 $pdf->ezText("No existen atenciones para esta fecha.\n", 8, array('justification' => 'left'));


ob_end_clean();
$pdf->ezStream($informe);
?>