<?php
define('PERMITIDO', true);
$pantalla_actual = 'MOD_PLA';

require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
$style = "<style>.select2-hidden-accessible{display:none;}	</style>";
include("../inc/header.php");
include("../inc/nav.php");

require_once __DIR__ . '/inc.php';
//===================================================================================================================

$idp = "-1";
if (isset($_GET['idp'])) $idp = $_GET['idp'];

$qplantilla = $mysqli->prepare("SELECT nombre, id_convenio, id_local, id_medico, cod_urgencia, turno_dialisis, obs FROM plantillas WHERE id_plantilla=?");
$qplantilla->bind_param('i', $idp);
$qplantilla->execute();
$qplantilla->bind_result($p_nombre, $p_idConvenio, $p_idLocal, $p_idMedico, $p_codUrgencia, $p_turnoDialisis, $p_obs);
$qplantilla->store_result();
$qplantilla->fetch();
$qplantilla->close();

$qconvenios = $mysqli->prepare("SELECT ID_EMPRESA, NOMBRE_E FROM empresas WHERE FLAG_CONVENIO='S' ORDER BY NOMBRE_E");
$qconvenios->execute();
$qconvenios->bind_result($c_id, $c_nombre);
$options_convenios = '<option value="0">-</option>';
while ($qconvenios->fetch()) {
	$selected = '';
	if ($p_idConvenio == $c_id) $selected = 'selected="selected"';
	$options_convenios .= '<option value="' . $c_id . '" ' . $selected . '>' . $c_nombre . '</option>';
}
$qconvenios->close();

$qlocales = $mysqli->prepare('SELECT ID_CENTRO_CONTACTO, NOMBRE, FLAG_DIALISIS FROM centros_contacto ORDER BY NOMBRE');
$qlocales->execute();
$qlocales->bind_result($l_id, $l_nombre, $l_flag_dialisis);
$options_locales = '';
while ($qlocales->fetch()) {
	$selected = '';
	if ($p_idLocal == $l_id) $selected = 'selected="selected"';
	$options_locales .= '<option value="' . $l_id . '" data-dialisis="' . $l_flag_dialisis . '" ' . $selected . '>' . $l_nombre . '</option>';
}
$qlocales->close();

$qmedicos = $mysqli->prepare("SELECT ID_PERSONA, CONCAT(IFNULL(p.APELLIDO_PATERNO, ''), ' ', IFNULL(p.APELLIDO_MATERNO, ''), ', ', IFNULL(p.NOMBRES, '')) AS NOMBRE_APELLIDOS_PRIMERO
FROM personas p
WHERE FLAG_MEDICO = 'S' AND FLAG_ELIMINADO IS NULL 
ORDER BY NOMBRE_APELLIDOS_PRIMERO ASC");
$qmedicos->execute();
$qmedicos->bind_result($m_id, $m_nombre);
$options_medicos = '';
while ($qmedicos->fetch()) {
	$selected = "";
	if ($p_idMedico == $m_id) $selected = "selected";
	$options_medicos .= "<option value='$m_id' $selected>$m_nombre</option>";
}
$qmedicos->close();

$qurgencia = $mysqli->prepare('SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA=\'SIS_NIVURG\'');
$qurgencia->execute();
$qurgencia->bind_result($u_id, $u_nombre);
$options_urgencia = '';
while ($qurgencia->fetch()) {
	$selected = '';
	if ($p_codUrgencia == $u_id) $selected = 'selected="selected"';
	$options_urgencia .= '<option value="' . $u_id . '" ' . $selected . '>' . $u_nombre . '</option>';
}
$qurgencia->close();

$qturnos_dialisis = $mysqli->prepare('SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA=\'SIS_TURDIA\'');
$qturnos_dialisis->execute();
$qturnos_dialisis->bind_result($turno_cod, $turno_desc);
$options_turnos_dialisis = '<option value="0">-</option>';
while ($qturnos_dialisis->fetch()) {
	$selected = '';
	if ($turno_cod == $p_turnoDialisis) $selected = 'selected="selected"';
	$options_turnos_dialisis .= '<option value="' . $turno_cod . '" ' . $selected . '>' . $turno_desc . '</option>';
}
$qturnos_dialisis->close();

# examenes para agregar a plantilla
$qexamenes = $mysqli->prepare('SELECT ex.COD_INTERNO, ex.NOMBRE
FROM examenes ex
WHERE ex.COD_INTERNO NOT IN (SELECT cod_interno FROM plantilla_examenes WHERE id_plantilla=?) AND ex.COD_FONASA IS NOT NULL
ORDER BY NOMBRE ASC');
$qexamenes->bind_param('i', $idp);
$qexamenes->execute();
$qexamenes->bind_result($e_codInterno, $e_examen);
$options_examenes = '';
while ($qexamenes->fetch()) $options_examenes .= '<option value="' . $e_codInterno . '">' . $e_examen . '</option>';
$qexamenes->close();

# pacientes de la plantilla
$qpacientes = $mysqli->prepare("SELECT pp.id_plantilla_p, pp.id_muestra, DATE_FORMAT(pp.fecha_tm,'%d/%m/%Y'), pp.hora_tm, p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NRO_RUT, p.DV_RUT, p.ID_PERSONA
FROM plantilla_pacientes pp
INNER JOIN personas p ON p.ID_PERSONA = pp.id_paciente
WHERE id_plantilla = ?");
$qpacientes->bind_param('i', $idp);
$qpacientes->execute();
$qpacientes->bind_result($pp_id, $pp_idMuestra, $pp_fechaTm, $pp_horaTm, $pp_nombre, $pp_aPaterno, $pp_aMaterno, $pp_nroRut, $pp_dvRut, $p_id);
$qpacientes->store_result();

# examenes de la plantilla
$qexamenesP = $mysqli->prepare('SELECT id_plantilla_e, pe.cod_interno, e.NOMBRE FROM plantilla_examenes pe
INNER JOIN examenes e ON e.COD_INTERNO = pe.cod_interno
WHERE id_plantilla = ?');
$qexamenesP->bind_param('i', $idp);
$qexamenesP->execute();
$qexamenesP->bind_result($ep_id, $ep_codInterno, $ep_examen);
$qexamenesP->store_result();

# Búsqueda de examen PCR-RT.
$pcr = false;
while ($qexamenesP->fetch()) {
	if ($ep_codInterno == '00.00.069') {
		$pcr = true;
		break;
	}
}
$qexamenesP->data_seek(0);

# Carga bloqueda
$carga_bloqueada = false;
$validaciónMédico = true;
if ($pcr) {
	$validaciónMédico = validarDatosMédicoPcr($p_idMedico);
	if ($validaciónMédico !== true) {
		$carga_bloqueada = true;
	}
}

ob_start();
?>

<form class="smart-form" action="sql_cod.php" name="formCargar" id="formCargar">
	<header>
		<section>
			<div class="row">
				<div class="col col-2">
					<label class="label">
						<h5><b>Cargar Plantilla: </b></h5>
					</label>
				</div>
				<div class="col col-2">
					<label class="label">
						<h5>Fecha</h5>
					</label>
				</div>
				<div class="col col-2">
					<label class="input">
						<input type="date" class="input-sm" name="fecha" />
					</label>
				</div>
				<div class="col col-6">
					<a class="btn btn-primary btn-sm btn-CargarP"><i class="fa fa-arrow-circle-up fa-lg"></i> Cargar</a>
					<button type="button" class="btn btn-danger btn-sm btn-DescargarPdf" data-href="atenciones_plantilla_pdf.php?idp=<?= $idp ?>"><i class="fa fa-arrow-circle-down fa-lg"></i> PDF</button>
					<button type="button" class="btn btn-info btn-sm btn-DescargarCodBarrasPdf" data-href="cod_barras_plantilla_pdf.php?idp=<?= $idp ?>"><i class="fa fa-barcode fa-lg"></i> Códigos de barras</button>
				</div>
			</div>
		</section>
	</header>
	<input type="hidden" name="cargarPlantilla" value="<?= $_GET['idp'] ?>" />
</form>

<form class="smart-form" action="sql_cod.php" name="formPlantilla" id="formPlantilla" method="post">

	<fieldset>
		<section>
			<div class="row">
				<div class="col col-2">
					<div class="row">
						<label class="label">
							<h5>Nombre</h5>
						</label>
						<label class="input">
							<input class="input-sm" name="nombre" value="<?= $p_nombre ?>" />
						</label>
					</div>
					<div class="row" style="margin-top: 10px">
						<label class="label">
							<h5>Observación</h5>
						</label>
						<label class="input">
							<input class="input-sm" name="obs" value="<?= $p_obs ?>" />
						</label>
					</div>
				</div>
				<div class="col col-2">
					<label class="label">
						<h5>Convenio</h5>
					</label>
					<label class="select">
						<select name="id_convenio">
							<?= $options_convenios ?>
						</select>
						<i></i>
					</label>
				</div>
				<div class="col col-2">
					<div class="row">
						<label class="label">
							<h5>Procedencia</h5>
						</label>
						<label class="select">
							<select name="id_local" id="id_local">
								<?= $options_locales ?>
							</select>
							<i></i>
						</label>
					</div>
					<div class="row" style="margin-top: 10px">
						<label class="label">
							<h5>Turno Diálisis</h5>
						</label>
						<label class="select">
							<select name="id_turdia" id="id_turdia" <?php if ($p_turnoDialisis == 0) echo "disabled>" ?> <?= $options_turnos_dialisis ?> </select>
								<i></i>
						</label>
					</div>
				</div>
				<div class="col col-3">
					<label class="label">
						<h5>Médico</h5>
					</label>
					<label class="select">
						<!-- <input id="busquedaMED" name="id_medico" style="width: -webkit-fill-available;"> -->
						<select name="id_medico" class="select2">
							<?= $options_medicos ?>
						</select>
					</label>
					<?php if ($validaciónMédico !== true) {	?>
						<p>
							<?= $validaciónMédico ?>
						</p>
					<?php	} ?>
				</div>
				<div class="col col-2">
					<label class="label">
						<h5>Urgencia</h5>
					</label>
					<label class="select">
						<select name="cod_urgencia">
							<?= $options_urgencia ?>
						</select>
						<i></i>
					</label>
				</div>
				<div class="col col-1">
					<label class="label">&nbsp;</label>
					<a class="btn btn-success btn-sm pull-right btn-grabar"> <i class="fa fa-save"></i> Grabar </a>
				</div>
			</div>
		</section>
	</fieldset>
	<input type="hidden" name="updatePlantilla" value="formPlantilla" />
	<input type="hidden" name="id_plantilla" value="<?= $idp ?>" />
</form>


<form class="smart-form" action="sql_cod.php" name="formAgPaciente" id="formAgPaciente" method="post">
	<fieldset>
		<section>
			<div class="row">
				<div class="col col-2">
					<h5>Agregar Paciente</h5>
				</div>
				<div class="col col-5">
					<input style="width: -webkit-fill-available;" id="busquedaPAC" name="id_paciente">
				</div>
				<div class="col col-2">
					<a class="btn btn-success btn-sm pull-right btn-agregar" data-form="#formAgPaciente"> <i class="fa fa-save"></i> Añadir </a>
				</div>
			</div>
		</section>
	</fieldset>
	<input type="hidden" name="insertPaciente" value="formAgPaciente" />
	<input type="hidden" name="id_plantilla" value="<?= $idp ?>" />
</form>

<table class="table table-bordered table-hover">
	<thead>
		<tr>
			<th>Paciente</th>
			<th>Rut</th>
			<th>ID Muestra Minsal</th>
			<th>Fecha TM</th>
			<th>Hora TM</th>
			<th style="width:5em;">Eliminar</th>
		</tr>
	</thead>
	<tbody>
		<?php
		while ($qpacientes->fetch()) {
			$validaciónPaciente = true;
			if ($pcr) {
				$validaciónPaciente = validarDatosPacientePcr($p_id);
				if ($validaciónPaciente !== true) $carga_bloqueada = true;
			} else {
				if (!validarRut($pp_nroRut . '-' . $pp_dvRut)) {
					$validaciónPaciente = '<br>El RUT del paciente es incorrecto.';
					$carga_bloqueada = true;
				}
			}
		?>
			<tr>
				<td>
					<?= $pp_nombre . ' ' . $pp_aPaterno . ' ' . $pp_aMaterno ?>
					<a data-toggle="modal" href="../m_personas/e_persona.php?id=<?= $p_id ?>" data-target="#myModalEdit" title="Desplegar información paciente"><i class="fa fa-search fa-lg"></i></a>
					<?php if ($validaciónPaciente !== true) { ?>
						<span class="label label-danger" data-toggle="tooltip" data-html="true" data-placement="top" title="Error: <?= $validaciónPaciente ?>">
							<i class="fa fa-exclamation"></i>
						</span>
					<?php	}	?>
				</td>
				<td><?= $pp_nroRut . '-' . $pp_dvRut ?></td>
				<td><?= $pp_idMuestra ?></td>
				<td><?= $pp_fechaTm ?></td>
				<td><?= $pp_horaTm ?></td>
				<td style="text-align:center"><a style="padding:0;" class="btn btn-link btn-eliminar" data-id="<?= $pp_id ?>" data-eliminar="paciente"><i class="fa fa-remove fa-lg"></i></a></td>
			</tr>
		<?php }
		$qpacientes->close() ?>
	</tbody>
</table>

<form class="smart-form" action="sql_cod.php" name="formAgExamen" id="formAgExamen" method="post">
	<fieldset>
		<section>
			<div class="row">
				<div class="col col-2">
					<h5>Agregar Examen</h5>
				</div>
				<div class="col col-5">
					<select class="select2" name="cod_interno">
						<?= $options_examenes ?>
					</select>
				</div>
				<div class="col col-2">
					<a class="btn btn-success btn-sm pull-right btn-agregar" data-form="#formAgExamen"> <i class="fa fa-save"></i> Añadir </a>
				</div>
			</div>
		</section>
	</fieldset>
	<input type="hidden" name="insertExamen" value="formAgPaciente" />
	<input type="hidden" name="id_plantilla" value="<?= $idp ?>" />
</form>



<table class="table table-bordered table-hover">
	<thead>
		<tr>
			<th>Código Interno</th>
			<th>Examen</th>
			<th style="width:5em;">Eliminar</th>
		</tr>
	</thead>
	<tbody>
		<?php while ($qexamenesP->fetch()) { ?>
			<tr>
				<td><?= $ep_codInterno ?></td>
				<td><?= $ep_examen ?></td>
				<td style="text-align:center">
					<a style="padding:0;" class="btn btn-link btn-eliminar" data-id="<?= $ep_id ?>" data-eliminar="examen"><i class="fa fa-remove fa-lg"></i></a>
				</td>
			</tr>
		<?php }
		$qexamenesP->close() ?>
	</tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-file-text-o'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php include("../inc/ribbon.php");	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<!-- modals -->
<div class="modal fade Edit" id="myModalEdit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content" style="width:120%">
		</div>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$(document).ready(function() {
		$('[data-toggle="tooltip"]').tooltip();

		var cargaBloqueada = <?= json_encode($carga_bloqueada) ?>;
		if (cargaBloqueada) $('.btn-CargarP').attr('disabled', true);

		$('.btn-grabar').on('click', function() { //agregar actividad
			$.post('sql_cod.php', $('#formPlantilla').serialize(), function(data) {
				if (data.exito) {
					exito();
					location.reload();
				} else {
					error("Error: " + data.mensaje);
				}
			}, 'json');
		});

		$('.btn-agregar').on('click', function() { //agregar
			var form = $(this).data('form');
			$.post('sql_cod.php', $(form).serialize(), function(data) {
				if (data.exito) {
					exito();
					location.reload();
				} else {
					error("Error: " + data.mensaje);
				}
			}, 'json');
		});

		$('.btn-eliminar').on('click', function() { //eliminar
			$.post('sql_cod.php', {
				eliminar: $(this).data('eliminar'),
				id: $(this).data('id')
			}, function(data) {
				if (data.exito) {
					exito();
					location.reload();
				} else {
					error("Error: " + data.mensaje);
				}
			}, 'json');
		});

		$('.btn-CargarP').on('click', function() {
			load();
			$.post('sql_cod.php', $('#formCargar').serialize(), function(data) {
				if (data.exito) {
					exito();
					$('.btn-CargarP').attr('disabled', true);
					$('.btn-DescargarPdf, .btn-DescargarCodBarrasPdf').attr('disabled', false);
				} else {
					error("Error: " + data.mensaje);
				}
			}, 'json');
		});

		$('.btn-DescargarPdf').on('click', function() {
			var fch = $('input[name="fecha"]').val();
			if (fch == '') {
				alert("Debe seleccionar fecha");
				return false;
			}
			var w = window.open();
			w.location = $(this).data('href') + '&fch=' + fch;
		});

		$('.btn-DescargarCodBarrasPdf').on('click', function() {
			var fch = $('input[name="fecha"]').val();
			if (fch == '') {
				alert("Debe seleccionar fecha");
				return false;
			}
			var w = window.open();
			w.location = $(this).data('href') + '&fch=' + fch;
		});

		$('#id_local').on('change', function() {
			var dialisis = $('#id_local option:selected').attr('data-dialisis');
			$('#id_turdia').val('0');
			if (dialisis == 'S') {
				$('#id_turdia').removeAttr('disabled');
			} else {
				$('#id_turdia').attr('disabled', 'disabled');
			}
		});

		var dialisis = $('#id_local option:selected').attr('data-dialisis');
		if (dialisis == 'S') $('#id_turdia').removeAttr('disabled');
		else $('#id_turdia').attr('disabled', 'disabled');

		$('#busquedaPAC').select2({
			placeholder: "Buscar por RUT o Nombre de Paciente",
			minimumInputLength: 2,
			formatInputTooShort: function() {
				return 'Ingrese uno o mas caracteres';
			},
			formatSearching: "Buscando...",
			formatNoMatches: "No se encontraron resultados",
			ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
				type: "POST",
				url: "../o_atenciones/ajax_PAC.php",
				dataType: 'json',
				quietMillis: 100,
				data: function(term, page) {
					return {
						nombre: term, // search term
					};
				},
				results: function(data) {
					return {
						results: $.map(data, function(item) {
							return {
								text: item.nombre + " - " + item.rut,
								id: item.id,
							}
						})
					};
				},
				cache: true
			},
			escapeMarkup: function(m) {
				return m;
			} // we do not want to escape markup since we are displaying html in results
		});

		// $('#busquedaMED').select2({
		// 	placeholder: "Buscar médico por Nombre",
		// 	minimumInputLength: 1,
		// 	formatSearching: "Buscando...",
		// 	formatNoMatches: "No se encontraron resultados",
		// 	formatInputTooShort: function() {
		// 		return 'Ingrese uno o mas caracteres';
		// 	},
		// 	ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
		// 		type: "POST",
		// 		url: "../o_atenciones/ajax_MED.php",
		// 		dataType: 'json',
		// 		quietMillis: 100,
		// 		data: function(term, page) {
		// 			return {
		// 				nombre_medico: term, // search term
		// 			};
		// 		},
		// 		results: function(data) {
		// 			return {
		// 				results: $.map(data, function(item) {
		// 					return {
		// 						text: item.nombre_medico, // + " - " + item.rut_medico,
		// 						id: item.id_medico,
		// 						especialidad: item.especialidad
		// 					}
		// 				})
		// 			};
		// 		},
		// 		cache: true
		// 	},
		// 	escapeMarkup: function(m) {
		// 		return m;
		// 	} // we do not want to escape markup since we are displaying html in results
		// });
	});
</script>

<?php
include("../inc/google-analytics.php");
?>