<?php

function validarRut($rut) {
    $rut = preg_replace('/[^k0-9]/i', '', $rut);
    $dv  = substr($rut, -1);
    $numero = substr($rut, 0, strlen($rut)-1);
    $i = 2;
    $suma = 0;
    foreach(array_reverse(str_split($numero)) as $v)
    {
        if($i==8)
            $i = 2;

        $suma += $v * $i;
        ++$i;
    }

    $dvr = 11 - ($suma % 11);
    
    if($dvr == 11)
        $dvr = 0;
    if($dvr == 10)
        $dvr = 'K';

    if($dvr == strtoupper($dv))
        return true;
    else
        return false;
}

/* Esta función comprueba todos los datos obligatorios del paciente, en el contexto de la notificación al Ministerio de Salud. */
function validarDatosPacientePcr($id_paciente) {
	global $mysqli;

	$sql_datos_paciente = "SELECT pac.NRO_RUT as NRO_RUT_PAC, pac.DV_RUT as DV_RUT_PAC, pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO, pac.FECHA_NACIMIENTO, pac.DIRECCION, cod.ATRIBUTO1 AS COD_COMUNA, pac.FONO_1, pac.GENERO
		FROM personas pac
		
		LEFT JOIN codigos_generales cod ON pac.COMUNA = cod.CODIGO AND cod.COD_TABLA = 'SIS_COMUN'
		
		WHERE pac.ID_PERSONA = $id_paciente";
		
	$resultado_datos_paciente = $mysqli->query($sql_datos_paciente);
	$datos_paciente = $resultado_datos_paciente->fetch_assoc();
		
	$error = '';
		
	if ($datos_paciente['NRO_RUT_PAC'] === null || $datos_paciente['DV_RUT_PAC'] === null) {
		$error .= '<br />El RUT del paciente no está configurado correctamente.';
	} elseif (!validarRut($datos_paciente['NRO_RUT_PAC'] . '-' . $datos_paciente['DV_RUT_PAC'])) {
		$error .= '<br />El RUT del paciente es incorrecto.';
	}
	
	if ($datos_paciente['NOMBRES'] === null || $datos_paciente['APELLIDO_PATERNO'] === null) {
		$error .= '<br />El nombre del paciente está incompleto.';
	}
	
	if ($datos_paciente['FECHA_NACIMIENTO'] === null || $datos_paciente['FECHA_NACIMIENTO'] == '0000-00-00') {
		$error .= '<br />Falta la fecha de nacimiento del paciente.';
	}
	
	if ($datos_paciente['DIRECCION'] === null) {
		$error .= '<br />Falta la dirección del paciente.';
	}
	
	if ($datos_paciente['COD_COMUNA'] === null) {
		$error .= '<br />Falta la comuna del paciente.';
	}
	
	if ($datos_paciente['FONO_1'] === null) {
		$error .= '<br />Falta el teléfono del paciente.';
	}
	
	if ($datos_paciente['GENERO'] === null || !in_array($datos_paciente['GENERO'], ['F', 'M'])) {
		$error .= '<br />Falta el género del paciente o está mal especificado';
	}
	
	return ($error == '') ? true : $error;
}

/* Esta función comprueba todos los datos obligatorios del médico, en el contexto de la notificación al Ministerio de Salud. */
function validarDatosMédicoPcr($id_médico) {
	global $mysqli;

	$sql_datos_médico = "SELECT med.NRO_RUT as NRO_RUT_MED, med.DV_RUT as DV_RUT_MED
		FROM personas med
		
		WHERE med.ID_PERSONA = $id_médico";
		
	$resultado_datos_médico = $mysqli->query($sql_datos_médico);
	$datos_médico = $resultado_datos_médico->fetch_assoc();
		
	$error = '';
	
	if ($datos_médico['NRO_RUT_MED'] === null || $datos_médico['DV_RUT_MED'] === null) {
		$error .= '<br />El RUT del médico no está configurado correctamente.';
	}
	
	return ($error == '') ? true : $error;
}

?>
