<?php
define('PERMITIDO', true);

$pantalla_actual = 'GEN_ORD_MED';

require_once __DIR__ . '/../inc/init.php';

require_once __DIR__ . '/../tcpdf/tcpdf.php';

function verificarFolioEpivigila($id_examen_atencion) {
	global $mysqli;
	
	$sql_toma_de_muestra = "SELECT ID_TOMA_DE_MUESTRA, ID_ATENCION FROM toma_de_muestras_minsal tm
		INNER JOIN examenes_atenciones ea ON tm.ID_EXAMEN_ATENCION = ea.ID_EXATE
		WHERE ID_EXAMEN_ATENCION = $id_examen_atencion LIMIT 1";
	$resultado_toma_de_muestra = $mysqli->query($sql_toma_de_muestra);
	
	$folio_epivigila = 0;
	if ($resultado_toma_de_muestra->num_rows == 0) {
		$crear = $mysqli->prepare('INSERT INTO toma_de_muestras_minsal (ID_EXAMEN_ATENCION, FOLIO_EPIVIGILA) VALUES(?, ?)');
		$crear->bind_param('ii', $id_examen_atencion, $folio_epivigila);
		$crear->execute();	
		$crear->close();
	}
	
	return true;
}

$id_examen_atención = $_GET['id_examen_atencion'];

verificarFolioEpivigila($id_examen_atención);

$sql_orden_médica = "SELECT CONCAT(p.NOMBRES, ' ', p.APELLIDO_PATERNO, ' ', IF(p.APELLIDO_MATERNO IS NULL, '', p.APELLIDO_MATERNO)) AS NOMBRE_PACIENTE, a.ID_ATENCION, a.FECHA,
	p.NRO_RUT, p.DV_RUT, p.PASAPORTE, cg_2.DESCRIPCION_CG AS PAIS, p.DIRECCION, p.FECHA_NACIMIENTO, cg.DESCRIPCION_CG AS COMUNA, tm.FOLIO_EPIVIGILA, u.ID_USUARIO, u.NRO_RUT AS RUT_MEDICO
	FROM examenes_atenciones ea 
	INNER JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
	INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
	LEFT JOIN codigos_generales cg ON p.COMUNA = cg.CODIGO AND cg.COD_TABLA = 'SIS_COMUN'
	LEFT JOIN codigos_generales cg_2 ON p.PAIS = cg_2.CODIGO AND cg_2.COD_TABLA = 'SIS_PAIS'
	INNER JOIN toma_de_muestras_minsal tm ON ea.ID_EXATE = tm.ID_EXAMEN_ATENCION
	INNER JOIN usuarios u ON u.USUARIO = '{$_SESSION['MM_Username']}'
	WHERE ea.ID_EXATE = $id_examen_atención";
	
$resultado_orden_médica = $mysqli->query($sql_orden_médica);
$orden_médica = $resultado_orden_médica->fetch_assoc();
	
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'LETTER', true, 'UTF-8', false);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->AddPage();

$imagen = $orden_médica['RUT_MEDICO'] . '.jpg';
$pdf->Image($imagen, 0, 0, 216, 280, '', '', '', false, 300, '', false, false, 0);

// Fecha
$date_time_orden = DateTime::createFromFormat('Y-m-d', $orden_médica['FECHA']);
$date_time_orden->sub(new DateInterval('P1D'));

// RUT
if ($orden_médica['PASAPORTE'] === NULL) {
	$identificación_paciente = number_format($orden_médica['NRO_RUT'], 0, ',', '.') . '-' . strtoupper($orden_médica['DV_RUT']);
} else {
	$identificación_paciente = $orden_médica['PASAPORTE'] . ' (pasaporte) *';
}

// Edad
$date_time_fecha_nacimiento = DateTime::createFromFormat('Y-m-d', $orden_médica['FECHA_NACIMIENTO']);
$date_interval_diferencia = $date_time_fecha_nacimiento->diff($date_time_orden);

$edad = $date_interval_diferencia->y;

$folio_epivigila = $orden_médica['FOLIO_EPIVIGILA'] == 0 ? '-' : $orden_médica['FOLIO_EPIVIGILA'];

if ($orden_médica['RUT_MEDICO'] == '16574743') {
	// Fecha
	$pdf->SetFont('helvetica', '', 10);
	$pdf->SetXY(133, 45);
	$pdf->writeHTML($date_time_orden->format('d'), true, false, false, false, '');
	$pdf->SetXY(145, 45);
	$pdf->writeHTML($date_time_orden->format('m'), true, false, false, false, '');
	$pdf->SetXY(157, 45);
	$pdf->writeHTML($date_time_orden->format('Y'), true, false, false, false, '');
	
	// Nombre
	$pdf->SetFont('helvetica', '', 10);
	$pdf->SetXY(45, 54.5);
	$pdf->writeHTML($orden_médica['NOMBRE_PACIENTE'], true, false, false, false, '');

	// RUT
	$pdf->SetFont('helvetica', '', 10);
	$pdf->SetXY(40, 63);
	$pdf->writeHTML($identificación_paciente, true, false, false, false, '');
	
	if ($orden_medica['PASAPORTE'] !== null) {
		$pdf->SetFont('helvetica', 'I', 10);
		$pdf->SetXY(32, 200);
		$pdf->writeHTML('* País de procedencia: ' . $orden_médica['PAIS'], true, false, false, false, '');
	}
	
	// Edad
	$pdf->SetFont('helvetica', '', 10);
	$pdf->SetXY(133, 63);
	$pdf->writeHTML($edad, true, false, false, false, '');
	
	// Comuna
	$pdf->SetFont('helvetica', '', 8);
	$pdf->SetXY(135, 71);
	$pdf->writeHTML($orden_médica['COMUNA'], true, false, false, false, '');
	
	// Folio EPIVIGILA
	$pdf->SetFont('helvetica', '', 16);
	$pdf->SetXY(55, 129);
	$pdf->writeHTML($folio_epivigila, true, false, false, false, '');

	// Dirección
	$pdf->SetFont('helvetica', '', 8);
	$pdf->writeHTMLCell(72.5, '', 47, 72, $orden_médica['DIRECCION']);
} elseif ($orden_médica['RUT_MEDICO'] == '18018978') {
	// Fecha
	$pdf->SetFont('helvetica', '', 10);
	$pdf->SetXY(44, 213.5);
	$pdf->writeHTML($date_time_orden->format('d') . '/' . $date_time_orden->format('m') . '/' . $date_time_orden->format('Y'), true, false, false, false, '');
	
	// Nombre
	$pdf->SetFont('helvetica', '', 10);
	$pdf->SetXY(46, 65);
	$pdf->writeHTML($orden_médica['NOMBRE_PACIENTE'], true, false, false, false, '');

	// RUT
	$pdf->SetFont('helvetica', '', 10);
	$pdf->SetXY(41, 77.5);
	$pdf->writeHTML($identificación_paciente, true, false, false, false, '');
	
	if ($orden_médica['PASAPORTE'] !== null) {
		$pdf->SetFont('helvetica', 'I', 10);
		
		$pdf->SetXY(30, 200);
		$pdf->writeHTML('* País de procedencia: ', true, false, false, false, '');
		$pdf->SetXY(32, 205);
		$pdf->writeHTML($orden_médica['PAIS'], true, false, false, false, '');
	}
	
	// Datos examen
	$pdf->SetFont('helvetica', '', 16);
	$pdf->SetXY(30, 130);
	$pdf->writeHTML('Examen:', true, false, false, false, '');
	
	$pdf->SetFont('helvetica', '', 14);
	$pdf->SetXY(30, 135);
	$pdf->writeHTML('PCR COVID-19', true, false, false, false, '');
	
	$pdf->SetFont('helvetica', '', 16);
	$pdf->SetXY(30, 145);
	$pdf->writeHTML('Notificación Epivigila', true, false, false, false, '');
	
	$pdf->SetFont('helvetica', '', 14);
	$pdf->SetXY(30, 150);
	$pdf->writeHTML('Folio Nº: ' . $folio_epivigila, true, false, false, false, '');
}

$ruta_temporal = $nombre_fichero_tmp = tempnam('tmp', 'orden');
$archivo_pdf = $pdf->Output($ruta_temporal, 'F');

// Subida a servidor FTP
$ftp_host = 'localhost';
$ftp_puerto = 21;
$ftp_usuario = 'archetch';
$ftp_contraseña = 'fFtL46BSGH';
$ftp_ruta = '/public_html/ordenes_medicas';

$timestamp = time();

$md5 = md5($timestamp);
$nombre_destino = $orden_médica['ID_ATENCION'] . '-' . date('dmYHis', $timestamp) . '-' . $md5 . '.pdf';

$exito = false;
if ($ftp_conexión = ftp_connect($ftp_host, $ftp_puerto)) {
	if (ftp_login($ftp_conexión, $ftp_usuario, $ftp_contraseña)) {
		if (ftp_chdir($ftp_conexión, $ftp_ruta)) {
			if (ftp_put($ftp_conexión, $nombre_destino, $ruta_temporal, FTP_BINARY)) {
				$exito = true;
			}
		}
	}
}
unlink($ruta_temporal);

if ($exito == false) {
	echo 'Error al subir documento PDF';
}

$fecha = date('Y-m-d H:i:s', $timestamp);
$tipo = 'ORDEN_MEDICA';
$url = "/ordenes_medicas/$nombre_destino";
$id_atencion = $orden_médica['ID_ATENCION'];
$id_usuario = $orden_médica['ID_USUARIO'];

$sql = "INSERT INTO archivos_atenciones (FECHA, TIPO, URL, ID_ATENCION, ID_USUARIO) VALUES ('$fecha', '$tipo', '$url', $id_atencion, $id_usuario)";
$mysqli->query($sql);

echo json_encode([
	'exito' => true,
	'mensaje' => 'Orden médica generada correctamente.',
	'url' => $url
]);
?>
