<?php
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\ServerException;

set_time_limit(60);

define('PERMITIDO', true);

$pantalla_actual = 'GEN_ORD_MED';

require_once __DIR__ . '/../inc/init.php';
require_once __DIR__ . '/../inc/vendor/autoload.php';

require_once __DIR__ . '/config.php';

function grabarFolioEpivigila($folio_epivigila, $id_examen_atencion) {
	global $mysqli;
	
	$sql_toma_de_muestra = "SELECT ID_TOMA_DE_MUESTRA, ID_ATENCION FROM toma_de_muestras_minsal tm
		INNER JOIN examenes_atenciones ea ON tm.ID_EXAMEN_ATENCION = ea.ID_EXATE
		WHERE ID_EXAMEN_ATENCION = $id_examen_atencion LIMIT 1";
	$resultado_toma_de_muestra = $mysqli->query($sql_toma_de_muestra);
	
	if ($resultado_toma_de_muestra->num_rows == 0) {
		$crear = $mysqli->prepare('INSERT INTO toma_de_muestras_minsal (ID_EXAMEN_ATENCION, FOLIO_EPIVIGILA) VALUES(?, ?)');
		$crear->bind_param('ii', $id_examen_atencion, $folio_epivigila);
		$crear->execute();	
		$crear->close();
	} else {
		$id_toma_de_muestra = $resultado_toma_de_muestra->fetch_assoc()['ID_TOMA_DE_MUESTRA'];
		
		$modificar = $mysqli->prepare('UPDATE toma_de_muestras_minsal SET FOLIO_EPIVIGILA = ? WHERE ID_TOMA_DE_MUESTRA = ? LIMIT 1');
		$modificar->bind_param('ii', $folio_epivigila, $id_toma_de_muestra);
		$modificar->execute();	
		$modificar->close();
	}
	
	return true;
}

function responderError($error) {
	header('Content-Type: application/json');
	echo json_encode(['exito' => false, 'mensaje' => $error]);
	die();
}

$metodo_solicitud = $_SERVER['REQUEST_METHOD'];
$id_usuario = $usuario_id;

switch ($metodo_solicitud) {
	case 'GET':
		break;
	case 'POST':
		$json_solicitud = file_get_contents('php://input');
		
		$datos_solicitud = json_decode($json_solicitud, true);
		
		$folios_epivigila = $datos_solicitud['folios_epivigila'];	
		foreach ($folios_epivigila as $id_examen_atencion => $folio_epivigila) {						
			if (($res = grabarFolioEpivigila($folio_epivigila, $id_examen_atencion)) !== true) {
				responderError($res);
			}
		}
		
		break;
	default:
}

header('Content-Type: application/json');
echo json_encode(['exito' => true]);

?>
