<?php
define('PERMITIDO', true);

$pantalla_actual = 'GEN_ORD_MED';

require_once '../inc/init.php';
require_once '../inc/config.ui.php';

if (isset($_GET['id_persona'])) {
	$id_persona = $_GET['id_persona'];
} else {
	die();
}

$sql_persona = "SELECT p.NRO_RUT, p.DV_RUT, p.PASAPORTE, cg_1.DESCRIPCION_CG AS PAIS, p.NOMBRES, CONCAT(p.APELLIDO_PATERNO, ' ', IF(p.APELLIDO_MATERNO IS NULL, '', p.APELLIDO_MATERNO)) AS APELLIDOS, DATE_FORMAT(p.FECHA_NACIMIENTO, '%d/%m/%Y') AS FECHA_NACIMIENTO,
	p.DIRECCION, cg_2.DESCRIPCION_CG AS COMUNA, p.FONO_1, e.NOMBRE_E
	FROM personas p
	LEFT JOIN codigos_generales cg_1 ON cg_1.COD_TABLA = 'SIS_PAIS' AND p.PAIS = cg_1.CODIGO
	LEFT JOIN codigos_generales cg_2 ON cg_2.COD_TABLA = 'SIS_COMUN' AND p.COMUNA = cg_2.CODIGO
	LEFT JOIN empresas e ON p.ID_PREVISION = e.ID_EMPRESA
	WHERE p.ID_PERSONA = {$id_persona}";
	
$resultado_persona = $mysqli->query($sql_persona);
$datos_persona = $resultado_persona->fetch_assoc();

?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
        &times;
    </button>

    <h4 class="modal-title" id="modal-datos-paciente-title">
		Datos del Paciente
	</h4>
</div>


<div class="modal-body">
	<section>
        <div class="row">
			<?php
			if ($datos_persona['PASAPORTE'] === null) {
			?>
			<div class="col col-md-2"><strong>RUT:</strong></div>

            <div class="col col-md-10">
				<?=number_format($datos_persona['NRO_RUT'], 0, ',', '.') . '-' . $datos_persona['DV_RUT'];?>
            </div>
			<?php
			} else {
			?>
			<div class="col col-md-2"><strong>Pasaporte:</strong></div>

            <div class="col col-md-5">
				<?=$datos_persona['PASAPORTE'];?>
            </div>
			
			<div class="col col-md-2"><strong>País:</strong></div>

            <div class="col col-md-3 text-right">
				<?=$datos_persona['PAIS'];?>
            </div>
			<?php
			}
			?>
        </div>
		
		<div class="row">
            <div class="col col-md-2"><strong>Nombre:</strong></div>

            <div class="col col-md-5">
				<?=$datos_persona['NOMBRES'] . ' ' . $datos_persona['APELLIDOS'];?>
            </div>
			
			<div class="col col-md-3"><strong>Fecha de nacimiento:</strong></div>

            <div class="col col-md-2 text-right">
				<?=$datos_persona['FECHA_NACIMIENTO'];?>
            </div>
        </div>
    </section>
	
	<hr>
	
	<section>
        <div class="row">           
			<div class="col col-md-2"><strong>Dirección:</strong></div>

            <div class="col col-md-5">
				<?=$datos_persona['DIRECCION'];?>
            </div>
			
			<div class="col col-md-2"><strong>Comuna:</strong></div>

            <div class="col col-md-3 text-right">
				<?=$datos_persona['COMUNA'];?>
            </div>
        </div>
		
		<div class="row">           
			<div class="col col-md-2"><strong>Teléfono:</strong></div>

            <div class="col col-md-4">
				<?=$datos_persona['FONO_1'];?>
            </div>
		</div>
    </section>
	
	<hr>
	
	<section>
        <div class="row">           
			<div class="col col-md-2"><strong>Previsión:</strong></div>

            <div class="col col-md-10">
				<?=$datos_persona['NOMBRE_E'];?>
            </div>
        </div>
    </section>
</div>

<div class="modal-footer">
	<button type="button" class="btn btn-default" data-dismiss="modal">
		Cerrar
	</button>
</div>
