<?php
define('PERMITIDO', true);
require_once("../inc/init.php");
include('../assets/php/php/php-barcode.php');
require('../assets/php/php/fpdf.php');

class eFPDF extends FPDF
{
  function TextWithRotation($x, $y, $txt, $txt_angle, $font_angle = 0)
  {
    $font_angle += 90 + $txt_angle;
    $txt_angle *= M_PI / 180;
    $font_angle *= M_PI / 180;

    $txt_dx = cos($txt_angle);
    $txt_dy = sin($txt_angle);
    $font_dx = cos($font_angle);
    $font_dy = sin($font_angle);

    $s = sprintf('BT %.2F %.2F %.2F %.2F %.2F %.2F Tm (%s) Tj ET', $txt_dx, $txt_dy, $font_dx, $font_dy, $x * $this->k, ($this->h - $y) * $this->k, $this->_escape($txt));
    if ($this->ColorFlag)
      $s = 'q ' . $this->TextColor . ' ' . $s . ' Q';
    $this->_out($s);
  }
}

$idAtencion = isset($_GET['idate']) ? $_GET['idate'] : "-1";
$filtroTubo = isset($_GET['idtb']) ? " AND ea.TIPO_TUBO = {$_GET['idtb']}" : "AND ea.TIPO_TUBO != '17'"; # si se muestra todos los tipos de tubo, se esconde el tipo "OTROS" (17)

$stmt = $mysqli->prepare("SELECT ea.ID_EXATE, ea.ID_ATENCION, ea.COD_EXAMEN, ea.TIPO_TUBO, cg.DESCRIPCION_CG AS TIPTUB, ex.SECUENCIA_CBARRA, ex.FLAG_AGRUPACION,
pa.NOMBRES, pa.APELLIDO_PATERNO, pa.APELLIDO_MATERNO, DATE_FORMAT(pa.FECHA_NACIMIENTO, '%d%m%y') AS FECHA_NACIMIENTO_FORMATEADA,
ct.NOMBRE AS CENTROCTO, DATE_FORMAT(a.FECHA,'%d-%m-%y') AS FECHA,
cg2.DESCRIPCION_CG AS TURNO
FROM examenes_atenciones ea
INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
LEFT JOIN codigos_generales cg ON ea.TIPO_TUBO = cg.CODIGO AND cg.COD_TABLA = 'SIS_TIPTUB'
LEFT JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
LEFT JOIN centros_contacto ct ON ct.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN personas pa ON a.ID_CLIENTE = pa.ID_PERSONA
LEFT JOIN codigos_generales cg2 ON cg2.CODIGO = a.TURNO_DIALISIS AND cg2.COD_TABLA = 'SIS_TURDIA'
WHERE ea.ID_ATENCION = ? $filtroTubo
GROUP BY ea.TIPO_TUBO");
$stmt->bind_param('i', $idAtencion);
$stmt->execute();
$resultado = $stmt->get_result();
if ($resultado === false) die("Error en la consulta: " . $mysqli->error);
$totalRows_exate = $resultado->num_rows;

$s_letra = 8;
$pdf = new eFPDF('P', 'pt', 'barras');
$pdf->SetFont('Arial', '', $s_letra);
$pdf->SetTextColor(0, 0, 0);

if ($totalRows_exate === 0) {
  $pdf->AddPage();
  $pdf->TextWithRotation(40, 120, "Atencion-Tubo sin examenes", "90");
}

if ($totalRows_exate > 0) {
  while ($row_tubo = $resultado->fetch_array(MYSQLI_ASSOC)) {
    $pdf->AddPage();

    $fontSize = 9;
    $marge = 5;   // between barcode and hri in pixel
    $x = 40;  // barcode center
    $y = 70;  // barcode center
    $width = 1;   // barcode height in 1D ; not use in 2D
    $height = 30;  // barcode height in 1D ; module size in 2D
    $angle = 90;  // rotation in degrees
    $type = 'code128';
    $blackInHexadecimal = '000000';
    $code = $idAtencion . "-" . $row_tubo['TIPO_TUBO'];

    $nombresPaciente = explode(' ', $row_tubo['NOMBRES']);
    $primerNombre = $nombresPaciente[0];
    $labelPaciente = substr($primerNombre . " " . $row_tubo['APELLIDO_PATERNO'] . " " . $row_tubo['APELLIDO_MATERNO'], 0, 25);

    $idAtencionYTubo = $idAtencion . " - " . $row_tubo['TIPTUB'];
    $fechaTurno = ($row_tubo['TURNO'] != '') ? $row_tubo['FECHA'] . '  ' . $row_tubo['TURNO'] : $row_tubo['FECHA'];

    if ($_GET['idtb'] == 17) { # nombre del paciente está compuesto por 3 iniciales, fecha de nacimiento y últimos 3 dígitos del RUT + DV Ej: AEL 230470 679-2
      $nombrePacienteAcortado = substr($row_atencion['NOMBRES'], 0, 1) . substr($row_atencion['APELLIDO_PATERNO'], 0, 1) . substr($row_atencion['APELLIDO_MATERNO'], 0, 1);
      $rutPacienteAcortado = substr($row_atencion['NRO_RUT'], -3, 3) . "-" . $row_atencion['DV_RUT'];
      $labelPaciente = $nombrePacienteAcortado . " " . $row_atencion['FECHA_NACIMIENTO_FORMATEADA'] . " " . $rutPacienteAcortado;
    } else {
      $labelPaciente = substr($primerNombre . " " . $row_tubo['APELLIDO_PATERNO'] . " " . $row_tubo['APELLIDO_MATERNO'], 0, 25);
    }

    $data = Barcode::fpdf($pdf, $blackInHexadecimal, $x, $y, $angle, $type, ['code' => $code], $width, $height);

    $len_t = $pdf->GetStringWidth($idAtencionYTubo);
    Barcode::rotate(-$len_t / 2, - ($data['height'] / 2) - $s_letra, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt - 2, $y + $yt, $idAtencionYTubo, $angle);

    $len_st = $pdf->GetStringWidth($row_tubo['CENTROCTO']);
    Barcode::rotate(-$len_st / 2, - ($data['height'] / 2) - $s_letra, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt + 6, $y + $yt, $row_tubo['CENTROCTO'], $angle);

    $len = $pdf->GetStringWidth($labelPaciente);
    Barcode::rotate(-$len / 2, ($data['height'] / 2) + $s_letra + $marge, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt, $y + $yt, $labelPaciente, $angle);

    $len_f = $pdf->GetStringWidth($fechaTurno);
    Barcode::rotate(-$len_f / 2, ($data['height'] / 2) + $s_letra + $marge, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt + 8, $y + $yt, $fechaTurno, $angle);
  }
}

$pdf->Output();
