<?php
define('PERMITIDO', true);
$pantalla_actual = 'ELI_ATE_MUL';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
include("../inc/header.php");
include("../inc/nav.php");

$options_razonEliminacion = "";
$qRazonEliminacion = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_RAZELIM'");
$qRazonEliminacion->execute();
$qRazonEliminacion->bind_result($codigoRazonEliminacion, $descripcionRazonEliminacion);
$qRazonEliminacion->store_result();
while ($qRazonEliminacion->fetch()) {
  $options_razonEliminacion .= "<option value='$codigoRazonEliminacion'> $descripcionRazonEliminacion </option>";
}
$qRazonEliminacion->close();

ob_start();
?>

<form action="sql_cod.php" id="formEliminarAtenciones" class="smart-form">
  <div class="row">
    <section class="col col-2">
      <label class="label">Desde:</label>
      <label class="input">
        <input type="text" name="rangoDesde" class="input-sm" />
      </label>
    </section>
    <section class="col col-2">
      <label class="label">Hasta:</label>
      <label class="input">
        <input type="text" name="rangoHasta" class="input-sm" />
      </label>
    </section>
  </div>
  <div class="row">
    <section class="col col-4">
      <label class="label">Razón eliminación:</label>
      <label class="select">
        <select name="razonEliminacion" class="input-sm">
          <option value="">-</option>
          <?= $options_razonEliminacion ?>
        </select> <i></i>
      </label>
    </section>
  </div>
  <div class="row">
    <section class="col col-4">
      <label class="label">Otra razón:</label>
      <label class="textarea">
        <textarea disabled rows="2" name="otraRazonEliminacion"></textarea>
        <i class="icon-append fa fa-comment"></i>
      </label>
    </section>
  </div>
  <div class="row">
    <section class="col col-4">
      <a class="btn btn-danger btn-sm btn-eliminarAtenciones pull-right"> <i class="fa fa-lg fa-trash-o"></i> Eliminar atenciones</a>
    </section>  
  </div>
  <input type="hidden" name="formEliminarAtenciones" value="formEliminarAtenciones" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('.btn-eliminarAtenciones').on('click', function() {
      var form = $("#formEliminarAtenciones");
      if (form.valid()) {
        if (confirm("¿Está seguro que desea eliminar este rango de atenciones?")) {
          $.post($(form).attr('action'), $(form).serialize(), function(data) {
            if (data.exito) {
              exito();
              location.reload();
            } else {
              error(data.mensaje);
            }
          }, 'json');
        }
      }
    });

    $('select[name="razonEliminacion"]').on('change', function() {
      if ($(this).val() == 5) $('textarea[name="otraRazonEliminacion"]').removeAttr('disabled');
      else $('textarea[name="otraRazonEliminacion"]').attr('disabled', 'disabled');
    });

    $("#formEliminarAtenciones").validate({
      rules: {
        rangoDesde: {
          required: true
        },
        rangoHasta: {
          required: true
        },
        razonEliminacion: {
          required: true
        },
        otraRazonEliminacion: {
          required: true
        }
      },
      messages: {
        rangoDesde: {
          required: 'Campo Obligatorio'
        },
        rangoHasta: {
          required: 'Campo Obligatorio'
        },
        razonEliminacion: {
          required: 'Campo Obligatorio'
        },
        otraRazonEliminacion: {
          required: 'Campo Obligatorio'
        }
      },
      onfocusout: false,
      onsubmit: true,
      // Do not change code below
      errorPlacement: function(error, element) {
        error.insertAfter(element.parent());
      }
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>