<?php

date_default_timezone_set('America/Santiago');

function verificarDiaHabil($datetime_atencion, $maxHorasProcesoAtencion, $feriadosArray) {

	$diaSemanaEnNumero = $datetime_atencion->format('N'); // 1, 2, 3, 4, 5, 6, 7
	if ($maxHorasProcesoAtencion <= 24 && in_array($diaSemanaEnNumero, ['7'])) return false; // Si es menor o igual a 24 horas de procesamiento, no cuenta domingos
  if ($maxHorasProcesoAtencion > 24 && in_array($diaSemanaEnNumero, ['6', '7'])) return false; // Si es mayor a 24 horas de procesamiento, no cuenta sábados ni domingos
	if (in_array($datetime_atencion->format('d-m'), $feriadosArray)) return false; // se revisa si es feriado

  return true;
}

function calcularFechaRetiro($idAtencion) {
	global $mysqli;

	$feriadosArray = [
		'01-01',
		'01-05', 
		'21-05', 
		'29-06', 
		'16-07', 
		'15-08', 
		'18-09', 
		'19-09', 
		'20-09', 
		'12-10', 
		'27-10', 
		'31-10', 
		'01-11', 
		'08-12', 
		'25-12'
	];

	$qDatosAtencion = $mysqli->prepare("SELECT CONCAT_WS(' ', FECHA, HORA) FROM atenciones WHERE ID_ATENCION = ?");
	$qDatosAtencion->bind_param("i", $idAtencion);
	$qDatosAtencion->execute();
	$qDatosAtencion->bind_result($fechaHoraAtencion);
	$qDatosAtencion->store_result();
	$qDatosAtencion->fetch();
	$qDatosAtencion->close();
	$datetime_atencion = DateTime::createFromFormat('Y-m-d H:i:s', $fechaHoraAtencion);
	# $datetime_atencion->add(new DateInterval('P1D'));

	$qMaxHorasProceso = $mysqli->prepare("SELECT MAX(e.HORAS_PROCESO) 
	FROM examenes_atenciones ea
	INNER JOIN examenes e ON ea.COD_EXAMEN = e.COD_INTERNO
	WHERE ID_ATENCION = ?");
	$qMaxHorasProceso->bind_param("i", $idAtencion);
	$qMaxHorasProceso->execute();
	$qMaxHorasProceso->bind_result($maxHorasProcesoAtencion);
	$qMaxHorasProceso->store_result();
	$qMaxHorasProceso->fetch();
	$qMaxHorasProceso->close();

	$horasRestantesProceso = $maxHorasProcesoAtencion;
	while ($horasRestantesProceso > 0) {
		if ($horasRestantesProceso >= 12) { // Si quedan al menos 12 horas por procesar, sumamos 12 horas
			$horasASumar = 12;
			$horasRestantesProceso -= 12;
		} else { // Si quedan menos de 12 horas, sumamos las horas restantes y salimos del bucle
			$horasASumar = $horasRestantesProceso;
			$horasRestantesProceso = 0;
		}

		$intervaloHorasASumar = new DateInterval('PT' . $horasASumar . 'H');
		$datetime_atencion->add($intervaloHorasASumar);

		while (!verificarDiaHabil($datetime_atencion, $maxHorasProcesoAtencion, $feriadosArray)) {
			$intervaloDiaCompleto = new DateInterval('P1D');
			$datetime_atencion->add($intervaloDiaCompleto);
		}
	}

	$datetime_atencion->setTime(12, 0); // se settea las 12 del dia
	return $datetime_atencion;
}
?>
