<?php
$pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$options_razonEliminacion = "";
$qRazonEliminacion = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_RAZELIM'");
$qRazonEliminacion->execute();
$qRazonEliminacion->bind_result($codigoRazonEliminacion, $descripcionRazonEliminacion);
$qRazonEliminacion->store_result();
while ($qRazonEliminacion->fetch()) {
  $options_razonEliminacion .= "<option value='$codigoRazonEliminacion'> $descripcionRazonEliminacion </option>";
}
$qRazonEliminacion->close();

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Eliminar Atención</h4>
</div>

<div class="modal-body">
  <form action="sql_cod.php" id="formEliminarAtencion" class="smart-form">
    <div class="row">
      <section>
        <label class="label">Razón eliminación:</label>
        <label class="select">
          <select name="razonEliminacion" class="input-sm">
            <option value="">-</option>
            <?= $options_razonEliminacion ?>
          </select> <i></i>
        </label>
      </section>
    </div>
    <div class="row">
      <section>
        <label class="label">Otra razón:</label>
        <label class="textarea">
          <textarea disabled rows="2" name="otraRazonEliminacion"></textarea>
          <i class="icon-append fa fa-comment"></i>
        </label>
      </section>
    </div>
    <div class="row">
      <section class="pull-right">
        <a class="btn btn-sm btn-danger btn-eliminarAtencion"> <i class="fa fa-lg fa-trash-o"></i> Confirmar Eliminación </a>
      </section>
    </div>
    <input type="hidden" name="formEliminarAtencion" value="formEliminarAtencion" />
    <input type="hidden" name="idAtencion" value="<?= $_GET["idAtencion"] ?>" />
  </form>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cerrar
  </button>
</div>


<script>
  $(document).ready(function() {
    $('.btn-eliminarAtencion').on('click', function() {
      var form = $("#formEliminarAtencion");
      if (form.valid()) {
        if (confirm("¿Desea eliminar la atención?")) {
          $.post($(form).attr('action'), $(form).serialize(), function(data) {
            if (data.exito) {
              exito();
              window.location.href = "l_atenciones.php";
            } else {
              error(data.mensaje);
            }
          }, 'json');
        }
      }
    });

    $('select[name="razonEliminacion"]').on('change', function() {
      if ($(this).val() == 5) $('textarea[name="otraRazonEliminacion"]').removeAttr('disabled');
      else $('textarea[name="otraRazonEliminacion"]').attr('disabled', 'disabled');
    });

    $("#formEliminarAtencion").validate({
      rules: {
        razonEliminacion: {
          required: true
        },
        otraRazonEliminacion: {
          required: true
        }
      },
      messages: {
        razonEliminacion: {
          required: 'Campo Obligatorio'
        },
        otraRazonEliminacion: {
          required: 'Campo Obligatorio'
        }
      },
      onfocusout: false,
      onsubmit: true,
      // Do not change code below
      errorPlacement: function(error, element) {
        error.insertAfter(element.parent());
      }
    });
  });
</script>