<?php
$pagina = 7;
define('PERMITIDO', true);
require_once('../inc/init.php');

# Los distintos métodos de IMED usualmente retornan listas en forma de arreglos (de bonos, prestaciones, etc).
# Con la excepción de que cuando una "lista" tiene 1 item, en vez de recibir un array (de largo 1), se recibe el elemento por si solo (no en un array). 
# Esto ocasiona un problema con los foreach() que iteran a estas distintas "listas".
# La funcion parsearLista() verifica que $listaRecibida sea un array. En caso de serlo, se retorna normalmente.
# En caso contrario, se agrega el elemento de $listaRecibida en un arreglo auxiliar para luego retornar este último.
function parsearLista($listaRecibida)
{
  $aux = null;
  if (is_array($listaRecibida)) return $listaRecibida;
  else $aux[] = $listaRecibida;
  return $aux;
}

# Los ruts se deben enviar en el formato exigido por IMED, se deben rellenar con "0" a la izquierda hasta que el largo del campo sea de 12 (incluyendo guión y rut)
function formatearRutImed($rut)
{
  $largoRut = 12;
  $relleno = "0";
  return str_pad($rut, $largoRut, $relleno, STR_PAD_LEFT);
}

if (isset($_POST['emitirBonos']) && $_POST['emitirBonos'] != "") {
  $qAtencion = $mysqli->prepare("SELECT CONCAT_WS('-', p.NRO_RUT, p.DV_RUT), CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO)
  FROM atenciones a
  LEFT JOIN personas p ON p.ID_PERSONA = a.ID_MEDICO
  WHERE ID_ATENCION = ?");
  $qAtencion->bind_param('i', $_POST['id_atencion']);
  $qAtencion->execute();
  $qAtencion->bind_result($rutMedico, $nombreMedico);
  $qAtencion->store_result();
  $qAtencion->fetch();
  $qAtencion->close();
  if ($rutMedico == "") mostrarMensajeError("Médico de la atención no tiene RUT registrado");
  if ($nombreMedico == "") mostrarMensajeError("Médico de la atención no tiene Nombre registrado");

  $qExamenesAtencion = $mysqli->prepare("SELECT ea.COD_EXAMEN, e.FLAG_AGRUPACION, e.FLAG_AGRUPACION_HOMOLOGADA_IMED, pe.PRECIO
  FROM examenes_atenciones ea
  INNER JOIN examenes e ON e.COD_INTERNO = ea.COD_EXAMEN
  LEFT JOIN (
    SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID_PEX
    FROM precios_examenes
    WHERE ID_EMPRESA = ?
    GROUP BY COD_EXAMEN
  ) max_pe ON ea.COD_EXAMEN = max_pe.COD_EXAMEN
  LEFT JOIN precios_examenes pe ON max_pe.COD_EXAMEN = pe.COD_EXAMEN AND max_pe.MAX_ID_PEX = pe.ID_PEX
  WHERE ea.ID_ATENCION = ? AND ea.PREV = ? AND ea.F_HIJO IS NULL");
  $qExamenesAtencion->bind_param('iii', $_POST['id_prevision'], $_POST['id_atencion'], $_POST['id_prevision']);
  $qExamenesAtencion->execute();
  $qExamenesAtencion->bind_result($cod_examen, $flag_agrupacion, $flag_agrupacion_homologada_imed, $precio_examen);
  $qExamenesAtencion->store_result();
  $numRows_examenes = $qExamenesAtencion->num_rows;
  if ($numRows_examenes == 0) mostrarMensajeError("Debe agregar exámenes con precio de PREVISIÓN para poder emitir bono electrónico");

  while ($qExamenesAtencion->fetch()) {
    
    if ($flag_agrupacion == "S" && $flag_agrupacion_homologada_imed == 0) {

      $qExamenesHijo = $mysqli->prepare("SELECT ea.COD_EXAMEN, pe.PRECIO
      FROM examenes_atenciones ea
      LEFT JOIN (
        SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID_PEX
        FROM precios_examenes
        WHERE ID_EMPRESA = ?
        GROUP BY COD_EXAMEN
      ) max_pe ON ea.COD_EXAMEN = max_pe.COD_EXAMEN
      LEFT JOIN precios_examenes pe ON max_pe.COD_EXAMEN = pe.COD_EXAMEN AND max_pe.MAX_ID_PEX = pe.ID_PEX
      WHERE ea.ID_ATENCION = ? AND ea.PADRE = ?
      AND ea.COD_EXAMEN NOT IN ('05.05.504', '05.05.604', '05.06.170', '05.06.070', '00.00.182', '00.00.183', '00.00.184', '00.00.185', '00.00.186', '00.00.187', '00.00.188', '00.00.189', '00.00.190', '00.00.191', '00.00.192', '00.00.193', '00.00.194', '00.00.195', '00.00.196', '00.00.197')"); # REQ DE ANDONI (SE COBRAN 4 DE LOS 6 EXÁMENES HIJO DE 05.05.004 - ANTICUERPOS ANTI ENA)
      $qExamenesHijo->bind_param('iis', $_POST['id_prevision'], $_POST['id_atencion'], $cod_examen);
      $qExamenesHijo->execute();
      $qExamenesHijo->bind_result($cod_examen_hijo, $precio_examen_hijo);
      $qExamenesHijo->store_result();
      while ($qExamenesHijo->fetch()) {
        if ($precio_examen_hijo) {
          $LisPrestAutMulType[] = [
            "CodPrestacion" => $cod_examen_hijo,
            "CodItem" => "0",
            "Cantidad" => 1,
            "RecargoHora" => "N",
            "MontoPrest" => $precio_examen_hijo,
            # "InfAdicional" => ""
          ];
        }
      }
      $qExamenesHijo->close();

    } elseif ($flag_agrupacion == "N" || ($flag_agrupacion == "S" && $flag_agrupacion_homologada_imed == 1)) {
      if ($precio_examen) {
        $LisPrestAutMulType[] = [
          "CodPrestacion" => $cod_examen,
          "CodItem" => "0",
          "Cantidad" => 1,
          "RecargoHora" => "N",
          "MontoPrest" => $precio_examen,
          # "InfAdicional" => ""
        ];
      }
    }

  }
  $qExamenesAtencion->close();

  $ListConveniosType[] = [
    "RutConvenio" => formatearRutImed("78385630-1"), # rut etcheverry
    "CorrConvenio" => 0,
    "RutTratante" => "0078385630-1", # rut etcheverry
    "RutSolic" => formatearRutImed($rutMedico),
    "NomSolic" => $nombreMedico,
    "CodEspecia" => "02620", # Laboratorio Clínico
    "RutBenef" => formatearRutImed($_POST['rut_paciente']),
    "RutCajero" => formatearRutImed($usuario_rut),
    "IndUrgencia" => "N",
    "CodTipoTratamiento" => 1, # Sin tratamiento (venta normal)
    "FecIniTratamiento" => 19000101, # Si existe tratamiento informar (AAAAMMDD), sino asignar fecha defecto 19000101
    "FecTerTratamiento" => 19000101, # Si existe tratamiento informar (AAAAMMDD), sino asignar fecha defecto 19000101
    "CantDias" => 0, # Obligatorio cuando CodTipoTratamiento es mayor a 1
    "FolioAntecedente" => 0, # Dudas
    "LisPrestAut" => $LisPrestAutMulType
  ];

  $params = [
    "CodUsuario" => "78385630-1",
    "CodClave" => "78385630",
    "CodFinanciador" => $_POST['cod_financiador_imed'],
    "CodLugar" => $_POST['id_centro_contacto'],
    "UrlRetExito" => $urlExitoImed,
    "UrlRetError" => $urlErrorImed,
    "ListConvenios" => $ListConveniosType
  ];

  if ($_POST["id_atencion"] == 581146) {
    print_r($params);
    exit(0);
  }


  try {
    $client = new SoapClient($urlWsdlImed, ['trace' => 1]);
    $res = $client->__soapCall("VtaBonInterMul", $params);
    // print_r($res);
    if ($res['CodError'] != 0) mostrarMensajeError("Error desde Imed:<br>" . $res['GloError']); # REVISA SI IMED RETORNA UN ERROR Y MUESTRA LA GLOSA
    $qUpdateAtencion = $mysqli->prepare("UPDATE atenciones SET NUM_TRANSACCION_IMED = ?, COD_AUDITORIA_IMED = ?, CODIGO_HUELLERO_IMED = ? WHERE ID_ATENCION = ? LIMIT 1");
    $qUpdateAtencion->bind_param('isii', $res['NumTransac'], $res['CodAuditoria'], $_POST['id_centro_contacto'], $_POST['id_atencion']);
    $qUpdateAtencion->execute();
    $qUpdateAtencion->close();
    $respuesta = array("exito" => true, "NumTransac" => $res['NumTransac'], "CodAuditoria" => $res['CodAuditoria']); # SE RETORNA NUM_TRANSACCION Y COD_AUDITORIA DE IMED
    echo json_encode($respuesta);
    exit(0);
  } catch (SoapFault $sf) {
    mostrarMensajeError($sf->getMessage());
  }
}

########################################################################################################################################################################

if (isset($_POST['obtenerBonos']) && $_POST['obtenerBonos'] != "") {

  $params = [
    "CodUsuario" => "78385630-1",
    "CodClave" => "78385630",
    "NumTransac" => $_POST['num_transaccion']
  ];

  // print_r($params);

  try {
    $client = new SoapClient($urlWsdlImed, ['trace' => 1]);
    $res = $client->__soapCall("ObtBonInterMul", $params);
    // print_r($res);
    // exit(0);

    $cod_financiador_respuesta = $res["LisVenConv"]->LisVenConvType->CodFinanciador; # Financiador es como IMED llama a las previsiones
    if ($_POST['cod_financiador_imed'] != $cod_financiador_respuesta) mostrarMensajeError("Código de financiador de la atención no corresponde al código asociado a los bonos emitidos");

    $total_bonos = 0;
    $total_otras_bonificaciones = 0;
    $total_copago = 0;
    $total_pagos_prorrateados = 0;
    $lista_bonos = parsearLista($res["LisVenConv"]->LisVenConvType->ListaBonosMul->ListaBonosMulType);
    foreach ($lista_bonos as $key_b => $bono) {
      $fecha_pago = date("Y-m-d", time()); # FECHA ACTUAL
      $flag_elec = 1; # FLAG_ELEC
      $folio_bono = $bono->FolioBono; # NRO_DOCTO

      # Lista Prestaciones #
      $monto_bono = 0;
      $monto_copago = 0;
      $monto_otras_bonificaciones = 0;
      $lista_prestaciones = parsearLista($bono->LisPrestVta->LisPrestVtaType);
      foreach ($lista_prestaciones as $key_p => $prestacion) {
        $monto_copago += $prestacion->MontoCopago;
        $monto_bono += $prestacion->MontoBon;
        # Lista Bonificaciones Prestación #
        $lista_otras_bonificaciones_prestacion = parsearLista($prestacion->ListaOtrasBon->ListaOtrasBonType);
        foreach ($lista_otras_bonificaciones_prestacion as $key_ba => $bonificacion_adicional) {
          $monto_otras_bonificaciones += $bonificacion_adicional->MtoBonAdic;
        }
      }
      // echo "monto_bono $key_b: $monto_bono<br>";
      // echo "monto_otras_bonificaciones $key_b: $monto_otras_bonificaciones<br>";
      // echo "monto_copago $key_b: $monto_copago<br><br>";

      # Pagos Prorrateados (Excedente y otros) #
      $lista_pagos_prorrateado = parsearLista($bono->ListaPagPro->ListaPagProType);
      foreach ($lista_pagos_prorrateado as $key_pp => $pago_prorrateado) {
        $qInsertBono = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, ID_PREVISION, FLAG_ELEC, MONTO_PAGADO, NRO_DOCTO, ID_CAJERO, CIERRE_INGRESO, FLAG_CIERRECAJA, COBRADO, FORMA_PAGO_IMED)
        VALUES (?, ?, ?, 1, ?, ?, ?, ?, ?, 'N', 'N', 'N', ?)");
        $qInsertBono->bind_param('iisiiisii', $_POST['id_atencion'], $_POST['id_centro_contacto'], $fecha_pago, $_POST['id_prevision'], $flag_elec, $pago_prorrateado->MtoTransacP, $folio_bono, $usuario_id, $pago_prorrateado->CodForPagP);
        $qInsertBono->execute();
        $qInsertBono->close();
        $total_pagos_prorrateados += $pago_prorrateado->MtoTransacP;
      }

      # Insertar Monto Bono #
      $qInsertBono = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, ID_PREVISION, FLAG_ELEC, MONTO_PAGADO, NRO_DOCTO, ID_CAJERO, CIERRE_INGRESO, FLAG_CIERRECAJA, COBRADO)
      VALUES (?, ?, ?, 1, ?, ?, ?, ?, ?, 'N', 'N', 'N')");
      $qInsertBono->bind_param('iisiiisi', $_POST['id_atencion'], $_POST['id_centro_contacto'], $fecha_pago, $_POST['id_prevision'], $flag_elec, $monto_bono, $folio_bono, $usuario_id);
      $qInsertBono->execute();
      $qInsertBono->close();
      # Insertar Monto Bono Adicional (Seguro) #
      if ($monto_otras_bonificaciones > 0) {
        $qInsertBono = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, ID_PREVISION, FLAG_ELEC, MONTO_PAGADO, NRO_DOCTO, ID_CAJERO, CIERRE_INGRESO, FLAG_CIERRECAJA, COBRADO)
        VALUES (?, ?, ?, 9, ?, ?, ?, ?, ?, 'N', 'N', 'N')");
        $qInsertBono->bind_param('iisiiisi', $_POST['id_atencion'], $_POST['id_centro_contacto'], $fecha_pago, $_POST['id_prevision'], $flag_elec, $monto_otras_bonificaciones, $folio_bono, $usuario_id);
        $qInsertBono->execute();
        $qInsertBono->close();
      }
      # Insertar Monto Copago #
      if ($monto_copago > 0) {
        $qInsertCopago = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, ID_PREVISION, FLAG_ELEC, MONTO_PAGADO, NRO_DOCTO, ID_CAJERO, CIERRE_INGRESO, FLAG_CIERRECAJA, COBRADO, FLAG_COPAGO_BONO)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'N', 'N', 'N', 1)");
        $qInsertCopago->bind_param('iisiiiisi', $_POST['id_atencion'], $_POST['id_centro_contacto'], $fecha_pago, $_POST['forma_pago'], $_POST['id_prevision'], $flag_elec, $monto_copago, $folio_bono, $usuario_id);
        $qInsertCopago->execute();
        $qInsertCopago->close();
      }
      # Actualizar Montos Totales
      $total_bonos += $monto_bono;
      $total_otras_bonificaciones += $monto_otras_bonificaciones;
      $total_copago += $monto_copago;
    }

    $monto_pagado_atencion = $total_bonos + $total_otras_bonificaciones + $total_copago + $total_pagos_prorrateados;
    // echo "total_bonos: $total_bonos<br>";
    // echo "total_otras_bonificaciones: $total_otras_bonificaciones<br>";
    // echo "total_copago: $total_copago<br>";
    // echo "total_pagos_prorrateados: $total_pagos_prorrateados<br>";
    // echo "monto_pagado_atencion: $monto_pagado_atencion<br>";
    $qUpdateMontoPagado = $mysqli->prepare("UPDATE atenciones SET FLAG_PAGO_IMED = 1, MONTO_PAGADO = MONTO_PAGADO + ? WHERE ID_ATENCION = ?");
    $qUpdateMontoPagado->bind_param('ii', $monto_pagado_atencion, $_POST['id_atencion']);
    $qUpdateMontoPagado->execute();
    $qUpdateMontoPagado->close();

    $respuesta = array("exito" => true);
    echo json_encode($respuesta);
    exit(0);
  } catch (SoapFault $sf) {
    mostrarMensajeError($sf->getMessage());
  }
}

########################################################################################################################################################################

if (isset($_POST['anularBonos']) && $_POST['anularBonos'] != "") {

  $qFolios = $mysqli->prepare("SELECT DISTINCT NRO_DOCTO FROM pagos WHERE ID_ATENCION = ? AND FLAG_BONO_ANULADO = 'N' AND NRO_DOCTO != ''");
  $qFolios->bind_param('i', $_POST['id_atencion']);
  $qFolios->execute();
  $qFolios->bind_result($nro_docto);
  $qFolios->store_result();

  while ($qFolios->fetch()) {

    $params = [
      "CodUsuario" => "78385630-1",
      "CodClave" => "78385630",
      "CodFinanciador" => $_POST['cod_financiador_imed'],
      "CodLugar" => $_POST['id_centro_contacto'],
      "FolioBono" => $nro_docto,
      "RutCajero" => formatearRutImed($usuario_rut)
    ];

    // print_r($params);
    // exit(0);

    try {
      $client = new SoapClient($urlWsdlImed, ['trace' => 1]);
      $res = $client->__soapCall("AnulBonInterfaz", $params);

      if ($res['CodError'] != 0) mostrarMensajeError("Error al anular el bono con folio: $nro_docto<br>Error: " . $res['GloError']);

      $qPagosBono = $mysqli->prepare("SELECT ID_PAGOS, MONTO_PAGADO FROM pagos WHERE ID_ATENCION = ? AND NRO_DOCTO = ?");
      $qPagosBono->bind_param('ii', $_POST['id_atencion'], $nro_docto);
      $qPagosBono->execute();
      $qPagosBono->bind_result($id_pago, $monto_pagado);
      $qPagosBono->store_result();
      while ($qPagosBono->fetch()) {
        $qUpdateFlagBonoAnulado = $mysqli->prepare("UPDATE pagos SET FLAG_BONO_ANULADO = 'S' WHERE ID_PAGOS = ?");
        $qUpdateFlagBonoAnulado->bind_param('i', $id_pago);
        $qUpdateFlagBonoAnulado->execute();
        $qUpdateFlagBonoAnulado->close();

        $qUpdateMontoPagado = $mysqli->prepare("UPDATE atenciones SET FLAG_PAGO_IMED = 0, MONTO_PAGADO = MONTO_PAGADO - ? WHERE ID_ATENCION = ?");
        $qUpdateMontoPagado->bind_param('ii', $monto_pagado, $_POST['id_atencion']);
        $qUpdateMontoPagado->execute();
        $qUpdateMontoPagado->close();
      }
      $qPagosBono->close();
    } catch (SoapFault $sf) {
      mostrarMensajeError($sf->getMessage());
    }
  }
  $qFolios->close();

  $respuesta = array("exito" => true, "mensaje" => $res['GloError']);
  echo json_encode($respuesta);
  exit(0);
}
