<?php
$pagina = 65; # Cotizaciones (ver listado, modificación y eliminación)
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel">Cambiar Paciente</h4>
</div>

<div class="modal-body">
  <form id="cambiarPaciente" class="smart-form" action="sql_cod.php" method="post">
    <section>
      <input id="busquedaPAC" name="id_paciente" style="width: -webkit-fill-available;">
    </section>
    <input type="hidden" name="cambiarPaciente" value="cambiarPaciente">
    <input type="hidden" name="id_cotizacion" value="<?= $_GET['id_cot'] ?>">
  </form>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cancelar
  </button>
  <a class="btn btn-primary btn-sm pull-right btn-grabar">
    <i class="fa fa-save"></i> Grabar
  </a>
</div>

<script src="<?= ASSETS_URL ?>/js/plugin/rut/jquery.Rut.min.js"></script>

<script>
  $(document).ready(function() {
    $('.btn-grabar').on('click', function() {
      $.post('sql_cod.php', $('#cambiarPaciente').serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    });

    $('#busquedaPAC').select2({
      placeholder: "Buscar nombre o RUT de paciente",
      minimumInputLength: 1,
      formatInputTooShort: function() {
        return 'Ingrese uno o mas caracteres';
      },
      formatSearching: "Buscando...",
      formatNoMatches: "No se encontraron resultados",
      ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
        type: "POST",
        url: "../o_atenciones/ajax_PAC.php",
        dataType: 'json',
        quietMillis: 100,
        data: function(term, page) {
          return {
            nombre: term, // search term
          };
        },
        results: function(data) {
          return {
            results: $.map(data, function(item) {
              return {
                text: item.nombre + " - " + item.rut,
                id: item.id,
              }
            })
          };
        },
        cache: true
      },
      escapeMarkup: function(m) {
        return m;
      } // we do not want to escape markup since we are displaying html in results
    });
  });
</script>