<?php
define('PERMITIDO', true);
$pantalla_actual = 'MOD_COT';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

function httpPost($url, $data)
{
  $curl = curl_init($url);
  curl_setopt($curl, CURLOPT_POST, true);
  curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  $response = curl_exec($curl);
  curl_close($curl);
  return $response;
}

$idCotizacion = isset($_GET['id_cot']) ? $_GET['id_cot'] : "-1";

$qCotizacion = $mysqli->prepare("SELECT a.FECHA, a.HORA, a.FECHA_ULT_REGLA, a.MONTO_ATENCION, a.MONTO_DESCUENTO, a.PCTJE_DESCUENTO, a.ID_CLIENTE, a.ID_MEDICO, 
a.ID_PREVISION, a.ID_CONVENIO, a.NIVEL_URGENCIA, a.MOTIVO_PRIORIZACION, a.TURNO_DIALISIS, a.OBS, a.FECHA_INF, a.FLAG_ACEPTA_C, a.ID_CENTRO_CONTACTO, a.COD_DIAGNOSTICO, a.URl_IMG_ORDEN, 
p.NRO_RUT, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT), CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), DATE_FORMAT(p.FECHA_NACIMIENTO, '%d-%m-%Y'), p.DIRECCION, p.FONO_1, p.GENERO, p.PASAPORTE,
ep.NOMBRE_E, CONCAT_WS(' ', m.NOMBRES, m.APELLIDO_PATERNO, m.APELLIDO_MATERNO), cg.DESCRIPCION_CG,
ea.NOMBRE_E, CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO)
FROM cotizaciones a
INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN personas m ON m.ID_PERSONA = a.ID_MEDICO
LEFT JOIN empresas ep ON ep.ID_EMPRESA = p.ID_PREVISION
LEFT JOIN empresas ea ON ea.ID_EMPRESA = a.ID_PREVISION
LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
LEFT JOIN codigos_generales cg ON cg.CODIGO = m.ESPECIALIDAD AND cg.COD_TABLA = 'SIS_ESPECI'
WHERE a.ID_COTIZACION = ?");
$qCotizacion->bind_param('i', $idCotizacion);
$qCotizacion->execute();
$qCotizacion->bind_result(
  $ate_fecha,
  $ate_hora,
  $ate_fechaUltimaRegla,
  $ate_montoAtencion,
  $ate_montoDescuento,
  $ate_porcentajeDescuento,
  $ate_idPacienteAtencion,
  $ate_idMedicoAtencion,
  $ate_idPrevisionAtencion,
  $ate_idConvenioAtencion,
  $ate_nivelUrgenciaAtencion,
  $ate_motivoPriorizacionAtencion,
  $ate_turnoDialisisAtencion,
  $ate_obs,
  $ate_fechaInf,
  $ate_flagAceptaC,
  $ate_idCentroContacto,
  $ate_codDiagnostico,
  $ate_urlImgOrden,
  $ate_nroRut,
  $ate_rut,
  $ate_nombrePaciente,
  $ate_fechaNacimiento,
  $ate_direccionPaciente,
  $ate_fonoPaciente,
  $ate_generoPaciente,
  $ate_pasaportePaciente,
  $ate_nombrePrevisionPaciente,
  $ate_nombreMedico,
  $ate_especialidadMedico,
  $ate_nombrePrevisionAtencion,
  $ate_usuarioCreadorAtencion
);
$qCotizacion->store_result();
$totalRows = $qCotizacion->num_rows;
$qCotizacion->fetch();
$qCotizacion->close();

$options_ccto = "";
$qOptionsCentroContacto = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE, FLAG_DIALISIS FROM centros_contacto");
$qOptionsCentroContacto->execute();
$qOptionsCentroContacto->bind_result($idCentroContacto, $nombreCentroContacto, $flagDialisis);
$qOptionsCentroContacto->store_result();
while ($qOptionsCentroContacto->fetch()) {
  $selected = $ate_idCentroContacto == $idCentroContacto ? "selected" : "";
  $options_ccto .= "<option value='$idCentroContacto' data-dialisis='$flagDialisis' $selected> $nombreCentroContacto </option>";
}
$qOptionsCentroContacto->close();

$options_diagnostico = "";
$qOptionsDiagnostico = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_DIAGNO'");
$qOptionsDiagnostico->execute();
$qOptionsDiagnostico->bind_result($codigoDiagnostico, $descripcionDiagnostico);
$qOptionsDiagnostico->store_result();
while ($qOptionsDiagnostico->fetch()) {
  $selected = $ate_codDiagnostico == $codigoDiagnostico ? "selected" : "";
  $options_diagnostico .= "<option value='$codigoDiagnostico' $selected> $descripcionDiagnostico </option>";
}
$qOptionsDiagnostico->close();

$options_convenio = "";
$qOptionsConvenio = $mysqli->prepare("SELECT ID_EMPRESA, NBR FROM empresas WHERE FLAG_CONVENIO = 'S'");
$qOptionsConvenio->execute();
$qOptionsConvenio->bind_result($idConvenio, $nbrConvenio);
$qOptionsConvenio->store_result();
while ($qOptionsConvenio->fetch()) {
  $selected = $ate_idConvenioAtencion == $idConvenio ? "selected" : "";
  $options_convenio .= "<option value='$idConvenio' $selected> $nbrConvenio </option>";
}
$qOptionsConvenio->close();

$options_motivosPriorizacion = "";
$qOptionsMotivoPriorizacion = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_MOTPRIO'");
$qOptionsMotivoPriorizacion->execute();
$qOptionsMotivoPriorizacion->bind_result($codigoMotivoPriorizacion, $descripcionMotivoPriorizacion);
$qOptionsMotivoPriorizacion->store_result();
while ($qOptionsMotivoPriorizacion->fetch()) {
  $selected = $ate_motivoPriorizacionAtencion == $codigoMotivoPriorizacion ? "selected" : "";
  $options_motivosPriorizacion .= "<option value='$codigoMotivoPriorizacion' $selected> $descripcionMotivoPriorizacion </option>";
}
$qOptionsMotivoPriorizacion->close();

$options_nivelUrgencia = "";
$qOptionsNivelUrgencia = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_NIVURG'");
$qOptionsNivelUrgencia->execute();
$qOptionsNivelUrgencia->bind_result($codigoNivelUrgencia, $descripcionNivelUrgencia);
$qOptionsNivelUrgencia->store_result();
while ($qOptionsNivelUrgencia->fetch()) {
  $selected = $ate_nivelUrgenciaAtencion == $codigoNivelUrgencia ? "selected" : "";
  $options_nivelUrgencia .= "<option value='$codigoNivelUrgencia' $selected> $descripcionNivelUrgencia </option>";
}
$qOptionsNivelUrgencia->close();

$options_turnosDialisis = "";
$qOptionsTurnosDialisis = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_TURDIA'");
$qOptionsTurnosDialisis->execute();
$qOptionsTurnosDialisis->bind_result($codigoTurnoDialisis, $descripcionTurnoDialisis);
$qOptionsTurnosDialisis->store_result();
while ($qOptionsTurnosDialisis->fetch()) {
  $selected = $ate_turnoDialisisAtencion == $codigoTurnoDialisis ? "selected" : "";
  $options_turnosDialisis .= "<option value='$codigoTurnoDialisis' $selected> $descripcionTurnoDialisis </option>";
}
$qOptionsTurnosDialisis->close();

# el convenio (de la atención) tiene mayor prioridad que la previsión (de la atención)
$idemp = $ate_idConvenioAtencion != 0 ? $ate_idConvenioAtencion : $ate_idPrevisionAtencion;

# suma de precios de los examenes de la cotización (monto total)
$montoTotal = 0;
if (in_array($idemp, [17, 18, 19, 20, 21, 22], true)) {
  $qMontoCotizacionIsapre = $mysqli->prepare("SELECT ec.PRECIO_EXAMEN, em.NBR
    FROM examenes_cotizaciones ec
    LEFT JOIN examenes ex ON ec.COD_EXAMEN = ex.COD_INTERNO
    LEFT JOIN empresas em ON ec.PREV = em.ID_EMPRESA
    WHERE ID_COTIZACION = ? AND ec.F_HIJO IS NULL");
  $qMontoCotizacionIsapre->bind_param('i', $idCotizacion);
  $qMontoCotizacionIsapre->execute();
  $qMontoCotizacionIsapre->bind_result($mt_precioExamen, $mt_prevision);
  while ($qMontoCotizacionIsapre->fetch()) {
    if ($mt_prevision != NULL) $montoTotal += $mt_precioExamen * (100 - $ate_porcDescuento) / 100;
    else                       $montoTotal += $mt_precioExamen;
  }
  $qMontoCotizacionIsapre->close();
} else {
  $qMontoCotizacion = $mysqli->prepare("SELECT SUM(PRECIO_EXAMEN)
    FROM examenes_cotizaciones
    WHERE ID_COTIZACION = ?");
  echo $mysqli->error;
  $qMontoCotizacion->bind_param('i', $idCotizacion);
  $qMontoCotizacion->execute();
  $qMontoCotizacion->bind_result($sum_precioExamen);
  $qMontoCotizacion->fetch();
  $montoTotal = $sum_precioExamen;
  $qMontoCotizacion->close();
}

$buscar = array(chr(13) . chr(10), "\r\n", "\n", "\r");
$reemplazar = array("", "", "", "");
$ate_direccionPaciente = str_ireplace($buscar, $reemplazar, $ate_direccionPaciente);
ob_start();
?>

<h4><b>Cotización Número: <?= $idCotizacion ?></b></h4>
<div class="well well-sm bg-color-blue txt-color-white text-left" style="margin-top:5px">
  <div class="row">
    <div class="col-md-3">
      Paciente:<br />
      <?= $ate_nombrePaciente ?>
    </div>
    <div class="col-md-2">
      Previsión: <br />
      <?= $ate_nombrePrevisionPaciente; ?>
    </div>
    <div class="col-md-1">
      F. Nacimiento:<br />
      <?= $ate_fechaNacimiento; ?>
    </div>
    <div class="col-md-1">
      Fono:<br />
      <?= $ate_fonoPaciente; ?>
    </div>
    <div class="col-md-3">
      Dirección: <br />
      <?= $ate_direccionPaciente; ?>
    </div>
    <div class="col-md-1">
      <a data-toggle="modal" href="c_paciente.php?id=<?= $ate_idPacienteAtencion . '&id_cot=' . $idCotizacion; ?>" class="btn btn-default btn-sm" data-target="#myModalCambiarP" title="Cambiar Paciente"><i class="fa fa-list"></i>Cambiar</a>
    </div>
    <div class="col-md-1">
      <a data-toggle="modal" href="../m_personas/e_persona.php?id=<?= $ate_idPacienteAtencion . '&id_cot=' . $idCotizacion; ?>" class="btn btn-default btn-sm" data-target="#myModalEditP" title="Modificar registro"><i class="fa fa-edit"></i>Editar</a>
    </div>
  </div>
</div>

<div class="well well-sm bg-color-blueLight txt-color-white text-left" style="margin-top:10px">
  <div class="row">
    <div class="col-md-3">
      Nombre Médico: <br />
      <?= $ate_nombreMedico ?>
    </div>
    <div class="col-md-4">
      Especialidad: <br />
      <?= $ate_especialidadMedico ?>
    </div>
    <div class="col-md-3">
    </div>
    <div class="col-md-1">
      <?php if ($ate_idMedicoAtencion != '') { ?>
        <a data-toggle="modal" href="c_medico.php?id=<?= $ate_idMedicoAtencion . '&id_cot=' . $idCotizacion; ?>" class="btn btn-default btn-sm" data-target="#myModalCambiarP" title="Cambiar Médico"><i class="fa fa-list"></i>Cambiar</a>
      <?php } ?>
    </div>
    <div class="col-md-1">
      <a data-toggle="modal" href="../m_personas/e_persona.php?id=<?= $ate_idMedicoAtencion . '&idat=' . $idCotizacion; ?>" class="btn btn-default btn-sm" data-target="#myModalEditM" title="Modificar registro"><i class="fa fa-edit"></i>Editar</a>
    </div>
  </div>
</div>

<!-- visualización de ordenes médicas para las cotizaciones online (realizadas a través de la app móvil) -->
<?php if ($ate_urlImgOrden) { ?>
  <a class="btn btn-link" data-toggle="collapse" data-target="#collapseImagen">
    <i class="fa fa-eye fa-lg"> Ver orden médica </i>
  </a>
  <div class="collapse" id="collapseImagen">
    <img style="max-height: 700px" src="../assets/ordenes_medicas/<?= $ate_urlImgOrden ?>" alt="Orden médica">
  </div>
  <br>
  <br>
<?php } ?>

<?php if ($totalRows > 0) { ?>
  <form action="sql_cod.php" method="post" name="formModificarCotizacion" id="formModificarCotizacion" class="smart-form" style="margin-top:10px">
    <table class="table table-bordered">
      <tbody>
        <tr>
          <th>Previsión de la Cotización:</th>
          <th> <?= $ate_nombrePrevisionAtencion ?> </th>
          <td colspan="2">
          </td>
        </tr>
        <tr>
          <td width="130">Fecha:</td>
          <td width="250">
            <label class="input">
              <input type="date" class="input-sm" name="FECHA" value="<?= $ate_fecha ?>" />
            </label>
          </td>
          <td width="130">Pre Diagnóstico:</td>
          <td width="250">
            <label class="select">
              <select name="COD_DIAGNOSTICO" class="input-sm">
                <?= $options_diagnostico ?>
              </select> <i></i>
            </label>
          </td>
        </tr>
        <tr>
          <td>Toma de Muestra:</td>
          <td>
            <label class="select">
              <select id="ID_CENTRO_CONTACTO" name="ID_CENTRO_CONTACTO" class="input-sm">
                <?= $options_ccto; ?>
              </select> <i></i>
            </label>
          </td>
          <td>Turno Diálisis: </td>
          <td>
            <label class="select">
              <select id="ID_TURDIA" name="ID_TURDIA" class="input-sm" disabled>
                <option value="0" <?php if ($ate_turnoDialisisAtencion == 0) {
                                    echo "selected=\"selected\"";
                                  } ?>>-</option>
                <?= $options_turnosDialisis ?>
              </select> <i></i>
            </label>
          </td>
        </tr>
        <tr>
          <td>Motivo de Priorización de Atención:</td>
          <td>
            <label class="select">
              <select name="MOTIVO_PRIORIZACION" class="input-sm">
                <?= $options_motivosPriorizacion ?>
              </select> <i></i>
            </label>
          </td>
          <td>Urgencia:</td>
          <td>
            <label class="select">
              <select name="NIVEL_URGENCIA" class="input-sm">
                <?= $options_nivelUrgencia ?>
              </select> <i></i>
            </label>
          </td>
        </tr>
        <tr>
          <td>Consentimiento Revisión Médico: </td>
          <td>
            <label class="checkbox">
              <input name="FLAG_ACEPTA_C" type="checkbox" id="FLAG_ACEPTA_C" value="1" <?php if ($ate_flagAceptaC == 1) echo "checked"; ?> />
              <i></i>
            </label>
            <?php if ($ate_flagAceptaC == 1) echo "<a href='consent_pac_med_PDF.php?idate=$idCotizacion' target='_blank' title='Ver Consentimiento' class='btn btn-link pull-right'><i class='fa fa-file-pdf-o fa-lg txt-color-red'></i> Consentimiento</a>"; ?>
          </td>
          <td>Última Regla:</td>
          <td>
            <label class="input">
              <input name="FECHA_ULT_REGLA" type="date" class="input-sm" value="<?= $ate_fechaUltimaRegla ?>" />
            </label>
          </td>
        </tr>
        <tr>
          <td>Convenio:</td>
          <td>
            <label class="select">
              <select id="ID_CONVENIO" name="ID_CONVENIO" class="input-sm">
                <option value="0" <?php if ($ate_idConvenioAtencion == 0) echo "selected" ?>>-</option>
                <?= $options_convenio ?>
              </select> <i></i>
            </label>
          </td>
          <td>Monto a cobrar a Convenio ($): </td>
          <td>
            <label class="input">
              <input type="text" id="MONTO_CONVENIO" name="MONTO_CONVENIO" value="<?= $ate_montoConvenio ?>" class="input-sm" required="required" min="0" />
            </label>
          </td>
        </tr>
        <tr>
          <td>Descuento/Copago ($): </td>
          <td>
            <label class="input">
              <input type="text" name="MONTO_DESCUENTO" class="input-sm" value="<?= $ate_montoDescuento ?>" size="20" required="required" min="0" />
            </label>
          </td>
          <td>Descuento (%): </td>
          <td>
            <label class="input">
              <input type="text" name="PCTJE_DESCUENTO" class="input-sm" value="<?= $ate_porcentajeDescuento ?>" required min="0" />
            </label>
          </td>
        </tr>
        <tr>
          <td>Monto Atención ($): </td>
          <td>
            <label class="input">
              <input name="MONTO_ATENCION" type="text" class="input-sm" value="<?= $montoTotal ?>" readonly required />
            </label>
          </td>
          <td>Orden Médica:</td>
          <td>
            <?php if ($ordenMedica != null) echo "<a href='$ordenMedica' target='_blank' title='Ver Orden Médica' class='btn btn-link'><i class='fa fa-file-pdf-o fa-lg txt-color-green'></i> Orden Médica</a>"; ?>
          </td>
        </tr>
        <tr>
          <td>Observaciones:</td>
          <td colspan="3">
            <label class="textarea textarea-resizable">
              <textarea name="OBS" class="custom-scroll" cols="40" rows="2"><?= $ate_obs ?></textarea>
            </label>
          </td>
        </tr>
        <input type="hidden" name="MM_update" value="formModificarCotizacion" />
        <input type="hidden" name="ID_COTIZACION" value="<?= $idCotizacion; ?>" />
      </tbody>
    </table>
  </form>

  <table class="table">
    <tr>
      <td colspan="4">
        <div class="pull-left">
          <a type="button" class="btn btn-sm btn-danger btn-eliminar" data-id="<?= $idCotizacion ?>">Eliminar Cotización</a>
          <div class="note"> COTIZACIÓN CREADA POR: <?= $ate_usuarioCreadorAtencion ?> </div>
        </div>
        <div class="pull-right">
          <a class="btn btn-sm btn-primary btn-grabarAT" data-form="#formModificarCotizacion">Guardar Cambios</a>
        </div>
      </td>
    </tr>
  </table>
<?php } ?>
<input type="hidden" id="idCotizacion" value="<?= $idCotizacion ?>" />
<input type="hidden" id="idemp" value="<?= $idemp ?>" />
<input type="hidden" id="ate_porcentajeDescuento" value="<?= $ate_porcentajeDescuento ?>" />

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a data-toggle="modal" href="md_comprobantes.php?idate=' . $idCotizacion . '" data-target="#md_comprobantes" title="Comprobantes"><em>Comprobantes</em></a>',
      "class" => 'smart-form'
    ),
    // array(
    //   "id" => "toolbar-id",
    //   "content" => '<a target="_blank" href="pdf_comprobanteCotizacion.php?id_cot=' . $idCotizacion . '"><em>Comprobante</em></a>',
    //   "class" => 'smart-form'
    // ),
    // array(
    //   "id" => "toolbar-id",
    //   "content" => '<a target="_blank" href="pdf_comprobanteCotizacionPrecio.php?id_cot=' . $idCotizacion . '&idprev=' . $idemp . '&pctje_descuento=' . $ate_porcDescuento . '"><em>Comprobante $</em></a>',
    //   "class" => 'smart-form'
    // ),
    array(
      "id" => "toolbar-id",
      "content" => "<a data-toggle='modal' data-target='#md_examenesCotizacion' href='md_examenesCotizacion.php?idcot=$idCotizacion&idemp=$idemp&g=$ate_generoPaciente&idcc=$ate_idCentroContacto&pctje_descuento=$ate_porcentajeDescuento'><em>Exámenes de Cotización</em></a>",
      "class" => 'smart-form'
    )
  )
);

$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

  <!-- MODALS  -->
  <div class="modal fade Edit" id="myModalEditP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="myModalCambiarP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="myModalEditM" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="myModalCambiarM" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="md_examenesCotizacion" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:140%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="md_comprobantes" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>
</div>

<?php include("../inc/footer.php"); ?>
<?php include("../inc/scripts.php"); ?>

<script>
  $(document).ready(function() {
    $(".btn-grabarAT").on("click", function() {
      $(this).attr('disabled', 'disabled'); // $(this).prop('disabled', true);
      var form = $(this).data("form");
      $.post($(form).attr("action"), $(form).serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          $(this).removeAttr('disabled'); // $(this)("disabled", false);
          error(data.mensaje);
        }
      }, 'json');
    });

    $(".btn-eliminar").on("click", function() {
      if (confirm("Desea eliminar esta cotización?")) {
        var id = $(this).data("id");
        $.post("sql_cod.php", {
          id_cot: id,
          eliminar_cot: 1
        }, function(data) {
          if (data.exito) {
            exito();
            window.location.href = "l_cotizaciones.php";
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    var dialisis = $('#ID_CENTRO_CONTACTO option:selected').attr('data-dialisis');
    if (dialisis == 'S') {
      $('#ID_TURDIA').removeAttr('disabled');
    } else {
      $('#ID_TURDIA').attr('disabled', 'disabled');
    }

    $('#ID_CENTRO_CONTACTO').on('change', function() {
      var dialisis = $('#ID_CENTRO_CONTACTO option:selected').attr('data-dialisis');
      if (dialisis == 'S') {
        $('#ID_TURDIA').removeAttr('disabled');
      } else {
        $('#ID_TURDIA').attr('disabled', 'disabled');
      }
      $('#ID_TURDIA').val('0');
    });

    if ($('#ID_CONVENIO').val() != 0) $('#MONTO_CONVENIO').removeAttr('disabled');
    else $('#MONTO_CONVENIO').attr('disabled', 'disabled');

    $('#ID_CONVENIO').on('change', function() {
      if ($(this).val() != 0)
        $('#MONTO_CONVENIO').removeAttr('disabled');
      else {
        $('#MONTO_CONVENIO').attr('disabled', 'disabled');
        $('#MONTO_CONVENIO').val(0);
      }
    });


    function popup(theURL) {
      window.open(theURL, 'Popup', 'status=yes, scrollbars=yes, resizable=yes, width=1050, height=600');
    }
  });
</script>

<?php
include("../inc/google-analytics.php");
?>