<?php
date_default_timezone_set('America/Santiago');

function verificarDiaHabil($datetime_atencion, $maxHorasProcesoAtencion) {

	$feriados = ['01-01', '10-04', '11-04', '26-04', '01-05', '21-05', '07-06', '29-06', '16-07', '15-08', '18-09', '19-09', '12-10', '25-10', '31-10', '01-11', '08-12', '25-12'];

	if ($maxHorasProcesoAtencion <= 24 && in_array($datetime_atencion->format('N'), ['7'])) return false;
  if ($maxHorasProcesoAtencion > 24 && in_array($datetime_atencion->format('N'), ['6', '7'])) return false;
	if (in_array($datetime_atencion->format('d-m'), $feriados)) return false;

  return true;
}

function calcularFechaRetiroCotizacion($id_cotizacion) {
	global $mysqli;

	$qDatosAtencion = $mysqli->prepare("SELECT CONCAT_WS(' ', FECHA, HORA) FROM cotizaciones WHERE ID_COTIZACION = ?");
	$qDatosAtencion->bind_param("i", $id_cotizacion);
	$qDatosAtencion->execute();
	$qDatosAtencion->bind_result($fechaHoraCotizacion);
	$qDatosAtencion->store_result();
	$qDatosAtencion->fetch();
	$qDatosAtencion->close();
	$datetime_cotizacion = DateTime::createFromFormat('Y-m-d H:i:s', $fechaHoraCotizacion);
	# $datetime_atencion->add(new DateInterval('P1D'));

	$qMaxHorasProceso = $mysqli->prepare("SELECT MAX(e.HORAS_PROCESO)	
	FROM examenes_cotizaciones ec	
	INNER JOIN examenes e ON ec.COD_EXAMEN = e.COD_INTERNO
	WHERE ID_COTIZACION = ?");
	$qMaxHorasProceso->bind_param("i", $id_cotizacion);
	$qMaxHorasProceso->execute();
	$qMaxHorasProceso->bind_result($maxHorasProcesoCotizacion);
	$qMaxHorasProceso->store_result();
	$qMaxHorasProceso->fetch();
	$qMaxHorasProceso->close();

	$auxHorasProceso = $maxHorasProcesoCotizacion;
	while ($auxHorasProceso > 0) {
		if ($auxHorasProceso >= 12) {
			$horas_a_sumar = 12;
			$auxHorasProceso -= 12;
		} else {
			$horas_a_sumar = $auxHorasProceso;
			$auxHorasProceso = 0;
		}

		$intervalo = new DateInterval('PT' . $horas_a_sumar . 'H');
		$datetime_cotizacion->add($intervalo);

		while (!verificarDiaHabil($datetime_cotizacion, $maxHorasProcesoCotizacion)) {
			$dia_completo = new DateInterval('P1D');
			$datetime_cotizacion->add($dia_completo);
		}
	}

	$datetime_cotizacion->setTime(12, 0);
	return $datetime_cotizacion;
}
?>
