<?php
$pagina = 9;
define("PERMITIDO", true);
require_once("../inc/init.php");
$fechaActual = date("Y-m-d");
$horaActual = date("H:i:s");
$fechaHoraActual = $fechaActual . " " . $horaActual;

if (isset($_POST["formGenerarHojaTrabajo"]) && $_POST["formGenerarHojaTrabajo"] != "") {
	$qInsertHojaTrabajo = $mysqli->prepare("INSERT INTO hojas_trabajo (AREA, CONVENIO, LOCAL, FECHA, HORA, FECHAHORA) VALUES (?, ?, ?, ?, ?, ?)");
	$qInsertHojaTrabajo->bind_param("ssssss", $_POST["area"], $_POST["convenio"], $_POST["local"], $fechaActual, $horaActual, $fechaHoraActual);
	$qInsertHojaTrabajo->execute();
	$id_nuevaHojaTrabajo = $mysqli->insert_id;
	$qInsertHojaTrabajo->close();

	$ids_examenes_atencion = implode(",", $_POST["ID_EXATE"]);
	# echo $ids_examenes_atencion;
	$qUpdateExamenes = $mysqli->prepare("UPDATE examenes_atenciones SET CORRELATIVO_HOJA_T = ? WHERE FIND_IN_SET(ID_EXATE, ?) > 0");
	$qUpdateExamenes->bind_param("is", $id_nuevaHojaTrabajo, $ids_examenes_atencion);
	$qUpdateExamenes->execute();
	$qUpdateExamenes->close();

	$respuesta = array("exito" => true, "mensaje" => "Hoja de trabajo generada correctamente", "id_hoja" => $id_nuevaHojaTrabajo);
	echo json_encode($respuesta);
}

if (isset($_POST['eliminarExamen']) && $_POST['eliminarExamen'] != "") {
		#echo "asd: {$_POST['idExamen']}";
		$qDeletePadre = $mysqli->prepare("DELETE FROM examenes_atenciones WHERE ID_EXATE = ? LIMIT 1"); 
		$qDeletePadre->bind_param("i", $_POST['idExamen']);
		$qDeletePadre->execute();
		$qDeletePadre->close();
		echo json_encode(array('exito' => true, 'mensaje' => 'Examen eliminado correctamente'));
		exit(0);
}
