<?php
define('PERMITIDO', true);

$pantalla_actual = 'TOM_REC_MUE_COD_BARRAS';

require_once __DIR__ . '/../inc/init.php';
require_once __DIR__ . '/../inc/config.ui.php';
require_once __DIR__ . '/../inc/header.php';
require_once __DIR__ . '/../inc/nav.php';

$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = 'your_style.css';

$sql_responsables = "SELECT u.ID_USUARIO, u.USUARIO, u.NOMBRES, u.APELLIDO_PATERNO 
FROM usuarios u 
WHERE u.ACTIVO = 'S' AND u.ID_USUARIO != 1 AND u.PERFIL NOT IN ('MEDICO', 'MEDICO_ASOCIADO', 'EXTERNO', 'PACIENTE', '') 
ORDER BY u.USUARIO ASC";
$resultado_responsables = $mysqli->query($sql_responsables);

$opciones_responsables = '';
while ($responsable = $resultado_responsables->fetch_assoc()) {
	$usuario_responsable = mb_strtoupper($responsable['USUARIO'], 'UTF-8');
	$nombre_responsable = ($responsable['NOMBRES'] == null || $responsable['NOMBRES'] == '') ? '' : ' (' . $responsable['NOMBRES'] . ' ' . $responsable['APELLIDO_PATERNO'] . ')';
	$opciones_responsables .= '<option value="' . $responsable['ID_USUARIO'] . '">' . $usuario_responsable . $nombre_responsable . '</option>';
}

ob_start();
?>

<form id="formulario-grabar" action="sql_cod_tm_rm_cod_barras.php" method="post">
	<h4>Toma de muestra <input type="checkbox" id="tm" value="true" /></h4>
	<br>
	<div class="row">
		<div class="col-md-1">
			<strong>Fecha:</strong>
		</div>
		<div class="col-md-2">
			<input type="date" class="form-control" id="fecha-tm" name="fecha-tm" value="<?= date('Y-m-d'); ?>" required />
		</div>

		<div class="col-md-1">
			<strong>Hora:</strong>
		</div>
		<div class="col-md-2">
			<input type="time" class="form-control" id="hora-tm" name="hora-tm" value="<?= date('H:i'); ?>" required />
		</div>
		<div class="col-md-2">
			<strong>Responsable:</strong>
		</div>
		<div class="col-md-3">
			<select class="form-control" id="responsable-tm" name="responsable-tm" required>
				<option value="">--Seleccione--</option>
				<?= $opciones_responsables ?>
			</select>
		</div>
	</div>

	<hr>
	<h4>Recepción de muestra <input type="checkbox" id="rm" value="true" checked /></h4>
	<br>

	<div class="row">
		<div class="col-md-1">
			<strong>Fecha:</strong>
		</div>
		<div class="col-md-2">
			<input type="date" class="form-control" id="fecha-rm" name="fecha-rm" value="<?= date('Y-m-d'); ?>" required />
		</div>
		<div class="col-md-1">
			<strong>Hora:</strong>
		</div>
		<div class="col-md-2">
			<input type="time" class="form-control" id="hora-rm" name="hora-rm" value="<?= date('H:i'); ?>" required />
		</div>
		<div class="col-md-2">
			<strong>Responsable:</strong>
		</div>
		<div class="col-md-3">
			<select class="form-control" id="responsable-rm" name="responsable-rm" required>
				<option value="">--Seleccione--</option>
				<?= $opciones_responsables ?>
			</select>
		</div>
	</div>

	<hr>

	<div class="row" style="width: 50%; float: left">
		<div class="col-md-2">
			<strong>Código tubo:</strong>
			<hr>
			<strong>Sobrescribir:</strong>
			<br>
			<input type="checkbox" id="sobrescribir" value="true" />
			<hr>
			<strong>Hora RM auto:</strong>
			<br>
			<input type="checkbox" id="rm-auto" value="true" checked />
		</div>
		<div class="col-md-4">
			<textarea rows="2" class="form-control" id="cod-tubo-grabar" name="cod-tubo" value="" required></textarea>
		</div>
		<div class="col-md-4">
			<button type="submit" class="btn btn-primary" id="grabar">
				<i class="fa fa-save"></i> Grabar
			</button>
			<!-- <a class="btn btn-primary" id="grabar2">
				<i class="fa fa-save"></i> asdasd
      </a> -->
			<br>
		</div>
	</div>
</form>

<form id="formulario-consultar" action="sql_cod_tm_rm_cod_barras.php" method="post">
	<div style="width: 50%; float: right">
		<div class="col-md-4">
			<strong>
				Nº atención /
				<br>
				Código tubo:
			</strong>
		</div>
		<div class="col-md-4">
			<textarea rows="2" class="form-control" id="cod-tubo-consultar" name="cod-tubo" value="" required><?= isset($_GET['id_ate']) ? $_GET['id_ate'] : ''; ?></textarea>
		</div>
		<div class="col-md-4">
			<button type="submit" class="btn btn-success">
				<i class="fa fa-search"></i> Consultar
			</button>
		</div>
	</div>
</form>

<div style="clear: both"></div>

<hr>

<div id="resultados" style="display: none">
</div>

<div id="atención" style="display: none">
	<div class="row">
		<div class="col-md-2">
			<strong>Nº atención:</strong>
			<br>
			<span class="n-atención"></span>
		</div>
		<div class="col-md-2">
			Fecha TM:
			<br>
			<span class="fecha-tm"></span>
		</div>
		<div class="col-md-2">
			Hora TM:
			<br>
			<span class="hora-tm"></span>
		</div>
		<div class="col-md-2">
			Fecha RM:
			<br>
			<span class="fecha-rm"></span>
		</div>
		<div class="col-md-2">
			Hora RM:
			<br>
			<span class="hora-rm"></span>
		</div>
	</div>

	<hr>
</div>

<table id="tabla-tubos" class="table" style="display: none">
	<thead>
		<th>Código tubo</th>
		<th>Descripción</th>
		<th>Toma de muestra</th>
		<th>Recepción de muestra</th>
	</thead>
	<tbody>
	</tbody>
</table>

<br>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = ['editbutton' => false];
$widget = $ui->create_widget($options);

$widget->header = [
	'title' => $datos_pantallas[$pantalla_actual]['body_title'],
	'icon' => 'fa fa-barcode'
];
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	require_once '../inc/ribbon.php';
	?>
	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
require_once '../inc/footer.php';
require_once '../inc/scripts.php';
?>

<script>
	function consultarTubos(codTubo, éxito = false) {
		var jsonSolicitud = {
			consultar: true,
			codTubo: codTubo
		};
		$.ajax({
			type: 'POST',
			url: 'sql_cod_tm_rm_cod_barras.php',
			data: JSON.stringify(jsonSolicitud),
			dataType: 'json',
			contentType: 'application/json; charset=utf-8',
			success: function(jsonRespuesta) {
				if (jsonRespuesta.éxito) {
					if (éxito) exito();
					var atención = jsonRespuesta.atención;
					var nAtención = jsonRespuesta.atención.nAtención;
					var fechaTm = atención.fechaTm == null ? '-' : atención.fechaTm;
					var horaTm = atención.horaTm == null ? '-' : atención.horaTm;
					var fechaRm = atención.fechaRm == null ? '-' : atención.fechaRm;
					var horaRm = atención.horaRm == null ? '-' : atención.horaRm;
					$('#atención .n-atención').html(nAtención);
					$('#atención .fecha-tm').html(fechaTm);
					$('#atención .hora-tm').html(horaTm);
					$('#atención .fecha-rm').html(fechaRm);
					$('#atención .hora-rm').html(horaRm);

					var htmlTubos = '';
					for (var i = 0; i < jsonRespuesta.tubos.length; i++) {
						var tubo = jsonRespuesta.tubos[i];
						htmlTubos += '<tr><td>' + tubo.codTubo + '</td>';
						htmlTubos += '<td>' + (tubo.descTubo == null ? '-' : tubo.descTubo) + '</td>';
						htmlTubos += '<td>' + (tubo.tmTubo == null ? '-' : tubo.tmTubo) + '</td>';
						htmlTubos += '<td>' + (tubo.rmTubo == null ? '-' : tubo.rmTubo) + '</td>';
					}
					$('#tabla-tubos tbody').html(htmlTubos);
					$('#tabla-tubos').fadeIn();
					$('#atención').fadeIn();
				} else {
					error(jsonRespuesta.mensaje);
				}
			}
		});
	}

	function mostrarResultados(mensajes, advertencias, errores, observaciones) {
		var htmlResultados = '';

		if (observaciones && observaciones.trim() != "") htmlResultados += '<p><span class="label label-info">Observaciones:</span> ' + observaciones + '</p>';

		for (var i = 0; i < errores.length; i++) {
			htmlResultados += '<p><span class="label label-danger">Error:</span> ';
			htmlResultados += errores[i];
			htmlResultados += '</p>';
		}

		for (var i = 0; i < advertencias.length; i++) {
			htmlResultados += '<p><span class="label label-warning">Advertencia:</span> ';
			htmlResultados += advertencias[i];
			htmlResultados += '</p>';
		}

		for (var i = 0; i < mensajes.length; i++) {
			htmlResultados += '<p><span class="label label-success">Éxito:</span> ';
			htmlResultados += mensajes[i];
			htmlResultados += '</p>';
		}

		if (htmlResultados != '') {
			htmlResultados += '<hr>';
		}

		$('#resultados').html(htmlResultados);
		$('#resultados').fadeIn();
	}

	$(document).ready(function() {
		$('#tm').on('change', function(e) {
			if ($(this).is(':checked')) {
				$('#fecha-tm').prop('disabled', false);
				$('#hora-tm').prop('disabled', false);
				$('#responsable-tm').prop('disabled', false);

				$('#fecha-tm').prop('required', true);
				$('#hora-tm').prop('required', true);
				$('#responsable-tm').prop('required', true);
			} else {
				$('#fecha-tm').prop('disabled', true);
				$('#hora-tm').prop('disabled', true);
				$('#responsable-tm').prop('disabled', true);

				$('#fecha-tm').prop('required', false);
				$('#hora-tm').prop('required', false);
				$('#responsable-tm').prop('required', false);
			}
		});

		$('#rm').on('change', function(e) {
			if ($(this).is(':checked')) {
				$('#fecha-rm').prop('disabled', false);
				$('#hora-rm').prop('disabled', false);
				$('#responsable-rm').prop('disabled', false);

				$('#fecha-rm').prop('required', true);
				$('#hora-rm').prop('required', true);
				$('#responsable-rm').prop('required', true);
			} else {
				$('#fecha-rm').prop('disabled', true);
				$('#hora-rm').prop('disabled', true);
				$('#responsable-rm').prop('disabled', true);

				$('#fecha-rm').prop('required', false);
				$('#hora-rm').prop('required', false);
				$('#responsable-rm').prop('required', false);
			}
		});

		$('#tm, #rm').on('change', function(e) {
			if (!$('#tm').is(':checked') && !$('#rm').is(':checked')) {
				$('#cod-tubo').prop('disabled', true);
				$('#grabar').prop('disabled', true);
			} else {
				$('#cod-tubo').prop('disabled', false);
				$('#grabar').prop('disabled', false);
			}
		});

		$('#tm').change();

		$('#cod-tubo-grabar').on('input', function(e) {
			var códigoTubo = $(this).val();
			if (códigoTubo.includes('\r') || códigoTubo.includes('\n')) {
				códigoTubo = códigoTubo.replace('\r', '').replace('\n', '').replace("'", '-');
				$(this).val(códigoTubo);

				if ($("#grabar").is(":disabled")) error("Solucione el error y recargue la página continuar.");
				else $('#grabar').click();
			}
		});

		// $('#grabar2').on('click', function (e) {
		//   console.log("asd");
		//   if ($("#grabar").is(":disabled")) error("Solucione el error antes de continuar.");
		//   else                              $('#grabar').click();
		// });

		$('#formulario-grabar').submit(function() {
			$('#tabla-tubos').fadeOut();
			$('#atención').fadeOut();
			$('#resultados').fadeOut();

			var tm = $('#tm').is(':checked');
			var rm = $('#rm').is(':checked');
			var sobrescribir = $('#sobrescribir').is(':checked');
			var rmAuto = $('#rm-auto').is(':checked');

			var jsonSolicitud = {
				grabar: true,
				codTubo: $('#cod-tubo-grabar').val(),
				fechaTm: tm ? $('#fecha-tm').val() : null,
				horaTm: tm ? $('#hora-tm').val() : null,
				responsableTm: tm ? $('#responsable-tm').val() : null,
				fechaRm: rm ? $('#fecha-rm').val() : null,
				horaRm: rm ? $('#hora-rm').val() : null,
				responsableRm: rm ? $('#responsable-rm').val() : null,
				sobrescribir: sobrescribir,
				rmAuto: rmAuto
			};

			$.ajax({
				type: 'POST',
				url: 'sql_cod_tm_rm_cod_barras.php',
				data: JSON.stringify(jsonSolicitud),
				dataType: 'json',
				contentType: 'application/json; charset=utf-8',
				success: function(jsonRespuesta) {
					if (jsonRespuesta.éxito) {
						if (jsonRespuesta.errores.length > 0) $("#grabar").attr("disabled", true);
						mostrarResultados(jsonRespuesta.mensajes, jsonRespuesta.advertencias, jsonRespuesta.errores, jsonRespuesta.observaciones);
						consultarTubos($('#cod-tubo-grabar').val());
						$('#cod-tubo-grabar').val('');
					} else {
						//$("#grabar").attr("disabled", true);
						error(jsonRespuesta.mensaje);
					}
				}
			});

			return false;
		});

		$('#cod-tubo-consultar').on('input', function(e) {
			var códigoTubo = $(this).val();
			if (códigoTubo.includes('\r') || códigoTubo.includes('\n')) {
				códigoTubo = códigoTubo.replace('\r', '').replace('\n', '').replace("'", '-');
				$(this).val(códigoTubo);
				$('#formulario-consultar button').click();
			}
		});

		$('#formulario-consultar').submit(function() {
			$('#tabla-tubos').fadeOut();
			$('#atención').fadeOut();
			$('#resultados').fadeOut();
			consultarTubos($('#cod-tubo-consultar').val(), true);
			$('#cod-tubo-consultar').val('');
			return false;
		});

		<?php
		if (isset($_GET['id_ate'])) {
		?>
			$('#formulario-consultar button').click();
		<?php
		}
		?>
	});
</script>

<?php
include_once '../inc/google-analytics.php';
?>