<?php
$pagina = 0;
define('LOGIN', true);
define('PERMITIDO', true);

require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = "Resultados Online";

$page_css[] = "your_style.css";
$page_body_prop = array('class' => ''); //optional properties for <body>
$no_main_header = true;
$page_html_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");
$style = '
<style>
	#extr-page #header #logo2 img {
		width: 137px;
	}
	#logo2 img {
		height: auto;
		padding-left: 3px;
		width: 110px;
	}
	img {
		vertical-align: middle;
	}
	img {
		border: 0 none;
	}
	.page-footer {;
    	padding: 15px 13px 0 0;
    }
	.portada{
	   background-image: url(../assets/img/background_.jpg) !important;
	   background-image: no-repeat !important;
	   background-image: fixed !important;
	   background-image: center !important;
	   -webkit-background-size: cover !important;
	   -moz-background-size: cover !important;
	   -o-background-size: cover !important;
	   background-size: cover !important;
	}
</style>';

if(isset($_GET) && array_key_exists('error', $_GET)){
	$alertError = '<div class="alert alert-danger fade in">
						<button class="close" data-dismiss="alert"> × </button>
						<i class="fa-fw fa fa-times"></i>
						<strong>Error!</strong>
						Usuario y/o Contraseña erroneas.
				  </div>';
}

include("../inc/header.php");

if (isset($_POST['resultado']) && $_POST['resultado'] == "mostrar") {

  $idAtencion = $_POST['atencion'];
  $rutPaciente = $_POST['rut'];
  $pasaportePaciente = $_POST['pasaporte'];
  $rutArray = explode('-', $rutPaciente);
  $nroRut = str_replace(".", "", $rutArray[0]);
  $dvRut = $rutArray[1];

  if ($rutPaciente != "") $filtro = "WHERE a.ID_ATENCION = ? AND p.NRO_RUT = ? AND p.DV_RUT = ? AND a.FLAG_ELIMINADO = 0";
  else                    $filtro = "WHERE a.ID_ATENCION = ? AND p.PASAPORTE = ? AND a.FLAG_ELIMINADO = 0";

  $qAtencion = $mysqli->prepare("SELECT a.FECHA_INF, a.ID_CONVENIO, a.ID_CENTRO_CONTACTO
  FROM atenciones a
  INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA $filtro");
  if ($rutPaciente != "") $qAtencion->bind_param('sss', $idAtencion, $nroRut, $dvRut);
  else                    $qAtencion->bind_param('ss',  $idAtencion, $pasaportePaciente);
  $qAtencion->execute();
  $qAtencion->bind_result($a_fechaInforme, $a_idConvenio, $a_idCentroContacto);
  $qAtencion->store_result();
  $a_numRows = $qAtencion->num_rows;
  $qAtencion->fetch();
  $qAtencion->close();

  $qInformeAtencion = $mysqli->prepare("SELECT
  CASE
    WHEN FLAG_HISTORICO = 1 THEN CONCAT('https://histarchetcheverry.ripit.cl', URL)
    ELSE 												 CONCAT('https://archetcheverry.ripit.cl', URL)
  END
  FROM archivos_atenciones 
  WHERE ID_ATENCION = ? AND TIPO = 'INFORME' ORDER BY FECHA DESC LIMIT 1");
  $qInformeAtencion->bind_param('s', $idAtencion);
  $qInformeAtencion->execute();
  $qInformeAtencion->bind_result($urlInformeAtencion);
  $qInformeAtencion->fetch();
  $qInformeAtencion->store_result();
  $qInformeAtencion->close();

  # consulta de saldo de la atención
  $qSaldo = $mysqli->prepare("SELECT (MONTO_ATENCION - (MONTO_ATENCION*PCTJE_DESCUENTO / 100)) - MONTO_PAGADO - MONTO_DESCUENTO - MONTO_CONDONADO FROM atenciones WHERE ID_ATENCION = ?");
  $qSaldo->bind_param('s', $idAtencion);
  $qSaldo->execute();
  $qSaldo->bind_result($saldo);
  $qSaldo->store_result();
  $qSaldo->fetch();
  $qSaldo->close();
  if ($a_idCentroContacto==39) $saldo = 0;

  $saldo = 0; #requerimiento andoni 13.12.16 mostrar aunque tenga saldo
}

$qGlosa = $mysqli->prepare("SELECT VALOR FROM parametros_sistema WHERE COD_PARAMETRO = 7");
$qGlosa->execute();
$qGlosa->bind_result($glosaSaldoPendiente);
$qGlosa->fetch();
$qGlosa->store_result();
$qGlosa->close();
?>

<header id="header">
	<!--<span id="logo"></span>-->
	<div class="row" style="width: 100%; height: 100%;">
		<div class="col-md-3" style="height: 100%; text-align: center;">
			<img style="width: 70%; padding-top:15px" src="<?=ASSETS_URL?>/img/logo_empresa.png" alt="Laboratorio Clínico Etcheverry">
		</div>
		<div class="col-md-6" style="height: 100%; text-align: center;">
			<h2><b>PLATAFORMA DE SERVICIOS RIPIT LIMS </b></h2>
		</div>
		<div class="col-md-3" style="height: 100%; text-align: center;">
			<img style="height: 85%; width: auto" src="<?=ASSETS_URL?>/img/logo.png" alt="RIPIT LIMS">
		</div>
	</div>
</header>

<div id="main" role="main" class="portada">
	<div id="content" class="container">
    <div class="row">
      <div class="col-md-offset-3 col-lg-offset-3 col-xs-12 col-sm-12 col-md-6 col-lg-6">
        <p>Seleccione tipo de identificación: </p>
        <label class="radio-inline">
          <input type="radio" name="tipo_identificacion" id="rut" value="rut" checked>RUT
        </label>
        <label class="radio-inline">
          <input type="radio" name="tipo_identificacion" id="pasaporte" value="pasaporte">Pasaporte o DNI
        </label>
      </div>
    </div>
    <br>
    <div class="row">
      <div class="col-md-offset-3 col-lg-offset-3 col-xs-12 col-sm-12 col-md-6 col-lg-6">
        <div class="well no-padding" style="padding-top:20px">
          <form id="login-form" class="smart-form client-form" action="" method="post">
            <header>
              Consulta de Resultados Online
            </header>
            <fieldset>
              <?php echo (isset($alertError))?$alertError: '';?>
              <section class="section-rut">
                <label class="label">Ingrese RUT completo</label>
                <label class="input"> <i class="icon-append fa fa-user"></i>
                  <input type="text" name="rut" value="<?php if(isset($_POST['rut']))echo $_POST['rut']?>">
                  <b class="tooltip tooltip-top-right"> <i class="fa fa-user txt-color-teal"></i>Ingrese RUT.</b>
                </label>
                <div class="note">Ejemplo: 18.731.559-5</div>
              </section>
              <section class="section-pasaporte" hidden>
                <label class="label">Ingrese Pasaporte o DNI:</label>
                <label class="input"> <i class="icon-append fa fa-user"></i>
                  <input type="text" name="pasaporte" value="<?php if(isset($_POST['pasaporte'])) echo $_POST['pasaporte']?>">
                  <b class="tooltip tooltip-top-right"> <i class="fa fa-user txt-color-teal"></i>Ingrese Pasaporte o DNI.</b>
                </label>
                <div class="note">Ejemplo: P43873136</div>
              </section>
              <section>
                <label class="label">Ingrese Número de Atención:</label>
                <label class="input"> <i class="icon-append fa fa-lock"></i>
                  <input type="text" name="atencion" value="<?php if(isset($_POST['atencion'])) echo $_POST['atencion']?>">
                  <b class="tooltip tooltip-top-right"><i class="fa fa-lock txt-color-teal"></i> Ingrese Número de Atención.</b> 
                </label>
                <div class="note">Ejemplo: 100125</div>
              </section>
              <section>
                <label class="label">En caso de consultas, escríbanos <a href="http://www.laboratorioetcheverry.cl/contacto/" target="_blank" title="Formulario de Contacto">aquí.</a></label>
              </section>
            </fieldset>
            <footer>
              <input name="resultado" type="hidden" value="mostrar" />
              <button type="submit" class="btn btn-danger">	Buscar <i class="fa fa-search"></i>	</button>
            </footer>
          </form>
        </div>
      </div>
    </div>
		
		<?php
		if ((isset($_POST['resultado'])) && ($_POST['resultado'] == "mostrar")) {
			if ($a_numRows > 0) {
				if ($a_fechaInforme != null) {
					if ($saldo <= 0 || $a_idConvenio != 0) {
						if ($urlInformeAtencion != null) $url = $urlInformeAtencion;
						else    							           $url = "pdf_p_cm.php?r={$_POST['pasaporte']}&i={$idAtencion}";
					?>
						<div class="row">
              <h3 class="text-center" style="margin:10px"><b>Descargue su informe de resultados aquí</b> <i class="fa fa-arrow-down"></i> </h3>
							<div class="col-md-offset-3 col-lg-offset-3 col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center">
								<a class="btn btn-primary" href="<?=$url?>" target="_blank">
									Descargar PDF <i class="fa fa-file-pdf-o"></i>
								</a>
							</div>
						</div>
					<?php	} else { ?>
						<div class="row">
							<div class="col-md-offset-4 col-lg-offset-4 col-xs-12 col-sm-12 col-md-5 col-lg-4"><?=$glosaSaldoPendiente?></div>
						</div>
					<?php	} 
        } else { ?>
          <div class="row">
            <div class="col-md-offset-4 col-lg-offset-4 col-xs-12 col-sm-12 col-md-5 col-lg-4">
              Los resultados para la atención <?=$idAtencion?> aún no se encuentran disponibles.
            </div>
          </div>
				<?php	} ?>
				<hr>
        <div class="row">
          <div class="col-md-offset-3 col-lg-offset-3 col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <b>Estado de exámenes</b>
          </div>
        </div>
				<br>
        <div class="row">
          <div class="col-md-offset-3 col-lg-offset-3 col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <?= obtenerDetalleAtencion($idAtencion) ?>
          </div>
        </div>
			<?php	} else { ?>
			  <div class="row">
					<div class="col-md-offset-3 col-lg-offset-3 col-xs-12 col-sm-12 col-md-6 col-lg-6">
            No existen resultados asociados al Nro. de Atención y Pasaporte ingresados.
          </div>
				</div>
			<?php	}
		}
    ?>
	</div>
</div>

<?php
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) -->
<script src="<?=ASSETS_URL?>/js/plugin/rut/jquery.Rut.min.js"></script>
<script src="https://www.google.com/recaptcha/api.js?render=6LfQESwhAAAAAJqb3-3DY-4gGJI9n-qleubDR7c5"></script>

<script type="text/javascript">
$(document).ready(function() {

  // cuando el post se haga con pasaporte, se chekea el radio-button de pasaporte y se muestra el section del pasaporte (se esconde el section del rut)
  var pasaportePaciente = "<?=$pasaportePaciente?>";
  if (pasaportePaciente != "") {
    $('#pasaporte').prop('checked', true);
    // $('input[name=tipo_identificacion]').val("pasaporte");
    $(".section-rut").hide();
    $(".section-pasaporte").show();
  }

	// Valida el Form. cuando un elemento esta hidden, no se considera el required:true.
  // Es decir, mientras esten escondidos, no importa que los input rut o pasaporte esten vacios, 
  $("#login-form").validate({
    rules: {
      rut:       {required: true, maxlength : 15, text: true},
      pasaporte: {required: true, maxlength : 15, text: true},
      atencion:  {required: true, maxlength : 10, number: true}
    },
    messages: {
      rut: {
        required: 'Ingrese Rut',
        maxlength: 'Ingrese no más de 15 caracteres'
      },
      pasaporte: {
        required: 'Ingrese Pasaporte',
        maxlength: 'Ingrese no más de 15 caracteres'
      },
      atencion: {
        required: 'Ingrese número de atención',
        maxlength: 'Ingrese no más de 10 caracteres',
        number: 'Ingrese solo números'
      }
    },
    errorPlacement : function(error, element) { // Do not change code below
      error.insertAfter(element.parent());
    }
  });

  $('input[name=rut]').Rut({
		on_error: function(){   
      error('Rut incorrecto');
      }
	});

  $('input[name=tipo_identificacion]').change(function() {
    if (this.value == 'rut') {
      $(".section-pasaporte").hide();
      $(".section-rut").show();
    }
    else if (this.value == 'pasaporte') {
      $(".section-rut").hide();
      $(".section-pasaporte").show();
    }
  });

  $('input[name=rut]').change(function() {
    $("input[name=pasaporte]").val("");
  });

  $('input[name=pasaporte]').change(function() {
    $("input[name=rut]").val("");
  });

  $('#login-form').submit(function(event) {
		event.preventDefault();
		grecaptcha.ready(function() {
			grecaptcha.execute('6LfQESwhAAAAAJqb3-3DY-4gGJI9n-qleubDR7c5', {
				action: 'login'
			}).then(function(token) {
				$('#login-form').prepend('<input type="hidden" name="token" value="' + token + '">');
				$('#login-form').prepend('<input type="hidden" name="action" value="login">');
				$('#login-form').unbind('submit').submit();
			});;
		});
	});

});
</script>

<?php
	include("../inc/footer_login.php");
	include("../inc/google-analytics.php");
?>
