<?php
header('Content-type: application/pdf');

require_once '../Connections/conexionlab.php';
require_once '../pdfClasses/class.ezpdf.php';
require_once '../assets/php/noCache.php';

noCache();

$pdf =& new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(2, 1, 1, 1);
$pdf->ezStartPageNumbers(330, 5, 9, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);

date_default_timezone_set('America/Santiago');
$hora = time();

// Se actualiza flag visto
if (isset($_GET['i'])) {
	$ida = $_GET['i'];
	mysql_select_db($database_conexionlab, $conexionlab);
	$q_update = "UPDATE atenciones SET FLAG_VISTO = 1 WHERE ID_ATENCION = '$ida'";
	$result = mysql_query($q_update, $conexionlab);
}

// Se obtiene id de la atención.
$idate = '-1';
if (isset($_GET['i'])) {
	$idate = $_GET['i'];
	$rut = $_GET['r'];
}

// Agrupación por área de los exámenes de la atención
mysql_select_db($database_conexionlab, $conexionlab);

$query_areas = "SELECT ea.ID_EXATE, ea.ID_ATENCION, ea.COD_EXAMEN, ex.AREA_LAB, cg.DESCRIPCION_CG AS NOMBRE
	FROM examenes_atenciones ea INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
	LEFT JOIN codigos_generales cg ON ex.AREA_LAB = cg.CODIGO 
	WHERE ID_ATENCION = '$idate' AND ea.FECHA_VAL IS NOT NULL AND cg.COD_TABLA = 'SIS_AREAS' 
	GROUP BY ex.AREA_LAB 
	ORDER BY ea.ID_EXATE ASC";

$areas = mysql_query($query_areas, $conexionlab) or die(mysql_error());
$totalRows_areas = mysql_num_rows($areas);

// Datos de la atención
mysql_select_db($database_conexionlab, $conexionlab);

$query_atencion = "SELECT a.ID_ATENCION, a.FECHA AS FECHA2, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA,
	DATE_FORMAT(p1.FECHA_NACIMIENTO,'%d/%m/%Y') AS FECHA_NACIMIENTO,
	DATE_FORMAT(a.FECHA_INF,'%d/%m/%Y') AS FECHA_INF, DATE_FORMAT(p1.FECHA_NACIMIENTO,'%d%m%y') AS F_NAC, p1.NOMBRES, p1.APELLIDO_PATERNO,
	p1.APELLIDO_MATERNO, p1.GENERO, TIMESTAMPDIFF(MONTH, p1.FECHA_NACIMIENTO, a.FECHA) AS EDAD_MES,
	p2.APELLIDO_PATERNO AS DR, cc.NOMBRE, p1.NRO_RUT, p1.DV_RUT, CONCAT_WS(' ', DATE_FORMAT(a.FECHA_TM, '%d/%m/%Y'), DATE_FORMAT(a.HORA_TM,'%H:%i')) AS HORA_TM, 
	CONCAT_WS(' ', DATE_FORMAT(a.FECHA_R, '%d/%m/%Y'), DATE_FORMAT(a.HORA_R, '%H:%i')) AS HORA_R
	FROM atenciones a
	LEFT JOIN personas p1 ON a.ID_CLIENTE = p1.ID_PERSONA
	LEFT JOIN personas p2 ON a.ID_MEDICO = p2.ID_PERSONA
	LEFT JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
	WHERE a.ID_ATENCION = '$idate' AND p1.NRO_RUT = '$rut'";

$atencion = mysql_query($query_atencion, $conexionlab) or die(mysql_error());
$row_atencion = mysql_fetch_assoc($atencion);
$totalRows_atencion = mysql_num_rows($atencion);

if ($totalRows_atencion == 0) {
	die();
}

// Observaciones de los resultados
mysql_select_db($database_conexionlab, $conexionlab);
$query_obs = "SELECT obs_resultados.OBS FROM obs_resultados WHERE obs_resultados.ID_ATENCION = '$idate' AND obs_resultados.F_INF = '1'";
$obs = mysql_query($query_obs, $conexionlab) or die(mysql_error());
$row_obs = mysql_fetch_assoc($obs);
$totalRows_obs = mysql_num_rows($obs);

// Pie de informe

mysql_select_db($database_conexionlab, $conexionlab);
$query_pie = "SELECT VALOR FROM parametros_sistema WHERE DESCRIPCION_PS = 'PIE INFORME'";
$pie = mysql_query($query_pie, $conexionlab) or die(mysql_error());
$row_pie = mysql_fetch_assoc($pie);
$totalRows_pie = mysql_num_rows($pie);

$sep = " ";

// Informacion del archivo pdf
$nombre_archivo = "Atencion_" . $idate . '.pdf'; // Nombre del archivo para la descarga
$datacreator = [
	'Title' => 'Informe de Resultados al Paciente',
	'Author' => 'SILCL RIPIT',
	'Subject' => 'Resultados de la atención '. $idate,
	'Creator' => '',
	'Producer' => 'www.ripit.cl'
];

$informe = ['Content-Disposition' => $nombre_archivo]; // Array para ezStream con el nombre del archivo
$pdf->addInfo($datacreator); // Información del archivo

// Arreglo con los exámenes, se muestran por área en hojas distintas segun parámetro de tabla EXAMENES -> AREA_LAB

$cont = 0;

while ($row_areas = mysql_fetch_assoc($areas)) {
	unset($hemograma); // Se inicia el área de-seteando la variable para hemograma: 01.01.045
	unset($orinacompleta); // Lo mismo para orina completa: 09.09.022

	$cont = $cont + 1;
	$ar = $row_areas['AREA_LAB'];

	mysql_select_db($database_conexionlab, $conexionlab);

	$query_exate = "SELECT ea.ID_EXATE, ea.ID_ATENCION, ea.COD_EXAMEN, ea.F_HIJO,  ea.PADRE,  ea.RESULTADO, ex.NOMBRE, ex.NOMBRE_INF, ex.METODO, ex.AREA_LAB, ex.TIPO_VARIABLE,
	ex.N_DECIMALES, ex.REFERENCIA, ex.FLAG_AGRUPACION, ex.F_INF, cg.DESCRIPCION_CG AS UNI, ea.FECHA_VAL, cg2.DESCRIPCION_CG TIPOMUESTRA
	FROM examenes_atenciones ea
	INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
	LEFT JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA = cg.CODIGO AND cg.COD_TABLA = 'SIS_UNIMED'
	LEFT JOIN codigos_generales cg2 ON ex.TIPO_MUESTRA = cg2.CODIGO  AND cg2.COD_TABLA = 'SIS_TIPMUE'
	WHERE ID_ATENCION = '$idate' AND ea.FECHA_VAL IS NOT NULL AND ex.AREA_LAB = '$ar' AND ex.F_INF = 'S'
	ORDER BY cg2.DESCRIPCION_CG, ea.ID_EXATE ASC";

	$exate = mysql_query($query_exate, $conexionlab) or die(mysql_error());
	$totalRows_exate = mysql_num_rows($exate);

	// Validador del área:
	$q_validador = "SELECT exat.USUARIO_VAL, FIRMA FROM examenes_atenciones exat 
	INNER JOIN usuarios ON exat.USUARIO_VAL = usuarios.ID_USUARIO 
	INNER JOIN examenes ON exat.COD_EXAMEN = examenes.COD_INTERNO
	WHERE ID_ATENCION = '$idate' AND AREA_LAB = '$ar' AND USUARIO_VAL != 12 AND FIRMA IS NOT NULL
	GROUP BY USUARIO_VAL";

	$validador = mysql_query($q_validador, $conexionlab) or die(mysql_error());
	$row_validador = mysql_fetch_assoc($validador);
	$totalRows_validador = mysql_num_rows($validador);

	if ($totalRows_validador > 0) {
		$firma = "../firmas/" . $row_validador['FIRMA'];
	} else { 
		$firma = "../firmas/andoni_e.jpg";
	}

	$data = [];
	$data2 = [];

	$tipoMuestra = '';
	$tipoMuestraText = '';
	
	while ($row_exate = mysql_fetch_assoc($exate)) {
		$codex = $row_exate['COD_EXAMEN'];
		$edad = $row_atencion['EDAD_MES'];
		$genero = $row_atencion['GENERO'];
		$f_atencion = $row_atencion['FECHA2'];

		if ($codex == '01.01.045') {
			$hemograma = 1;
		}
		if ($codex == '09.09.022') { 
			$orinacompleta = 1;
		}

		mysql_select_db($database_conexionlab, $conexionlab);

		// Para cada examen busco sus rangos de validación
		$query_rangos = "SELECT rangos_variables.RC_MIN, rangos_variables.RC_MAX, rangos_variables.RR_MIN, rangos_variables.RR_MAX, rangos_variables.RV_MIN, rangos_variables.RV_MAX
		FROM rangos_variables WHERE ('$edad' BETWEEN rangos_variables.EDAD_MIN AND rangos_variables.EDAD_MAX) AND (rangos_variables.GENERO = '$genero') AND (rangos_variables.COD_INTERNO = '$codex') AND F_REGISTRO < '$f_atencion'
		ORDER BY F_REGISTRO DESC LIMIT 1";

		$rangos = mysql_query($query_rangos, $conexionlab) or die(mysql_error());
		$row_rangos = mysql_fetch_assoc($rangos);
		$totalRows_rangos = mysql_num_rows($rangos);

		$decimales = 2;

		if($row_exate['N_DECIMALES'] != '') {
			$decimales = $row_exate['N_DECIMALES'];
		}

		// Si no tiene nombre de informe se muestra el nombre de sistema.
		if($row_exate['NOMBRE_INF'] == NULL) {
			$nombre = $row_exate['NOMBRE'];
		} else {
			$nombre = $row_exate['NOMBRE_INF'];
		}

		// Si es hijo se muestra con sangría.
		if($row_exate['F_HIJO'] == "S") {
			$nombre = "      " . $nombre;
		}
		
		// Si no es agrupación, se añade al nombre del examen el método.
		if($row_exate['FLAG_AGRUPACION'] != 'S' && $row_exate['METODO'] != null && $row_exate['METODO'] != '') {
			$nombre = $nombre . ' - ' . $row_exate['METODO'];
		}

		// Si es numérico (TIPO_VARIABLE: 1) y no tiene referencia ni es agrupación, muestra rangos.
		if(($row_exate['TIPO_VARIABLE'] == "1") && ($row_exate['REFERENCIA'] == NULL) && ($row_exate['FLAG_AGRUPACION'] != "S") && ($totalRows_rangos > 0)) {
			$rango_val = number_format($row_rangos['RV_MIN'], $decimales, ',', '.') . " - " . number_format($row_rangos['RV_MAX'], $decimales, ',', '.'); // Referencia
		// Si es agrupación no se muestra.
		} else if($row_exate['FLAG_AGRUPACION'] == "S") {
			$rango_val = '';
		// Si no, muestra la referencia.
		} else {
			$rango_val = $row_exate['REFERENCIA']; 
		}

		// Si es agrupación, no tiene resultado. Si no, lo muestra.
		if(($row_exate['FLAG_AGRUPACION'] != "S") && ($row_exate['TIPO_VARIABLE'] == "1")) {
			// Cambio nombre a unidad.
			$unidad = $row_exate['UNI'];

			if(!is_numeric($row_exate['RESULTADO'])) {
				$resu = $row_exate['RESULTADO'] . " " . $unidad;
			} else {
				if ($row_exate['UNI'] == "S/U.M.") {
					$unidad = "";
				}
				
				if((($row_exate['RESULTADO'] < $row_rangos['RV_MIN']) || ($row_exate['RESULTADO'] > $row_rangos['RV_MAX'])) && (isset($row_rangos['RV_MAX']))) {
					$resu = number_format($row_exate['RESULTADO'], $decimales, ',', '.') . " " . $unidad . "*"; // Cualquier numérico alterado.
				} else {
					$resu = number_format($row_exate['RESULTADO'], $decimales, ',', '.') . " " . $unidad;
				}
			} // If resultado supone númerico no lo es
			
		// Alfanumérico
		} elseif ($row_exate['TIPO_VARIABLE'] == "2") {
			if (($row_exate['RESULTADO'] == $row_exate['REFERENCIA']) || ($row_exate['REFERENCIA'] == NULL)) {
				$resu = $row_exate['RESULTADO'];
			} else {
				$resu = $row_exate['RESULTADO']."*";
			}

		// Texto
		} elseif ($row_exate['TIPO_VARIABLE'] == "3"){ 
			$resu = $row_exate['RESULTADO'];
		} else {
			$resu = '';
		}

		// Si es tipo texto y no es hijo (PADRE: null).
		if(($row_exate['TIPO_VARIABLE'] == 3) && ($row_exate['PADRE'] == NULL)) {
			if($tipoMuestraText != $row_exate['TIPOMUESTRA']) {
				$tipoMuestraText = $row_exate['TIPOMUESTRA'];
				$data2[] = array('NOM' => '<b>Tipo de Muestra: ' . $tipoMuestraText . '</b>');
			}
			
			$data2[] = array('NOM' => $nombre, 'RES' => $resu);
			$mark = 1;
			
		// Todo lo demás.
		} else {
			if($tipoMuestra != $row_exate['TIPOMUESTRA']){
				$tipoMuestra = $row_exate['TIPOMUESTRA'];
				$data[] = array('NOM' => '<b>Tipo de Muestra: ' . $tipoMuestra . '</b>');
			}
			
			$data[] = array('NOM' => $nombre, 'RES' => $resu, 'RANGO' => $rango_val);
			$mark2 = 1;
		}
	} // Fin de while que recorre los exámenes del área



	// Títulos de la tabla si no es texto
	$titles = [
		'NOM' => '<b>Examen</b>',
		'RES' => '<b>Resultado</b>',
		'RANGO' => '<b>Referencia</b>'
	];

	// Títulos de la tabla si es texto
	$titles2 = [
		'NOM' => '<b>Nombre</b>',
		'RES' => '<b>Resultado</b>'
	];

	$options = [
		'shadeCol' => [0.9, 0.9, 0.9],
		'showLines' => 0, // Bordes
		'shaded' => 0, // Color de fila una por medio
		'xOrientation' => 'center',
		'width' => 560,
		'fontSize' => 8,
		'cols' => array('NOM' => array('justification' => 'left'), 'RES' => array('justification' => 'left'), 'RANGO' => array('justification' => 'left', 'width' => 120))
	];

	$options2 = [
		'shadeCol' => [0.9, 0.9, 0.9],
		'showLines' => 0, // Bordes
		'shaded'=> 0, // Volor de fila una por medio
		'xOrientation' => 'center',
		'width' => 560,
		'fontSize' => 8,
		'cols' => array('NOM' => array('justification' => 'left', 'width' => 220), 'RES' => array('justification' => 'left'))
	];

	// Informe
	if (isset($_REQUEST['old'])) {
		$header = imagecreatefrompng('../imagenes/header.png');
		$pdf->addImage($header, 0, 739, 612);
	} else {
		$logo = imagecreatefromjpeg('../imagenes/new_logo.jpg');
		$pdf->addImage($logo, 28, 745, 150);
		
		$pdf->addText(430, 755, 9, 'www.laboratorioetcheverry.cl');

		$pdf->addTextWrap(540, 65, 100, 9, 'Arlegui   440', 'justification');
		$pdf->addTextWrap(540, 55, 100, 9, 'Oficina   218', 'justification');
		$pdf->addTextWrap(540, 45, 100, 9, '(32) 2714189', 'justification');
		$pdf->addTextWrap(540, 35, 100, 9, 'Viña del Mar', 'justification');

		$pdf->setStrokeColor(1, 0, 0);
		$pdf->line(535, 75, 535, 30);
	}

	$area_lab = $row_areas['NOMBRE'];



	if ($row_areas['AREA_LAB'] == 11) { // Si área es VIH, el nombre del paciente está compuesto por 3 iniciales, fecha de nacimiento y últimos 3 dígitos del RUT más dígito verificador... ej  yo: AEL 230470 679-2
		$inici = substr($row_atencion['NOMBRES'], 0, 1) . substr($row_atencion['APELLIDO_PATERNO'], 0, 1) . substr($row_atencion['APELLIDO_MATERNO'], 0, 1);
		$fnac = $row_atencion['F_NAC'];
		$xrut = substr($row_atencion['NRO_RUT'], -3, 3) . "-" . $row_atencion['DV_RUT'];
		$paci = $inici . " " . $fnac . " " . $xrut;
	} else {
		$paci = $row_atencion['NOMBRES'] . " " . $row_atencion['APELLIDO_PATERNO'] . " " . $row_atencion['APELLIDO_MATERNO'];
	}

	$rut = number_format($row_atencion['NRO_RUT'], '0', ',', '.') . "-" . $row_atencion['DV_RUT'];
	$htm = $row_atencion['HORA_TM'] . ' h';
	$hr = $row_atencion['HORA_R'] . ' h';

	if ($row_atencion['GENERO'] == 'F') {
		$d = "SRA(ITA): ";
		$genero1 = "Femenino";
	} else {
		$d  ="SR: ";
		$genero1 = "Masculino";
	}

	$ate = $row_atencion['ID_ATENCION']; // Id de atención
	$cc = $row_atencion['NOMBRE']; // Local
	$dr = $row_atencion['DR']; // Doctor
	$fech = $row_atencion['FECHA']; // Fecha de atención
	$fechNac = $row_atencion['FECHA_NACIMIENTO']; // Fecha de nacimiento
	$fech_inf = $row_atencion['FECHA_INF']; // Fecha de informe
	$texto_pie = $row_pie['VALOR']; // Texto pie de página
	
	// Generación de edad en texto
	$date_time_hoy = new DateTime();
	$date_time_fecha_nacimiento = DateTime::createFromFormat('d/m/Y', $fechNac);
	$date_interval_diferencia = $date_time_fecha_nacimiento->diff($date_time_hoy);
	
	$edad = "{$date_interval_diferencia->y} a, {$date_interval_diferencia->m} m";

	// Tabla con datos de la atención
	$data_at = [	
		array('1' => $d, '2' => $paci, '3' => "Fecha atención :", '4' => $fech),
 		array('1' => "Rut :", '2' => $rut, '3' => "Toma de muestra :", '4' => $htm),
        array('1' => "Fecha de Nac. :", '2' => "$fechNac - $edad - $genero1", '3' => "Recepción de muestra :", '4' => $hr),
		array('1' => "Nro. Atención :",	'2' => $ate. " / " . $cc, '3' => "Fecha informe :", '4' => $fech_inf),
		array('1' => "Solicitante :", '2' => $dr, '3' => "", '4' => "")
	];

	$titles_at = [
		'1' => '',
		'2' => '',
		'3' => '',
		'4' => ''
    ];

	$options_at = [
		'shadeCol' => array(0.9, 0.9, 0.9),
		'showLines' => 0, // Bordes
		'shaded' => 0, // Color de fila una por medio
		'showHeadings' => 0,
		'xOrientation' => 'center',
		'width' => 550,
		'rowGap' => 1,
		'fontSize' => 8,
		'cols' => array('1' => array('justification' => 'left', 'width' => 75), '2' => array('justification' => 'left', 'width' => 245), '3' => array('justification' => 'left', 'width' => 130), '4' => array('justification' => 'left', 'width' => 100))
	];

	$pdf->ezTable($data_at, $titles_at, '', $options_at);
	$pdf->ezText("_____________________________________________________________________________________________________________________________________________________________________", 6,array('justification'=>'center'));

	$pdf->ezText($area_lab . "\n", 9, array('justification' => 'center'));

	if (isset($mark2)) {
		$pdf->ezTable($data, $titles, '', $options);
	}

	if (isset($mark)) {
		$pdf->ezTable($data2, $titles2, '', $options2);
	}

	$pdf->ezText("_____________________________________________________________________________________________________________________________________________________________________", 6,array('justification'=>'center'));

	$pdf->ezSetCmMargins(2, 1, 0, 0);
	$pdf->ezImage($firma, 30, 300, 'none', 'center');
	$pdf->ezSetCmMargins(2, 1, 1, 1);
	
	$pdf->addText(18, 25, 8, $texto_pie, 0, 0);

	if (isset($hemograma)) {
		$nota = "Nota: +     : Leve/Escaso
			++   : Moderado/Regular cantidad
			+++ : Marcado/Abundante";
		$pdf->addText(18, 45, 7, $nota, 0, 0);
		$pdf->addText(18, 35, 7, "Método: Analizador automatizado Mindray M-5380/Microscopía", 0, 0);
	}
	
	if (isset($orinacompleta)) {
		$nota = "Nota: +        : Escaso
			++     : Regular cantidad
			+++   : Abundante";
		$pdf->addText(18, 45, 7, $nota, 0, 0);
	}

	/* if ($row_areas['AREA_LAB'] == 16) {
		$nota = "<b>Información importante:</b> Independiente del resultado, usted debe hacer cuarentena obligatoria por 14 días después de tomado el examen.";
		$pdf->addText(18, 45, 8, $nota, 0, 0);
	} */

	if ($cont<$totalRows_areas) {
		$pdf->ezNewPage();
	}
	unset($mark);
	unset($mark2);
} // Fin de while áreas

// Mostrar observaciones al final de la hoja
if (($totalRows_obs > 0) && ($row_obs['OBS'] != NULL)) {
	$pdf->ezText("\n\nObservaciones:\n", 9);
	do {
		$pdf->ezText("- " . $row_obs['OBS'], 9);
	} while ($row_obs = mysql_fetch_assoc($obs));
}

ob_end_clean();
$pdf->ezStream($informe);
?>