<?php
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ServerException;

define('PERMITIDO', true);
require_once("../inc/init.php");

function generarInforme($id_usuario, $id_atencion) {
	global $mysqli;
	
	include __DIR__ . '/../inc/vendor/autoload.php';
	
	// $cambiarFechaInforme = $mysqli->prepare('UPDATE atenciones SET FECHA_INF = CURDATE() WHERE ID_ATENCION = ? LIMIT 1');
	// $cambiarFechaInforme->bind_param('i', $id_atencion);
	// $cambiarFechaInforme->execute();
	// $cambiarFechaInforme->close();
	
	$cliente = new Client(
		[
			'headers' => [
				'Content-Type' => 'application/json'
			]
		]
	);
	
	$jsonSolicitud = [
		'urlBajada' => 'http://localhost/~ripitcl/SILCLCE/i_resultados/pdf_p_cm.php?idate=' . $id_atencion,
		'urlSubida' => 'http://localhost/~ripitcl/SILCLCE/st_resultados/subir_informe_firmado.php?idate=' . $id_atencion . '&idusu=' . $id_usuario,
		'razon' => 'Laboratorio Etcheverry Ltda.',
		'locacion' => 'Viña del Mar',
		'rut' => '10390679-2',
		'posicion' => 'custom',
		'numPagina' => 'last',
		'ulx' => 20,
		'uly' => 72
	];
	
	try {	
		$respuesta = $cliente->post(
			'http://localhost:8080/firma_elect',
			[
				'body' => json_encode($jsonSolicitud)
			]
		);
	} catch (ServerException $e) {
		return false;
	}
	
	return true;
}

// Se utiliza el ID de usuario de admin_ripit (1) como parámetro de la funcion generarInforme()
$id_usuario = 1;

// Aquí se ingresa la consulta para buscar las ids de las atenciones a las cuales se le generaran los informes 
// Ej: SELECT ID_ATENCION FROM atenciones WHERE ID_ATENCION = 278040
$consultaAtenciones = "SELECT a.ID_ATENCION, a.FECHA_INF, URL from atenciones a
left join archivos_atenciones aa on aa.ID_ATENCION = a.ID_ATENCION
where FECHA_INF is not null 
and url is null
and a.FECHA_INF = '2021-10-29'";
$qAtenciones = $mysqli->prepare($consultaAtenciones);
//$qAtenciones->execute();
$qAtenciones->bind_result($idate, $fechaInf, $url);
$qAtenciones->store_result();
$num_atenciones = $qAtenciones->num_rows();

echo "num_rows: ".$num_atenciones."<br>";

while($qAtenciones->fetch()) {
  echo $idate." ".$fechaInf." ".$url."<br>";
  //if(generarInforme($id_usuario, $idate)) echo "ARCHIVOS GENERADOS EXITOSAMENTE";
}

?>