<?php
define('PERMITIDO', true);
require_once("../inc/init.php");

$query = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, '%d/%m/%Y'),
a.ID_CONVENIO, convenioAtencion.NBR,
a.ID_PREVISION, previsionAtencion.NBR, 
p.ID_PREVISION, previsionPaciente.NBR
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas convenioAtencion ON convenioAtencion.ID_EMPRESA = a.ID_PREVISION
LEFT JOIN empresas previsionAtencion ON previsionAtencion.ID_EMPRESA = a.ID_PREVISION
LEFT JOIN empresas previsionPaciente ON previsionPaciente.ID_EMPRESA = p.ID_PREVISION
WHERE a.ID_CONVENIO = 40
AND a.FECHA >= '2024-01-09' 
AND a.FECHA <= '2024-01-10'
AND a.FLAG_ELIMINADO = 0
# LIMIT 4");
$query->execute();
$query->bind_result($idAtencion, $fechaAtencion, $idConvenioAtencion, $nombreConvenioAtencion, $idPrevisionAtencion, $nombrePrevisionAtencion, $idPrevisionPaciente, $nombrePrevisionPaciente);
$query->store_result();
$num_atenciones = $query->num_rows();

echo "Número de atenciones: $num_atenciones <br><br>";
while ($query->fetch()) {

  $idEmpresaObjetivo = $idConvenioAtencion;
  echo "Atencion: $idAtencion - Fecha: $fechaAtencion - Convenio Atención: $nombreConvenioAtencion - Prevision Atención: $nombrePrevisionAtencion - Prevision Paciente: $nombrePrevisionPaciente<br>";

  $qExamenes = $mysqli->prepare("SELECT ea.ID_EXATE, ea.PREV, ex.COD_INTERNO, ex.NOMBRE, e.NBR, e2.NBR, ea.PRECIO_EXAMEN, pex.PRECIO
  FROM examenes_atenciones ea
  LEFT JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
  LEFT JOIN empresas e ON e.ID_EMPRESA = ea.PREV
  LEFT JOIN precios_examenes pex ON pex.COD_EXAMEN = ea.COD_EXAMEN AND pex.ID_EMPRESA = ?
  LEFT JOIN empresas e2 ON e2.ID_EMPRESA = pex.ID_EMPRESA
  WHERE ea.ID_ATENCION = ?
  AND ea.PADRE IS NULL"); # AND ea.COD_EXAMEN NOT IN ('00.00.042')
  $qExamenes->bind_param('ii', $idEmpresaObjetivo, $idAtencion);
  $qExamenes->execute();
  $qExamenes->bind_result($idExamenAtencion, $empresaExamen, $codigoExamen, $nombreExamen, $nbrEmpresaPrecio, $nbrEmpresaObjetivo, $precioExamen, $precioExamenObjetivo);
  $qExamenes->store_result();
  while ($qExamenes->fetch()) {
    # if ($empresaExamen == 37) {
    if ($precioExamenObjetivo === null) { 
      echo "#### $idExamenAtencion # $codigoExamen # ACTUAL: $nbrEmpresaPrecio:" . number_format($precioExamen, 0, ",", ".") . " # NO SE MODIFICA # $nombreExamen </br>";
    } else {
      echo "#### $idExamenAtencion # $codigoExamen # ACTUAL: $nbrEmpresaPrecio: " . number_format($precioExamen, 0, ",", ".") . " # OBJETIVO: $nbrEmpresaObjetivo: " . number_format($precioExamenObjetivo, 0, ",", ".") . " # $nombreExamen </br>";
      // $stmt = $mysqli->prepare("UPDATE examenes_atenciones SET PRECIO_EXAMEN = ?, PREV = ? WHERE ID_EXATE = ? LIMIT 1");
      // $stmt->bind_param('iii', $precioExamenObjetivo, $idEmpresaObjetivo, $idExamenAtencion);
      // $stmt->execute();
      // $stmt->close();
    }
  }
  $qExamenes->close();
  echo "<br>";

  // ACTUALIZA EL MONTO TOTAL DE LA ATENCIÓN
  // $stmt = $mysqli->prepare("UPDATE atenciones
  // SET MONTO_ATENCION = (SELECT SUM(PRECIO_EXAMEN) FROM examenes_atenciones WHERE ID_ATENCION = ?)
  // WHERE ID_ATENCION = ?");
  // $stmt->bind_param("ii", $idAtencion, $idAtencion);
  // $stmt->execute();
  // $stmt->close();

  // SOLO SI SE QUIERE CAMBIAR LA PREVISIÓN DE LA ATENCIÓN (CASI NUNCA)

  // $stmt = $mysqli->prepare("UPDATE atenciones SET ID_PREVISION = ? WHERE ID_ATENCION = ?");
  // $stmt->bind_param("ii", $idEmpresaObjetivo, $idAtencion);
  // $stmt->execute();
  // $stmt->close();

}
$query->close();
