<?php
$pagina = 7;
define('PERMITIDO', true);
require_once('../inc/init.php');

$idRegistroRangos = isset($_GET['idrr']) ? $_GET['idrr'] : -1;

$qRegistrosRango = $mysqli->prepare("SELECT ID_RANGOS, GENERO, EDAD_MIN, EDAD_MAX, RC_MIN, RC_MAX, RR_MIN, RR_MAX, RV_MIN, RV_MAX, DATE_FORMAT(F_REGISTRO, '%d/%m/%Y')
FROM rangos_variables WHERE ID_RANGOS = ?");
$qRegistrosRango->bind_param("i", $idRegistroRangos);
$qRegistrosRango->execute();
$qRegistrosRango->bind_result($rv_idRegistroRangos, $rv_genero, $rv_edadMin, $rv_edadMax, $rv_rangoCriticoMin, $rv_rangoCriticoMax, $ward1, $ward2, $rv_rangoValidoMin, $rv_rangoValidoMax, $rv_fechaRegistro);
$qRegistrosRango->store_result();
$qRegistrosRango->fetch();
$qRegistrosRango->close();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel">Modificación de Rangos</h4>
</div>
<div class="modal-body">
  <form action="sql_cod.php" method="post" name="form1" id="formEditRango">
    <table class="table table-responsive table-hover table-bordered">
      <thead>
        <tr>
          <th>Género</th>
          <th colspan="2">Edad en Meses</th>
          <th>Crítico Inferior</th>
          <th>Válido Inferior</th>
          <th>Válido Superior</th>
          <th>Crítico Superior</th>
          <th>Fecha Creación</td>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>
            <select class="form-control" name="GENERO">
              <option value="M" <?php if ($rv_genero == "M") echo "selected" ?>>Masculino</option>
              <option value="F" <?php if ($rv_genero == "F") echo "selected" ?>>Femenino</option>
            </select>
          </td>
          <td><input type="text" class="form-control" name="EDAD_MIN" value="<?= $rv_edadMin ?>" /></td>
          <td><input type="text" class="form-control" name="EDAD_MAX" value="<?= $rv_edadMax ?>" /></td>
          <td><input type="text" class="form-control" name="RC_MIN" value="<?= $rv_rangoCriticoMin ?>" /></td>
          <td><input type="text" class="form-control" name="RV_MIN" value="<?= $rv_rangoValidoMin ?>" /></td>
          <td><input type="text" class="form-control" name="RV_MAX" value="<?= $rv_rangoValidoMax ?>" /></td>
          <td><input type="text" class="form-control" name="RC_MAX" value="<?= $rv_rangoCriticoMax ?>" /></td>
          <td><input type="date" class="form-control" name="F_REGISTRO" value="<?= $rv_fechaRegistro ?>" /></td>
        </tr>
      </tbody>
    </table>
    <input type="hidden" name="modificarRegistroRangos" value="modificarRegistroRangos" />
    <input type="hidden" name="ID_RANGOS" value="<?= $idRegistroRangos ?>" />
  </form>
</div>
<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cancelar
  </button>
  <button type="submit" class="btn btn-success btn-sm pull-right" id="grabar">
    <i class="fa fa-lg fa-save"></i> Grabar
  </button>
</div>

<script>
  $("#grabar").click(function() {
    $("#formEditRango").submit();
  })

  $('#formEditRango').on('submit', function(e) {
    var form = $("#formEditRango");

    $.post($(form).attr('action'), $(form).serialize(), function(data) {
      if (data.exito) {
        exito();
        location.reload();
      } else {
        error(data.mensaje);
      }
    }, 'json');
  });
</script>