<?php
define('PERMITIDO', true);
$pagina = 0;
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
require_once("../lib/datos_mysql.php");
require_once('../assets/php/ssp.php');
header('Content-Type: text/html; charset=UTF-8');

function estadoResultadosAtencion($nro_examenes, $nro_resultados, $nro_validados)
{
  if ($nro_examenes == 0) return "<i class='txt-color-blue fa fa-exclamation-triangle fa-lg'></i> Exámenes Derivados";
  $resultadosFaltantes = $nro_examenes - $nro_resultados;
  $validacionesFaltantes = $nro_resultados - $nro_validados;
  if ($resultadosFaltantes > 0) return "<i class='txt-color-red fa fa-exclamation-triangle fa-lg'></i> Faltan " . $resultadosFaltantes . " resultados";
  if ($validacionesFaltantes > 0) return "<i class='txt-color-yellow fa fa-exclamation-triangle fa-lg'></i> Faltan " . $validacionesFaltantes . " validaciones";
  return "<i class='txt-color-green fa fa-check fa-lg'></i> Completado";
}

$dbDetails = array(
  'host' => $hostname_conexionlab,
  'user' => $username_conexionlab,
  'pass' => $password_conexionlab,
  'db'   => $database_conexionlab,
  'charset' => 'utf8'
);

$id_ar_numero = isset($_POST['id_ar']) && $_POST['id_ar'] != "" ?  $_POST['id_ar'] : "";

$f_desde = isset($_POST["f_desde"]) && $_POST["f_desde"] != "" ? " AND FECHA_ATEE >= '{$_POST["f_desde"]}'" : "";
$f_hasta = isset($_POST['f_hasta']) && $_POST['f_hasta'] != "" ? " AND FECHA_ATEE <= '{$_POST['f_hasta']}'" : "";
$id_cc   = isset($_POST['id_cc'])   && $_POST['id_cc']   != "" ? " AND ID_CENTRO_CONTACTO = {$_POST['id_cc']}" : "";
$id_con  = isset($_POST['id_con'])  && $_POST['id_con']  != "" ? " AND ID_EMPRESA = {$_POST['id_con']}" : "";
$id_ar   = isset($_POST['id_ar'])   && $_POST['id_ar']   != "" ? " AND ea.NRO_HOJA_TRABAJO = {$_POST['id_ar']}" : "";

$table2 = <<<EOT
(
  SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHATE, p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO,CONCAT_WS(' ',p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO) AS NOMBREP,
  cg.DESCRIPCION_CG AS NIVUR, a.NIVEL_URGENCIA, cg2.DESCRIPCION_CG AS MOTPRIO, ccto.NOMBRE AS LOCAL, e.NBR AS CONVENIO,
  COUNT(ea.ID_EXATE) AS NRO_EXAMENES, COUNT(ea.RESULTADO) AS NRO_RESULTADOS, COUNT(ea.USUARIO_VAL) AS NRO_VALIDADOS, GROUP_CONCAT(ea.COD_EXAMEN) AS GC_COD_EXAMENES, ea.NRO_HOJA_TRABAJO, DATE_FORMAT(a.FECHA,'%Y-%m-%d') AS FECHA_ATEE,a.FECHA,a.ID_CENTRO_CONTACTO,e.ID_EMPRESA 
  FROM atenciones a
  LEFT JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION 
  LEFT JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO 
  LEFT JOIN centros_contacto ccto ON a.ID_CENTRO_CONTACTO = ccto.ID_CENTRO_CONTACTO
  LEFT JOIN empresas e ON a.ID_CONVENIO = e.ID_EMPRESA 
  INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA 
  INNER JOIN codigos_generales cg ON a.NIVEL_URGENCIA = cg.CODIGO AND cg.COD_TABLA = 'SIS_NIVURG'
  LEFT JOIN codigos_generales cg2 ON a.MOTIVO_PRIORIZACION = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_MOTPRIO'
  WHERE a.CIERRE_RES = 'N' AND a.FLAG_ELIMINADO = 0 AND a.FECHA_R IS NOT NULL AND (ex.FLAG_AGRUPACION = 'N' OR ex.FLAG_AGRUPACION IS NULL) $id_ar
  GROUP BY a.ID_ATENCION
) temp
EOT;

# ORDER BY NIVUR ASC, a.FECHA ASC, a.ID_ATENCION ASC
# HAVING (GC_COD_EXAMENES != '00.00.069' OR GC_COD_EXAMENES IS NULL) 

// Table's primary key 
$primaryKey = 'ID_ATENCION';

// Array of database columns which should be read and sent back to DataTables. 
// The `db` parameter represents the column name in the database.  
// The `dt` parameter represents the DataTables column identifier. 
$columns = array(
  array('db' => 'ID_ATENCION', 'dt' => 0),
  array('db' => 'FECHATE', 'dt' => 1),
  array('db' => 'LOCAL', 'dt' => 2),
  array('db' => 'CONVENIO', 'dt' => 3, 'formatter' => function ($d, $row) {
    return !$d ? "-" : $d;
  }),
  array(
    'db' => 'NOMBREP',
    'dt' => 4,
    'formatter' => function ($d, $row) {
      return $d;
    }
  ),
  array('db' => 'MOTPRIO', 'dt' => 5),
  array(
    'db' => 'NIVUR',
    'dt' => 6,
    'formatter' => function ($d, $row) {
      return $d;
    }
  ),
  array(
    'db' => 'ID_ATENCION',
    'dt' => 7,
    'formatter' => function ($d, $row) {
      $estadoResultados = estadoResultadosAtencion($row['NRO_EXAMENES'], $row['NRO_RESULTADOS'], $row['NRO_VALIDADOS']);
      return $estadoResultados;
    }
  ),
  array(
    'db' => 'ID_ATENCION',
    'dt' => 8,
    'formatter' => function ($d, $row, $id_ar) {
      global $id_ar_numero;
      return  "<a title='Registrar Resultados' href='e_resultados.php?idate=" . $d . "&ar=" . $id_ar_numero . "&f_desde={$_POST["f_desde"]}&f_hasta={$_POST["f_hasta"]}&id_cc={$_POST["id_cc"]}&id_con={$_POST["id_con"]}'><i class='fa fa-edit fa-lg'></i></a>";
    }
  ),
  array('db' => 'FECHA_ATEE', 'dt' => 9),
  array('db' => 'NRO_EXAMENES', 'dt' => 10),
  array('db' => 'NRO_RESULTADOS', 'dt' => 11),
  array('db' => 'NRO_VALIDADOS', 'dt' => 12)
);

echo json_encode(
  SSP::simple(
    $_POST,
    $dbDetails,
    $table2,
    $primaryKey,
    $columns,
    null,
    "1
    $f_desde
    $f_hasta
    $id_cc
    $id_con"
  ),
  JSON_UNESCAPED_UNICODE
);
