<?php

function campo_rangos($valor, $tipoVariable, $decimales, $flagRangoValidacion, $RVMIN, $RVMAX, $RCMIN, $RCMAX, $RRMIN, $RRMAX, $titulo) {

	if ($valor == "") return ["html" => ""];
	if ($RCMIN == "" && $RCMAX == "" && $flagRangoValidacion == 0) return ["html" => ""];
	if ($RCMIN == "" && $RCMAX == "" && $flagRangoValidacion == 1) return ["html" => '<a class="badge bg-color-blue" style="margin-top:5px"> Rangos Pendientes </a>'];

	$flag_resultadoCritico = false;
	if ($tipoVariable == 1) {
		if ($decimales == "") $decimales = 2;
		$valor = number_format($valor, $decimales, ',', '.');
		$RVMAXa = number_format($RVMAX, $decimales, ',', '.');
		$RVMINa = number_format($RVMIN, $decimales, ',', '.');
		$RCMAXa = number_format($RCMAX, $decimales, ',', '.');
		$RCMINa = number_format($RCMIN, $decimales, ',', '.');

		$contenido = "
		<div class='row text-center'>
			<div class='col-md-12'> $titulo </div>
		</div>
		<div class='text-center txt-color-white' style='font-weight:bold'>
			<div class='row' style='background-color:grey; margin-top:5px'>
				Fuera de rango <br>
				> $RCMAXa 
			</div>
			<div class='row' style='background-color:darkred'>
				Rango crítico <br>
				$RVMAXa - $RCMAXa 
			</div>
			<div class='row' style='background-color:darkgreen'>
				Rango válido <br>
				$RVMINa - $RVMAXa 
			</div>
			<div class='row' style='background-color:darkred'>
				Rango crítico <br>
				$RCMINa - $RVMINa 
			</div>
			<div class='row' style='background-color:grey'>
				Fuera de rango <br>
				< $RCMINa 
			</div>
		</div>";

		$valor = str_replace(',', '.', $valor);
		$RVMAX = str_replace(',', '.', $RVMAX);
		$RVMIN = str_replace(',', '.', $RVMIN);
		$RCMAX = str_replace(',', '.', $RCMAX);
		$RCMIN = str_replace(',', '.', $RCMIN);

		$rango = 'error!';
		$color = 'bg-color-yellow';

		if ($valor < $RCMIN || $valor > $RCMAX) {
			$rango = "Fuera de rango";
			$color = 'bg-color-default';
		}
		if ($valor < $RVMIN || $valor > $RVMAX) {
			$rango = 'Rango crítico';
			$color = 'bg-color-red';
			$flag_resultadoCritico = true;
		}
		if ($valor >= $RVMIN && $valor <= $RVMAX) {
			$rango = 'Rango válido';
			$color = 'bg-color-green';
		} 


		$html = '<a class="badge ' . $color . '" rel="popover" data-placement="top" data-original-title="Rangos de Validación" data-content="' . $contenido . '" data-html="true" style="margin-top:5px">' . $rango . '</a>';
		return ["html" => $html, "flag_resultadoCritico" => $flag_resultadoCritico];
		# return ["html" => "$valor < $RVMIN", "flag_resultadoCritico" => $flag_resultadoCritico];
	}
}

function campo_resultado($idea, $idAtencion, $codigoExamen, $nombreExamen, $tipoVariable, $unidadMedida, $resultado, $decimales, $RVMIN, $RVMAX, $RCMIN, $RCMAX, $referencia, $formula, $padre, $usuarioValida) {
	global $usuario_perfil;
	global $mysqli;
	global $autorizaciones;

	$disabled = "";
	$stateDisabled = "";
	if ($usuarioValida != "" && $usuario_perfil != "ADMINISTRADOR" && !in_array(48, $autorizaciones)) {
		$disabled = "disabled";
		$stateDisabled = "state-disabled";
	}

	// if ($decimales == "") $decimales = 2;
	// $disabled = !in_array(48, $autorizaciones) && $usuarioValida != "" ? "disabled" : "";
	// $stateDisabled = !in_array(48, $autorizaciones) && $usuarioValida != "" ? "state-disabled" : "";

	if ($formula != "") {
		# consulto las variables del examen padre
		$qVariablesFormula = $mysqli->prepare('SELECT VAR, RESULTADO, COD_EXAMEN
		FROM examenes_atenciones eat
		INNER JOIN agrupaciones_examenes aex ON aex.COD_EXAMEN_AGRUPADO = eat.COD_EXAMEN
		WHERE COD_INTERNO = ? AND VAR IS NOT NULL AND eat.ID_ATENCION = ?');
		$qVariablesFormula->bind_param('si', $padre, $idAtencion);
		$qVariablesFormula->execute();
		$qVariablesFormula->bind_result($var_variable, $var_resultado, $var_codExamen);
		$qVariablesFormula->store_result();
		while ($qVariablesFormula->fetch()) {
			if (strpos($formula, $var_variable) !== false) {
				if ($var_resultado == "") return "<span class='label label-primary txt-color-white' style='padding:5px;'>Faltan resultados para completar la fórmula</span>";
				if (!is_numeric($var_resultado)) return "<span class='label label-danger txt-color-white' style='padding:5px;'>Valor de exámen '$var_codExamen' no es numérico</span>";
				$calculo = str_replace($var_variable, $var_resultado, $formula);
				$formula = $calculo;
			}
		}
		$qVariablesFormula->close();
		eval("\$formula = $formula;"); # evaluo la formula
		if (!is_numeric($formula)) return '<span class="label label-danger" style="padding:5px;">ERROR</span>';
		$q_update = $mysqli->prepare("UPDATE examenes_atenciones SET RESULTADO = ? WHERE COD_EXAMEN = ? AND ID_ATENCION = ?");
		$q_update->bind_param('ssi', $formula, $codigoExamen, $idAtencion);
		$q_update->execute();
		$q_update->close();
		$valor = number_format($formula, $decimales, ".", "") . " " . $unidadMedida;

		if ($formula < $RCMIN || $formula > $RCMAX) {
			$html_campoResultado = "
			<label class='input txt-color-red'> $valor &nbsp;&nbsp;&nbsp; 
				<i class='fa fa-exclamation-circle fa-2x txt-color-red' style='padding-top:5px;'></i>
			</label>";
			return $html_campoResultado;
		}

		return $valor;
	} else { # si el campo no es formula

		$inputID = "<input type='hidden' name='idea[]' value='$idea' $disabled/>";
		$fondoBlancoInput = $resultado != "" ? "" : "style='background:white !important;'";

		if ($tipoVariable == 1) { # numérico
			if ($resultado != '' && is_numeric(str_replace(',', '.', $resultado))) {
				$resultado = str_replace(',', '.', $resultado);
				$resultado = number_format($resultado, $decimales, '.', '');
			}

			$rv = $RVMAX;
			$rc = $RCMAX;
			$RVMAX = number_format($RVMAX, $decimales, '.', '');
			$RVMIN = number_format($RVMIN, $decimales, '.', '');

			if ($unidadMedida != 'S/U.M.' && is_numeric($resultado)) { # con unidad de medida
				$html_campoResultado = "
				<label class='input $stateDisabled'>
					<i class='icon-append' style='width: 6em;'> $unidadMedida </i>
					<input $fondoBlancoInput type='text' class='input-md soloNumeros' name='resultado[]' value='$resultado' $disabled tabindex='1'/>
				</label>
				$inputID";
				return $html_campoResultado;
			} elseif (is_numeric($resultado)) { # numerico pero sin unidad de medida (permito esto?)
				$html_campoResultado = "
				<label class='input $stateDisabled'>
					<input $fondoBlancoInput type='text' class='input-md soloNumeros' name='resultado[]' value='$resultado' $disabled tabindex='1'/>
				</label> $inputID";
				return $html_campoResultado;
			} elseif (!is_numeric($resultado)) { # no numerico pero sin unidad de medida (permito esto?)
				$html_campoResultado = "
				<label class='input $stateDisabled'>
				<i class='icon-append' style='width: 6em;'> $unidadMedida </i>
					<input $fondoBlancoInput type='text' class='input-md soloNumeros' name='resultado[]' value='$resultado' $disabled tabindex='1'/>
				</label> $inputID";
				return $html_campoResultado;
			}
		} elseif ($tipoVariable == "2") { # alfanumérico
			$qvalores = $mysqli->prepare('SELECT cg.CODIGO, cg.DESCRIPCION_CG, cg.FLAG_ELIMINADO
			FROM examenes_atenciones ea
			INNER JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
			INNER JOIN tablas_generales tg ON tg.ID_TG = ex.TABLA_VAL
			INNER JOIN codigos_generales cg ON cg.COD_TABLA = tg.COD_TABLA AND cg.FLAG_ELIMINADO IS NULL
			WHERE ID_EXATE = ?');
			$qvalores->bind_param('i', $idea);
			$qvalores->execute();
			$qvalores->bind_result($valor_codigo, $valor_descripcion);
			$selectResultado = "<select name='resultado[]' $disabled $fondoBlancoInput tabindex='1'> <option value=''>--Seleccione--</option>";
			while ($qvalores->fetch()) {
				$selected = $valor_descripcion == $resultado ? "selected" : "";
				$selectResultado .= "<option value='$valor_descripcion' $selected> $valor_descripcion </option>";
			}
			$selectResultado .= "</select><i></i>";

			if ($resultado == $referencia || $resultado == "" || $referencia == "") {
				$html_campoResultado = "
				<label class='select $stateDisabled'> 
					$selectResultado 
				</label> 
				$inputID";
				return $html_campoResultado;
			}

			$html_campoResultado = "
			<label class='select $stateDisabled'> 
				$selectResultado 
			</label>
			$inputID";
			return $html_campoResultado;

		} elseif ($tipoVariable == "3") { # texto
			$classPred = $resultado == "" ? "commentsPrededinido" : "";
			$html_campoResultado = "<a href='' data-type='textarea' data-cod='$codigoExamen' data-pk='$idea' data-placeholder='' data-original-title='Modificar Comentario' class='editable comments editable-pre-wrapped editable-click $classPred'> $resultado </a>";
			return $html_campoResultado;
		}
	}
}

function campo_resAnt($idAtencion, $codExamen, $idPaciente, $R) { #resultados anteriores
	global $mysqli;

	$qAnteriores = $mysqli->prepare("SELECT ea.ID_ATENCION, ea.RESULTADO, ex.NOMBRE, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), 
	cg.DESCRIPCION_CG, N_DECIMALES, TIPO_VARIABLE, PORC_DIFERENCIA
	FROM examenes_atenciones ea
	INNER JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
	INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
	LEFT JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA = cg.CODIGO AND cg.COD_TABLA = 'SIS_UNIMED'
	WHERE a.ID_CLIENTE = ? AND ea.COD_EXAMEN = ?
	AND ea.ID_ATENCION  < ?
	ORDER BY FECHA DESC
	LIMIT 4");
	$qAnteriores->bind_param('isi', $idPaciente, $codExamen, $idAtencion);
	$qAnteriores->execute();
	$qAnteriores->bind_result($ant_idAtencion, $ant_resultado, $ant_nombre, $ant_fecha, $ant_unidad, $ant_nDecimales, $ant_tipoVariable, $ant_porcDif);
	$qAnteriores->store_result();
	$totalRows_Anteriores = $qAnteriores->num_rows;

	$contenido = "
	<table class='table table-bordered' style='font-size:11px'>
		<thead>
			<tr>
				<th>Atencion</th>
				<th>Fecha</th>
				<th>Resultado</th>
			</tr>
		</thead>
		<tbody>";

	$i = 0;
	$porc_dif = "";

	while ($qAnteriores->fetch()) {
		$decimales = 2;
		if ($ant_nDecimales != '') $decimales = $ant_nDecimales;
		$res = $ant_resultado;
		if ($ant_tipoVariable == 1) $res = number_format($ant_resultado, $decimales, ',', '.');

		$contenido .= '
		<tr>
			<td>' . $ant_idAtencion . '</td>
			<td>' . $ant_fecha . '</td>
			<td>' . $res . ' ' . $ant_unidad . '</td>
		</tr>';

		if ($i == 0) { # para usar en porcentaje de diferencia con resultado anterior
			$RANT = $res;
			$porc_dif = $ant_porcDif;
		}
		$i++;
	}

	$qAnteriores->close();

	$contenido .= '</tbody></table>';
	$title = "% diferencia Maximo: $porc_dif <br>";
	$tabla_ra = 
	'<a class="btn btn-link" rel="popover" data-placement="top" data-original-title="Resultados Anteriores" data-content="' . $title . $contenido . '" data-html="true" >
		<i class="fa fa-folder-open-o fa-lg"></i>
	</a>';

	/* porcentaje diferencia */
	if ($totalRows_Anteriores > 0 && $porc_dif != '' && $R != '') {
		$R = number_format($R, $decimales, ',', '.'); //formateo
		$RANT = str_replace(',', '.', $RANT); //reemplazo para comparar numeros
		$R = str_replace(',', '.', $R);

		$limsup = $RANT + ($RANT * ($porc_dif / 100));
		$liminf = $RANT - ($RANT * ($porc_dif / 100));

		if ($R > $limsup) $sobre = 1;
		if ($R < $liminf) $bajo = 1;
	}

	$diferencia = "";
	if (isset($sobre)) {
		$contenido2 = '
		Sobre limite Resultado Anterior<br/>
		Porcentaje Max Diferencia: ' . $porc_dif . '<br/>
		Resultado Anterior: ' . $RANT;
		$diferencia = '
		<a style="padding:0;" class="btn btn-link" rel="popover-hover" data-placement="top" data-original-title="Limite Excedido" data-content="' . $contenido2 . '" data-html="true" >
			<i style="padding-left:0em;" class="fa fa-arrow-circle-up fa-2x txt-color-orange"></i>
		</a>';
	}
	if (isset($bajo)) {
		$contenido2 = '
		Bajo limite Resultado Anterior <br/>
		Porcentaje Max Diferencia: ' . $porc_dif . '<br/>
		Resultado Anterior: ' . $RANT;
		$diferencia = '
		<a style="padding:0;" class="btn btn-link" rel="popover-hover" data-placement="top" data-original-title="Limite Excedido" data-content="' . $contenido2 . '" data-html="true" >
			<i style="padding-left:0em;" class="fa fa-arrow-circle-down fa-2x txt-color-orange"></i>
		</a>';
	}
	return array('tabla' => $tabla_ra, 'diferencia' => $diferencia);
}
