<?php
define('PERMITIDO', true);
$pantalla_actual = 'REG_RES_MUE_R2';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

function estadoExamenesResultados($nro_examenes, $nro_resultados)
{
  if ($nro_examenes == 0) return "No tiene exámenes";
  if ($nro_examenes == $nro_resultados) return "<i class='txt-color-green fa fa-check fa-lg'></i> Todos los exámenes con resultado"; # <span class='badge bg-color-green'> Todos los exámenes con resultados </span>
  $examenesSinResultados = $nro_examenes - $nro_resultados;
  if ($examenesSinResultados == 0) return "<i class='txt-color-blue fa fa-clock-o fa-lg'></i> No tiene exámenes sin resultado $nro_examenes $nro_resultados por ahora";
  return "<i class='txt-color-yellow fa fa-exclamation-triangle fa-lg'></i> $examenesSinResultados exámenes sin resultado";
}

function estadoExamenesValidados($nro_examenes, $nro_resultados, $nro_validados)
{
  if ($nro_examenes == $nro_validados) return "<i class='txt-color-green fa fa-check fa-lg'></i> Todos los exámenes validados";
  $examenesSinValidar = $nro_resultados - $nro_validados;
  if ($examenesSinValidar == 0) return "<i class='txt-color-blue fa fa-clock-o fa-lg'></i> No tiene exámenes con resultado sin validar por ahora";
  return "<i class='txt-color-yellow fa fa-exclamation-triangle fa-lg'></i> $examenesSinValidar exámenes con resultado sin validar";
}

function estadoExamenesInformados($nro_examenes, $nro_validados, $nro_informados)
{
  if ($nro_examenes == $nro_informados) return "<i class='txt-color-green fa fa-check fa-lg'></i> Todos los exámenes informados";
  $examenesSinValidar = $nro_validados - $nro_informados;
  if ($examenesSinValidar == 0) return "<i class='txt-color-blue fa fa-clock-o fa-lg'></i> No tiene exámenes validados sin informar por ahora";
  return "<i class='txt-color-yellow fa fa-exclamation-triangle fa-lg'></i> $examenesSinValidar exámenes validados sin informar";
}

$opciones_local = '<option value="">-</option>';
$qCentrosContacto = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto ORDER BY NOMBRE ASC");
$qCentrosContacto->execute();
$qCentrosContacto->bind_result($l_idLocal, $l_nombre);
while ($qCentrosContacto->fetch()) {
  $selected = $l_idLocal == $_GET['id_cc'] ? 'selected' : '';
  $opciones_local .= "<option value='$l_idLocal' $selected> $l_nombre </option>";
}
$qCentrosContacto->close();

$opciones_convenio = '<option value="">-</option>';
$qConvenios = $mysqli->prepare("SELECT ID_EMPRESA, NBR FROM empresas WHERE FLAG_CONVENIO = 'S' ORDER BY NBR ASC");
$qConvenios->execute();
$qConvenios->bind_result($e_idEmpresa, $e_nbr);
while ($qConvenios->fetch()) {
  $selected = $e_idEmpresa == $_GET['id_con'] ? 'selected' : '';
  $opciones_convenio .= "<option value='$e_idEmpresa' $selected> $e_nbr </option>";
}
$qConvenios->close();

mysql_select_db($database_conexionlab, $conexionlab);
$query_areas = "SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_AREAS' ORDER BY DESCRIPCION_CG";
$areas = mysql_query($query_areas, $conexionlab) or die(mysql_error());
$select_areas = '<option value="">--Seleccione--</option>';
while ($row_areas = mysql_fetch_assoc($areas)) {
  $selected = isset($_GET['area']) && $_GET['area'] == $row_areas['CODIGO'] ? "selected" : "";
  $select_areas .= '<option value="' . $row_areas['CODIGO'] . '" ' . $selected . '>' . $row_areas['DESCRIPCION_CG'] . '</option>';
}

$f_desde = isset($_GET["f_desde"]) && $_GET["f_desde"] != "" ? " AND a.FECHA >= '{$_GET["f_desde"]}'" : "";
$f_hasta = isset($_GET['f_hasta']) && $_GET['f_hasta'] != "" ? " AND a.FECHA <= '{$_GET['f_hasta']}'" : "";
$id_cc = isset($_GET['id_cc']) && $_GET['id_cc'] != "" ? " AND a.ID_CENTRO_CONTACTO = {$_GET['id_cc']}" : "";
$id_con = isset($_GET['id_con']) && $_GET['id_con'] != "" ? " AND e.ID_EMPRESA = {$_GET['id_con']}" : "";
$filtroArea = isset($_GET['area']) && $_GET['area'] != "" ? " AND ea.NRO_HOJA_TRABAJO = {$_GET['area']}" : "";

mysql_select_db($database_conexionlab, $conexionlab);
$query_atenciones = "SELECT a.ID_ATENCION, a.FECHA, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA_ATENCION, CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO) AS NOMBRE_PACIENTE,
ccto.NOMBRE AS NOMBRE_LOCAL, e.NBR AS NBR_CONVENIO, cg.DESCRIPCION_CG AS NIVEL_URGENCIA, cg2.DESCRIPCION_CG AS MOTIVO_PRIO,
COUNT(ea.COD_EXAMEN) AS NRO_EXAMENES, 
COUNT(ea.RESULTADO) AS NRO_RESULTADOS,
COUNT(ea.USUARIO_VAL) AS NRO_VALIDADOS, 
COUNT(ea.ID_ARCHIVO) AS NRO_EXAMENES_INFORMADOS, 
GROUP_CONCAT(ea.COD_EXAMEN) AS GC_COD_EXAMENES
FROM atenciones a
INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION 
INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO AND (ex.FLAG_AGRUPACION = 'N' OR ex.FLAG_AGRUPACION IS NULL) AND ex.nombre NOT LIKE '%TOMA DE MUESTRA%'
LEFT JOIN centros_contacto ccto ON a.ID_CENTRO_CONTACTO = ccto.ID_CENTRO_CONTACTO
LEFT JOIN empresas e ON a.ID_CONVENIO = e.ID_EMPRESA 
INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA 
INNER JOIN codigos_generales cg ON a.NIVEL_URGENCIA = cg.CODIGO AND cg.COD_TABLA = 'SIS_NIVURG'
LEFT JOIN codigos_generales cg2 ON a.MOTIVO_PRIORIZACION = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_MOTPRIO'
WHERE a.CIERRE_RES = 'N' AND a.FLAG_ELIMINADO = 0 AND a.FECHA_R IS NOT NULL
$f_desde $f_hasta $id_cc $id_con $filtroArea
GROUP BY a.ID_ATENCION";
$atenciones = mysql_query($query_atenciones, $conexionlab) or die(mysql_error());
$row_atenciones = mysql_fetch_assoc($atenciones);
$totalRows_atenciones = mysql_num_rows($atenciones);

ob_start();
?>

<form action="" method="get" class="smart-form">
  <div class="row">
    <section class="col col-2">
      <label class="input">
        <input name="f_desde" class="input-sm" type="date" value="<?php if (isset($_GET['f_desde'])) echo $_GET['f_desde'] ?>" />
        <div class="note">Fecha Desde</div>
      </label>
    </section>
    <section class="col col-2">
      <label class="input">
        <input name="f_hasta" class="input-sm" type="date" value="<?php if (isset($_GET['f_hasta'])) echo $_GET['f_hasta'] ?>" />
        <div class="note">Fecha Hasta</div>
      </label>
    </section>
    <section class="col col-2">
      <select name="id_cc" class="select2">
        <?= $opciones_local ?>
      </select>
      <div class="note">Local</div>
    </section>
    <section class="col col-2">
      <select name="id_con" class="select2">
        <?= $opciones_convenio ?>
      </select>
      <div class="note">Convenio</div>
    </section>
    <section class="col-md-2">
      <div class="btn-group">
        <button class="btn btn-sm btn-success" type="submit"> <i class="fa fa-search"> </i>Filtrar</button>
        <a class="btn btn-sm btn-info" href="l_atenciones_p.php" style="margin-left: 5px">Ver todo</a>
      </div>
    </section>
  </div>
  <div class="row">
    <section class="col col-4">
      <select name="area" id="area" class="select2">
        <?= $select_areas ?>
      </select>
      <div class="note">Area</div>
    </section>
  </div>
</form>

<table class="table table-hover table-bordered" id="dataTable-pagos">
  <thead>
    <tr bgcolor="#999999">
      <th>Atención</th>
      <th>Fecha</th>
      <th>Procedencia</th>
      <th>Convenio</th>
      <th>Paciente</th>
      <th>Motivo priorización</th>
      <th>Nivel</th>
      <th>Estado de resultados</th>
      <th>Estado de validación de resultados</th>
      <th>Estado de informe de resultados</th>
      <th>Resultados</th>
    </tr>
  </thead>
  <tbody>
    <?php do { ?>
      <tr>
        <td><?= $row_atenciones['ID_ATENCION'] ?></td>
        <td><?= $row_atenciones['FECHA_ATENCION'] ?></td>
        <td><?= $row_atenciones['NOMBRE_LOCAL'] ?></td>
        <td><?= $row_atenciones['NBR_CONVENIO'] == null ? '-' : $row_atenciones['NBR_CONVENIO']; ?></td>
        <td><?= $row_atenciones['NOMBRE_PACIENTE'] ?></td>
        <td><?= $row_atenciones['MOTIVO_PRIO'] ?></td>
        <td><?= $row_atenciones['NIVEL_URGENCIA'] ?></td>
        <td><?= estadoExamenesResultados($row_atenciones['NRO_EXAMENES'], $row_atenciones['NRO_RESULTADOS']) ?></td>
        <td><?= estadoExamenesValidados($row_atenciones['NRO_EXAMENES'], $row_atenciones['NRO_RESULTADOS'], $row_atenciones['NRO_VALIDADOS']) ?></td>
        <td><?= ($row_atenciones['FECHA'] >= "2023-03-14") ? estadoExamenesInformados($row_atenciones['NRO_EXAMENES'], $row_atenciones['NRO_RESULTADOS'], $row_atenciones['NRO_EXAMENES_INFORMADOS']) : "-" ?></td>
        <td align="center">
          <a title='Registrar Resultados' href='e_resultados.php?idate=<?= $row_atenciones['ID_ATENCION'] ?>&ar=<?= $_GET['area'] ?>&f_desde=<?= $_GET['f_desde'] ?>&f_hasta=<?= $_GET['f_hasta'] ?>&id_cc=<?= $_GET['id_cc'] ?>&id_con=<?= $_GET['id_con'] ?>'><i class='fa fa-edit fa-lg'></i></a>
        </td>
      </tr>
    <?php } while ($row_atenciones = mysql_fetch_assoc($atenciones)); ?>
  </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('#dataTable-pagos').DataTable({
      searchDelay: 350,
      'lengthMenu': [
        [50, 100, 200, 500],
        [50, 100, 200, 500]
      ],
      "language": {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [
        [6, "desc"],
        [1, "desc"]
      ],
      "columnDefs": [{
          targets: [7, 8, 9, 10],
          orderable: false
        },
        {
          targets: [1],
          type: "date-eu"
        }
      ],
      'destroy': true,
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>