<?php

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ServerException;

$pagina = 28; #modificar
define('PERMITIDO', true);
require_once __DIR__ . "/../inc/init.php";
require_once __DIR__ . "/config.php";
$fechaActual = date('Y-m-d');
$horaActual = date("H:i");

function updateResultado($valor, $id)
{
	global $mysqli;
	$qUpdateResultado = $mysqli->prepare("UPDATE examenes_atenciones SET RESULTADO = '$valor' WHERE ID_EXATE = $id AND USUARIO_VAL IS NULL LIMIT 1");
	$qUpdateResultado->execute();
	$qUpdateResultado->close();
};

function resultadosCalculados($idate)
{
	global $mysqli;
	$qExa = $mysqli->prepare("SELECT ID_EXATE, COD_EXAMEN, RESULTADO, USUARIO_VAL FROM examenes_atenciones WHERE ID_ATENCION = $idate");
	$qExa->execute();
	$qExa->bind_result($ex_id, $ex_codigo, $ex_resultado, $usuario_val);
	while ($qExa->fetch()) {
		# NITRÓGENO UREICO #
		if ($ex_codigo == "02.02.157") $IdNitrogUrei = $ex_id;
		if ($ex_codigo == "02.02.057") $uremia = $ex_resultado;
		# NITRÓGENO UREICO POST HD #
		if ($ex_codigo == "02.02.557") $IdNitrogUreiPs = $ex_id;
		if ($ex_codigo == "02.02.576") $uremiaPs = $ex_resultado;
		# C. CREATININEMIA #
		if ($ex_codigo == "00.00.042") $idVFG = $ex_id;
		if ($ex_codigo == "02.02.023") $crea = $ex_resultado;
		# TIBC y % SATURACIÓN DE TRANSFERRINA #
		if ($ex_codigo == "04.01.228") $idTibc = $ex_id;
		if ($ex_codigo == "04.01.128") $idPorcSatTransferrina = $ex_id;
		if ($ex_codigo == "04.01.028") $fierro = $ex_resultado;
		if ($ex_codigo == "02.02.328") $uibc = $ex_resultado;
		# HOMA #
		if ($ex_codigo == "03.03.517") $idHoma = $ex_id;
		if ($ex_codigo == "03.03.017") $insulinaBasal = $ex_resultado;
		if ($ex_codigo == "02.02.481") $glicemia = $ex_resultado; # GLICEMIA EN AYUNA
		if ($ex_codigo == "02.02.047") $glicemia = $ex_resultado; # G. GLICEMIA 
	}
	$qExa->close();

	# NITRÓGENO UREICO #
	if ($IdNitrogUrei != "" && $uremia != "") {
		$nitrogUrei = $uremia / 2.14;
		updateResultado($nitrogUrei, $IdNitrogUrei);
	}
	# NITRÓGENO UREICO POST HD #
	if ($IdNitrogUreiPs != "" && $uremiaPs != "") {
		$nitrogUreiPs = $uremiaPs / 2.14;
		updateResultado($nitrogUreiPs, $IdNitrogUreiPs);
	}
	# C. CREATININEMIA #
	if ($idVFG != "" && $crea != "") {
		$qPac = $mysqli->prepare("SELECT TIMESTAMPDIFF(YEAR, p.FECHA_NACIMIENTO, a.FECHA) AS EDAD, p.GENERO, p.RAZA
		FROM personas p
		INNER JOIN atenciones a ON a.ID_CLIENTE = p.ID_PERSONA
		WHERE a.ID_ATENCION = $idate");
		$qPac->execute();
		$qPac->bind_result($p_edad, $p_genero, $p_raza);
		$qPac->fetch();
		$qPac->close();
		# 175X(CREA/88,4)exp-1,154 x (edad)exp-0,203 x (0,742 mujer) x (1,210 negro)
		$VFG = 175 * pow($crea, -1.154) * pow($p_edad, -0.203);
		if ($p_genero == 'F') $VFG = $VFG * 0.742;
		if ($p_raza == '2') $VFG = $VFG * 1.210; # Negro
		updateResultado($VFG, $idVFG);
	}
	# TIBC y % SATURACIÓN DE TRANSFERRINA #
	if ($idTibc != "" && $fierro != "" && $uibc != "") {
		$tibc = $fierro + $uibc;
		updateResultado($tibc, $idTibc);
	}
	if ($idPorcSatTransferrina != "" && $fierro != "" && $tibc != "") {
		$porcSatTransferrina = $fierro / $tibc * 100;
		updateResultado($porcSatTransferrina, $idPorcSatTransferrina);
	}
	# HOMA #
	if ($idHoma != "" && $insulinaBasal != "" && $glicemia != "") {
		$resultadoHoma = $insulinaBasal * $glicemia / 405;
		updateResultado($resultadoHoma, $idHoma);
	}
}

if (isset($_POST['name']) && $_POST['name'] == 'observacionesExamen') {
	$observacionesExamen = $_POST["value"] != "" ? $_POST["value"] : NULL;
	$qupdate = $mysqli->prepare('UPDATE examenes_atenciones SET OBSERVACIONES = ? WHERE ID_EXATE = ?');
	$qupdate->bind_param('si', $observacionesExamen, $_POST['pk']);
	$qupdate->execute();
	$qupdate->close();
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['name']) && $_POST['name'] == 'obs') {
	$qupdate = $mysqli->prepare('UPDATE obs_resultados SET OBS=? WHERE ID_OBS = ?');
	$qupdate->bind_param('si', $_POST['value'], $_POST['pk']);
	$qupdate->execute();
	$qupdate->close();
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['EliminarOBS'])) {
	$qdelObs = $mysqli->prepare('DELETE FROM obs_resultados WHERE ID_OBS = ?');
	$qdelObs->bind_param('i', $_POST['idobs']);
	$qdelObs->execute();
	$qdelObs->close();
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['name']) && ($_POST['name'] == 'resultadoN' || $_POST['name'] == 'resultadoT' || $_POST['name'] == 'resultadoA')) {
	$res = $_POST['name'] == 'resultadoN' ? str_replace(',', '.', $_POST['value']) : $_POST['value'];
	$qupdate = $mysqli->prepare('UPDATE examenes_atenciones SET RESULTADO = ?, ID_USUARIO_REG = ? WHERE ID_EXATE = ?');
	$qupdate->bind_param('sii', $res, $usuario_id, $_POST['pk']);
	$qupdate->execute();
	$qupdate->close();
}

# cerrar registro de resultados
if (isset($_POST['CerrarRes']) && $_POST['CerrarRes'] != "") {
	$qupdC = $mysqli->prepare("UPDATE atenciones SET CIERRE_RES = 'S' WHERE ID_ATENCION = ?");
	$qupdC->bind_param('i', $_POST['idate']);
	$qupdC->execute();
	$qupdC->close();
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

# validacion de resultados y obs
if (isset($_POST['updateResultados'])) {
	$idate = $_POST['id_atencion'];
	# En caso de que la fecha de toma de muestra o recepción de muestra sea nula, no inhabilita las operaciones de ingreso y validación de resultados.
	$sql_atencion = "SELECT FECHA_TM, HORA_TM, FECHA_R, HORA_R FROM atenciones WHERE ID_ATENCION = $idate";
	$resultado_atencion = $mysqli->query($sql_atencion);
	$datos_atencion = $resultado_atencion->fetch_assoc();

	// if ($datos_atencion['FECHA_TM'] == null || $datos_atencion['HORA_TM'] == null) {
	// 	$respuesta = ['exito' => false, 'mensaje' => 'Esta atención no posee fecha de toma de muestra.'];
	// 	echo json_encode($respuesta);
	// 	exit(0);
	// }
	// if ($datos_atencion['FECHA_R'] == null || $datos_atencion['HORA_R'] == null) {
	// 	$respuesta = ['exito' => false, 'mensaje' => 'Esta atención no posee fecha de recepción de muestra.'];
	// 	echo json_encode($respuesta);
	// 	exit(0);
	// }

	if (isset($_POST['idexa'])) { #validacion de resultados
		$validados = $_POST['idexa'];
		$s = count($validados);
		for ($a = 0; $a < $s; $a++) {
			$now = date('Y-m-d H:i:s');
			$qUpdate = $mysqli->prepare('UPDATE examenes_atenciones SET USUARIO_VAL=?, FECHA_VAL=? WHERE ID_EXATE=? AND RESULTADO IS NOT NULL');
			$qUpdate->bind_param('isi', $usuario_id, $now, $validados[$a]);
			$qUpdate->execute();
			$qUpdate->close();
			$qSelPadre = $mysqli->prepare('SELECT PADRE FROM examenes_atenciones WHERE ID_EXATE=?');
			$qSelPadre->bind_param('i', $validados[$a]);
			$qSelPadre->execute();
			$qSelPadre->bind_result($padre);
			$qSelPadre->fetch();
			$qSelPadre->close();
			if ($padre != '') {
				$qUpdate_pa = $mysqli->prepare('UPDATE examenes_atenciones SET USUARIO_VAL = ?, FECHA_VAL = ? WHERE ID_ATENCION = ? AND COD_EXAMEN = ?');
				$qUpdate_pa->bind_param('isis', $usuario_id, $now, $idate, $padre);
				$qUpdate_pa->execute();
				$qUpdate_pa->close();
			}
		}
	}

	if ($_POST['OBS'] != "") {
		$finf = isset($_POST['F_INF']) && $_POST['F_INF'] == 1 ? 1 : 0;
		$qinobs = $mysqli->prepare('INSERT INTO obs_resultados (ID_ATENCION, OBS, F_INF) VALUES (?, ?, ?)');
		$qinobs->bind_param('isi', $idate, $_POST['OBS'], $finf);
		$qinobs->execute();
		$qinobs->close();
	}

	$resultados = $_POST['resultado'];
	for ($i = 0; $i < count($resultados); $i++) {
		if ($resultados[$i] != "" || $usuario_perfil == "SUPERVISOR" || $usuario_perfil == "ADMINISTRADOR") {
			if ($resultados[$i] == "") $resultados[$i] = NULL;
			$qUpdate_pa = $mysqli->prepare('UPDATE examenes_atenciones SET RESULTADO = ?, ID_USUARIO_REG = ? WHERE ID_EXATE=?');
			$qUpdate_pa->bind_param('sii', $resultados[$i], $usuario_id, $_POST['idea'][$i]);
			$qUpdate_pa->execute();
			$qUpdate_pa->close();
		}
	}

	// if (isset($_POST['id_formula_examen']) && count($_POST['id_formula_examen']) > 0) {
	// 	for ($i = 0; $i < count($_POST['id_formula_examen']); $i++) {
	// 		if ($_POST['id_formula_examen'][$i] != "") {
	// 			$qUpdate_pa = $mysqli->prepare('UPDATE examenes_atenciones SET ID_FORMULA_EXAMEN = ? WHERE ID_EXATE = ? LIMIT 1');
	// 			$qUpdate_pa->bind_param('ii', $_POST['id_formula_examen'][$i], $_POST['idea'][$i]);
	// 			$qUpdate_pa->execute();
	// 			$qUpdate_pa->close();
	// 		}
	// 	}
	// }

	resultadosCalculados($idate);
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

// Generar informe con firma electrónica
if (isset($_POST['GenerarInformeConFirma'])) {
	include __DIR__ . '/../inc/vendor/autoload.php';

	$qMarcarAtencion = $mysqli->prepare('UPDATE atenciones SET FECHA_INF = ?, HORA_INF = ? WHERE ID_ATENCION = ? LIMIT 1');
	$qMarcarAtencion->bind_param('ssi', $fechaActual, $horaActual, $_POST['idate']);
	$qMarcarAtencion->execute();
	$qMarcarAtencion->close();

	$cliente = new Client(['headers' => ['Content-Type' => 'application/json']]);

	$jsonSolicitud = [
		'urlBajada' => "http://localhost/$carpeta_usuario_dominio/SILCLCE/i_resultados/pdf_p_cm.php?idate=" . $_POST['idate'],
		'urlSubida' => "http://localhost/$carpeta_usuario_dominio/SILCLCE/st_resultados/subir_informe_firmado.php?idate=" . $_POST['idate'] . '&idusu=' . $usuario_id,
		'razon' => 'Laboratorio Etcheverry Ltda.',
		'locacion' => 'Viña del Mar',
		'rut' => '10390679-2',
		'posicion' => 'custom',
		'numPagina' => 'last',
		'ulx' => 20,
		'uly' => 72
	];

	try {
		$respuesta = $cliente->post('http://localhost:8080/firma_elect', ['body' => json_encode($jsonSolicitud)]);
		$jsonRespuesta = json_decode($respuesta->getBody(), true);
		$envioCorreo = enviarCorreoInformeGenerado($_POST['idate']);
		if ($envioCorreo != "ok") $jsonRespuesta = array("exito" => false, "mensaje" => "Error en el envío del correo de informe generado. $envioCorreo");
		// $jsonRespuesta = array("exito"=>true, "mensaje"=>"wena $envioCorreo");
	} catch (ServerException $e) {
		updateFechaInformeNull($_POST['idate']);
		$respuesta = $e->getResponse()->getBody()->getContents();
		$jsonRespuesta = json_decode($respuesta, true);
	}

	echo json_encode($jsonRespuesta);
	exit(0);
}

// Generar informe sin firma electrónica
if (isset($_POST['GenerarInforme'])) {
	$update = $mysqli->prepare('UPDATE atenciones SET FECHA_INF = CURDATE() WHERE ID_ATENCION = ?');
	$update->bind_param('i', $_POST['idate']);
	$update->execute();
	$update->close();
	$respuesta = array('exito' => true, "mensaje" => "Informe generado correctamente");
	$envioCorreo = enviarCorreoInformeGenerado($_POST['idate']);
	if ($envioCorreo != "ok") array("exito" => false, "mensaje" => "Error en el envío del correo de informe generado. $envioCorreo");
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['name']) && $_POST['name'] == 'txt_pre') {
	$update = $mysqli->prepare('UPDATE examenes_atenciones SET RESULTADO = ? WHERE ID_EXATE = ?');
	$update->bind_param('si', $_POST['value'], $_POST['pk']);
	$update->execute();
	$update->close();
	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

function updateFechaInformeNull($id_atencion)
{
	global $mysqli;

	$qUpdateFechaInforme = $mysqli->prepare('UPDATE atenciones SET FECHA_INF = NULL WHERE ID_ATENCION = ? LIMIT 1');
	$qUpdateFechaInforme->bind_param('i', $id_atencion);
	$qUpdateFechaInforme->execute();
	$qUpdateFechaInforme->close();

	return true;
}
