<?php
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ServerException;

define('PERMITIDO', true);

$pantalla_actual = 'REG_RES_PCR';

require_once __DIR__ . "/../inc/init.php";
require_once __DIR__ . "/config.php";

function modificarResultado($resultado, $id_usuario, $id_examen_atencion) {
	global $mysqli;
	
	if (strpos($resultado, 'Referencia:') === false) return false;
	
	$modificar = $mysqli->prepare("UPDATE examenes_atenciones SET RESULTADO = ?, ID_USUARIO_REG = ? WHERE ID_EXATE = ? AND USUARIO_VAL IS NULL LIMIT 1");
	$modificar->bind_param('sii', $resultado, $id_usuario, $id_examen_atencion);
	$modificar->execute();	
	$modificar->close();
	
	return true;
}

function validarResultado($id_usuario, $id_examen_atencion) {
	global $mysqli;
	
	$ahora = date('Y-m-d H:i:s');
	$validar = $mysqli->prepare('UPDATE examenes_atenciones SET USUARIO_VAL = ?, FECHA_VAL = ? WHERE ID_EXATE = ? AND RESULTADO IS NOT NULL LIMIT 1');
	$validar->bind_param('isi', $id_usuario, $ahora, $id_examen_atencion);
	$validar->execute();
	$validar->close();
	
	return true;
}

function generarInforme($id_usuario, $id_atencion) {
	global $mysqli, $carpeta_usuario_dominio;
	
	include __DIR__ . '/../inc/vendor/autoload.php';

	$fecha = date("Y-m-d");
	$hora = date("H:i:s");
	$cambiarFechaInforme = $mysqli->prepare('UPDATE atenciones SET FECHA_INF = ?, HORA_INF = ? WHERE ID_ATENCION = ? LIMIT 1');
	$cambiarFechaInforme->bind_param('ssi', $fecha, $hora, $id_atencion);
	$cambiarFechaInforme->execute();
	$cambiarFechaInforme->close();
	
	$cliente = new Client(
		[
			'headers' => [
				'Content-Type' => 'application/json'
			]
		]
	);
	
  /* las urls se declaran de esta manera ya que el servicio de firma electrónica se ejecuta a través de APACHE TOMCAT
  este se ubica por fuera de los dominios (por ende fuera de cualquier carpeta html) */
	$jsonSolicitud = [
    'urlBajada' => "http://localhost/$carpeta_usuario_dominio/SILCLCE/i_resultados/pdf_p_cm.php?idate=$id_atencion",
		'urlSubida' => "http://localhost/$carpeta_usuario_dominio/SILCLCE/st_resultados/subir_informe_firmado.php?idate=$id_atencion&idusu=$id_usuario",
		'razon' => 'Laboratorio Etcheverry Ltda.',
		'locacion' => 'Viña del Mar',
		'rut' => '10390679-2',
		'posicion' => 'custom',
		'numPagina' => 'last',
		'ulx' => 20,
		'uly' => 72
	];
	
	try {
		$respuesta = $cliente->post(
			'http://localhost:8080/firma_elect',
			[
				'body' => json_encode($jsonSolicitud)
			]
		);
	} catch (ServerException $e) {
		return false;
	}
	return true;
}

function countArchivosAtencion($id_atencion) {
	global $mysqli;
	
	$qCount = $mysqli->prepare('SELECT COUNT(ID_ARCHIVO) FROM archivos_atenciones WHERE ID_ATENCION = ?');
  $qCount->bind_param('i', $id_atencion);
  $qCount->execute();
  $qCount->bind_result($countArchivos);
  $qCount->fetch();
  $qCount->close();
    
	return $countArchivos;
}

function updateFechaInformeNull($id_atencion) {
	global $mysqli;
	
  $qUpdateFechaInforme = $mysqli->prepare('UPDATE atenciones SET FECHA_INF = NULL WHERE ID_ATENCION = ? LIMIT 1');
  $qUpdateFechaInforme->bind_param('i', $id_atencion);
  $qUpdateFechaInforme->execute();
  $qUpdateFechaInforme->close();

	return true;
}

function cerrarResultados($id_atencion) {
	global $mysqli;
	
	$cerrar = $mysqli->prepare("UPDATE atenciones SET CIERRE_RES = 'S' WHERE ID_ATENCION = ? LIMIT 1");
	$cerrar->bind_param('i', $id_atencion);
	$cerrar->execute();
	$cerrar->close();
	
	return true;
}

$metodo_solicitud = $_SERVER['REQUEST_METHOD'];
$id_usuario = $usuario_id;

switch ($metodo_solicitud) {
	case 'GET':
		break;
	case 'POST':
		$json_solicitud = file_get_contents('php://input');
		
		$datos_solicitud = json_decode($json_solicitud, true);
		
    # MODIFICAR RESULTADOS
		$modificar = $datos_solicitud['modificar'];	
		foreach ($modificar as $id_examen_atencion => $resultado) {			
			if (!modificarResultado($resultado, $id_usuario, $id_examen_atencion)) {
				header('Content-Type: application/json');
				echo json_encode(['exito' => false, 'mensaje' => "El resultado '$resultado' no es válido."]);
				die();
			}
		}
		
    # VALIDAR RESULTADOS
		$validar = $datos_solicitud['validar'];	
		foreach ($validar as $id_examen_atencion) {			
			validarResultado($id_usuario, $id_examen_atencion);
		}
		
    # GENERAR INFORMES
		$informar = $datos_solicitud['informar'];  
		foreach ($informar as $id_atencion) {
      $countPreGeneracion = countArchivosAtencion($id_atencion);
			if (!generarInforme($id_usuario, $id_atencion)) {
				header('Content-Type: application/json');
        updateFechaInformeNull($id_atencion);
				echo json_encode(['exito' => false, 'mensaje' => "No se pudo generar el informe para la atención $id_atencion."]);
				die();
			} else {
        header('Content-Type: application/json');
        $countPostGeneracion = countArchivosAtencion($id_atencion);
        if ($countPreGeneracion == $countPostGeneracion) {
          updateFechaInformeNull($id_atencion);
          echo json_encode(['exito' => false, 'mensaje' => "No se guardó correctamente el informe para la atención $id_atencion en la base de datos."]);
          die();
        }
        $envioCorreo = enviarCorreoInformeGenerado($id_atencion);
        if ($envioCorreo != "ok") {
          updateFechaInformeNull($id_atencion);
          echo json_encode(['exito' => false, 'mensaje' => "El informe se generó correctamente, pero el correo informativo para la atención $id_atencion no pudo ser enviado.<br>$envioCorreo"]);
          die();
        }
      }
		}
		
    # CERRAR RESULTADOS
		$cerrar = $datos_solicitud['cerrar'];	
		foreach ($cerrar as $id_atencion) {			
			cerrarResultados($id_atencion);
		}
		
		break;
	default:
}

header('Content-Type: application/json');
echo json_encode(['exito' => true]);

?>
