<?php
define('PERMITIDO', true);

function getNameFromNumber($num) {
    $numeric = $num % 26;
    $letter = chr(65 + $numeric);
    $num2 = intval($num / 26);
    if ($num2 > 0) {
        return getNameFromNumber($num2 - 1) . $letter;
    } else {
        return $letter;
    }
}

$pagina = 34;

require_once '../lib/valido.php';
require_once '../lib/util.php';
require_once '../lib/func.global.php';
require_once '../lib/connection.php';
require_once '../lib/config.php';
require_once '../assets/php/PHPExcel.php';

error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli')
	die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');

if (isset($_GET['desde']) && $_GET['desde'] != '') {
	$fecha_desde = $_GET['desde'];
}

if(isset($_GET['hasta']) && $_GET['hasta'] != '') {
	$fecha_hasta = $_GET['hasta'];
}

if (isset($_GET['id_ex']) && $_GET['id_ex'] != '') {
	$examen = $_GET['id_ex'];
}

$filtro_procedencia = "";
if (isset($_GET['id_proc']) && $_GET['id_proc'] != '') {
    $id_proc = $_GET['id_proc'];
    $filtro_procedencia = ' AND (cc.ID_CENTRO_CONTACTO = \''.$id_proc.'\')';
}

$consulta_pacientes = 'SELECT p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, cc.NOMBRE,
                                GROUP_CONCAT(DATE_FORMAT(a.FECHA, "%d/%m/%Y") ORDER BY a.FECHA ASC), GROUP_CONCAT(ea.RESULTADO ORDER BY a.FECHA ASC)
                        FROM personas p
                        LEFT JOIN atenciones a ON a.ID_CLIENTE = p.ID_PERSONA
                        LEFT JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
                        LEFT JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
                        LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
                        WHERE ex.FLAG_AGRUPACION = "N" AND ea.RESULTADO IS NOT NULL
                        AND a.FECHA >= ? AND a.FECHA <= ? AND ea.COD_EXAMEN = ?
                        '.$filtro_procedencia.'
                        GROUP BY p.ID_PERSONA
                        ORDER BY p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NOMBRES ASC';
$qPacientes = $mysqli->prepare($consulta_pacientes);
$qPacientes->bind_param('sss', $fecha_desde, $fecha_hasta, $examen);
$qPacientes->execute();
$qPacientes->bind_result($p_nombre, $p_apellidoPaterno, $p_apellidoMaterno, $p_procedencia, $p_groupConcatFechas, $p_groupConcatResultados);
$qPacientes->store_result();
$numrows_pacientes = $qPacientes->num_rows;

$consulta_fechaExamenes = 'SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, "%d/%m/%Y")
                            FROM atenciones a
                            LEFT JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
                            LEFT JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
                            LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
                            WHERE ex.FLAG_AGRUPACION = "N" AND ea.RESULTADO IS NOT NULL
                            AND a.FECHA >= ? AND a.FECHA <= ? AND ea.COD_EXAMEN = ?
                            '.$filtro_procedencia.'
                            GROUP BY a.FECHA
                            ORDER BY a.FECHA ASC';
$qFechaExamenes = $mysqli->prepare($consulta_fechaExamenes);
$qFechaExamenes->bind_param('sss', $fecha_desde, $fecha_hasta, $examen);
$qFechaExamenes->execute();
$qFechaExamenes->bind_result($e_idAtencion, $e_fechaExamen);
$qFechaExamenes->store_result();
$num_columnas = $qFechaExamenes->num_rows;
$ultima_columna = getNameFromNumber($num_columnas);
$ultima_columna++;
$ultima_columna++;

$consulta_nombreExamen = 'SELECT NOMBRE
                            FROM examenes
                            WHERE COD_INTERNO = ?';
$qNombreExamen = $mysqli->prepare($consulta_nombreExamen);
$qNombreExamen->bind_param('s', $_GET["id_ex"]);
$qNombreExamen->execute();
$qNombreExamen->bind_result($nombre_examen);
$qNombreExamen->fetch();
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', 'EXAMEN:');
$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B1', $nombre_examen);
$qNombreExamen->close();

$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A3', 'APELLIDOS PACIENTE');
$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B3', 'NOMBRES PACIENTE');

$column = 'C';
$todasLasFechasArray = [];
while ($qFechaExamenes->fetch()) {
    $objPHPExcel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue($column . '3', $e_fechaExamen);
    $column++;
    array_push($todasLasFechasArray, $e_fechaExamen);
}
$qFechaExamenes->close();


$row = 4;
while ($qPacientes->fetch()) {
    $fechasExamenesPacienteArray = explode(',', $p_groupConcatFechas);
    $resultadosExamenesPacienteArray = explode(',', $p_groupConcatResultados);
    $wea = implode(',', $todasLasFechasArray);

    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $row, $p_apellidoPaterno." ".$p_apellidoMaterno);
    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $row, $p_nombre);

    //$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H1', $numrows_pacientes);
    //$objPHPExcel->setActiveSheetIndex(0)->setCellValue('K1', $num_columnas." = ". $ultima_columna);

    $i = 0;

    for($column='C'; $column != $ultima_columna; $column++) {
        $key = array_search($todasLasFechasArray[$i], $fechasExamenesPacienteArray);
        if($key !== false) {
            if($examen == "00.00.069") {
                $aux = preg_split('/\r\n|\r|\n/', $resultadosExamenesPacienteArray[$key]); // PARA ACORTAR EL RESULTADO DE LOS EXAMENES COVID (SOLO LA PRIMERA LINEA)
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($column.$row, $aux[0]);
            } else {
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($column.$row, $resultadosExamenesPacienteArray[$key]);
            }
        }
        $i++;
    }


    $row++;
}
$qPacientes->close();

//$objPHPExcel->getActiveSheet()->setTitle('res_hist_'.$_GET['id_ex']);
$objPHPExcel->getActiveSheet()->setTitle('RESULTADOS HISTORICOS');
$objPHPExcel->setActiveSheetIndex(0);

$desde = date("d-m-Y", strtotime($_GET['desde']));
$hasta = date("d-m-Y", strtotime($_GET['hasta']));

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="RES_HISTORICOS_'.$_GET['id_ex'].'_'.$desde.'_'.$hasta.'.xls"');
//header('Content-Disposition: attachment;filename="res_hist_'.$_GET['id_ex'].'.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');

die();
?>
