<?php

function obtenerPrevision($abr) {
	if ($abr === null) {
		return 'SIN PREVISIÓN';
	}
	if (in_array($abr, ['FNS', 'FNS BE'])) {
		return 'FONASA';
	}
	if (in_array($abr, ['CGC', 'CRUZ B', 'VIDATRES', 'MASVIDA', 'BANMED', 'CONSAL'])) {
		return 'ISAPRE';
	}
	if (in_array($abr, ['DIPRE'])) {
		return 'DIPRECA';
	}
	
	return 'SIN PREVISIÓN';
}

function obtenerResultado($resultado) {
	if ($resultado === null) {
		return false;
	}
	$resultado = strtoupper(trim($resultado));
	if (substr($resultado, 0, 8) === 'NEGATIVO') {
		return 'Negativo';
	}
	if (substr($resultado, 0, 8) === 'POSITIVO') {
		return 'Positivo';
	}
	if (substr($resultado, 0, 13) === 'INDETERMINADO') {
		return 'Indeterminado';
	}
	if (substr($resultado, 0, 8) === 'INVALIDO') {
		return 'Muestra no apta';
	}
	
	return false;
}

?>
