<?php

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\ServerException;

set_time_limit(20 * 60);
define('PERMITIDO', true);
$pantalla_actual = 'NOT_RES_PCR';
require_once __DIR__ . '/../inc/init.php';
require_once __DIR__ . '/../inc/vendor/autoload.php';
require_once __DIR__ . '/inc.php';

function convertirAUtf8($cadena)
{
	return mb_convert_encoding($cadena, 'UTF-8', 'UTF-8, ISO-8859-1');
}

function grabarFolioEpivigila($folio_epivigila, $id_atencion, $sobrescribir = true)
{
	global $mysqli;

	$sql_toma_de_muestra = "SELECT tm.ID_TOMA_DE_MUESTRA, tm.ID_ATENCION 
	FROM toma_de_muestras_minsal tm
	INNER JOIN atenciones a ON tm.ID_ATENCION = a.ID_ATENCION
	WHERE tm.ID_ATENCION = $id_atencion LIMIT 1";
	$resultado_toma_de_muestra = $mysqli->query($sql_toma_de_muestra);
	if ($resultado_toma_de_muestra->num_rows == 0) {
		$crear = $mysqli->prepare('INSERT INTO toma_de_muestras_minsal (ID_ATENCION, FOLIO_EPIVIGILA) VALUES (?, ?)');
		$crear->bind_param('ii', $id_atencion, $folio_epivigila);
		$crear->execute();
		$crear->close();
	} else {
		$id_toma_de_muestra = $resultado_toma_de_muestra->fetch_assoc()['ID_TOMA_DE_MUESTRA'];
		if ($sobrescribir) {
			$modificar = $mysqli->prepare('UPDATE toma_de_muestras_minsal SET FOLIO_EPIVIGILA = ? WHERE ID_TOMA_DE_MUESTRA = ? LIMIT 1');
			$modificar->bind_param('ii', $folio_epivigila, $id_toma_de_muestra);
			$modificar->execute();
			$modificar->close();
		}
	}

	return true;
}

function obtenerTomaDeMuestra($id_atencion)
{
	global $mysqli;

	$sql_toma_de_muestra = "SELECT tm.ID_TOMA_DE_MUESTRA, tm.ID_ATENCION 
	FROM toma_de_muestras_minsal tm
	INNER JOIN atenciones a ON tm.ID_ATENCION = a.ID_ATENCION
	WHERE tm.ID_ATENCION = $id_atencion LIMIT 1";
	$resultado_toma_de_muestra = $mysqli->query($sql_toma_de_muestra);

	if ($resultado_toma_de_muestra->num_rows == 0) return false;
	return $resultado_toma_de_muestra->fetch_assoc()['ID_TOMA_DE_MUESTRA'];
}

function grabarBusquedaActiva($busqueda_activa, $id_atencion)
{
	global $mysqli;

	$sql_toma_de_muestra = "SELECT tm.ID_TOMA_DE_MUESTRA, tm.ID_ATENCION 
	FROM toma_de_muestras_minsal tm
	INNER JOIN atenciones a ON tm.ID_ATENCION = a.ID_ATENCION
	WHERE tm.ID_ATENCION = $id_atencion LIMIT 1";
	$resultado_toma_de_muestra = $mysqli->query($sql_toma_de_muestra);

	$busqueda_activa = $busqueda_activa == true ? 1 : null;

	if ($resultado_toma_de_muestra->num_rows == 0) {
		$crear = $mysqli->prepare('INSERT INTO toma_de_muestras_minsal (ID_ATENCION, BUSQUEDA_ACTIVA) VALUES (?, ?)');
		$crear->bind_param('ii', $id_atencion, $busqueda_activa);
		$crear->execute();
		$crear->close();
	} else {
		$id_toma_de_muestra = $resultado_toma_de_muestra->fetch_assoc()['ID_TOMA_DE_MUESTRA'];
		$modificar = $mysqli->prepare('UPDATE toma_de_muestras_minsal SET BUSQUEDA_ACTIVA = ? WHERE ID_TOMA_DE_MUESTRA = ? LIMIT 1');
		$modificar->bind_param('ii', $busqueda_activa, $id_toma_de_muestra);
		$modificar->execute();
		$modificar->close();
	}

	return true;
}

function crearMuestra($id_usuario, $id_toma_de_muestra)
{
	global $mysqli, $id_laboratorio, $codigo_deis, $id_laboratorio_convenio, $rut_responsable_convenio, $codigo_deis_convenio, $clave_de_acceso_api, $usuario_rut;

	if (strpos($id_toma_de_muestra, 'ex-ate-') !== false) {
		$id_atencion = str_replace('ex-ate-', '', $id_toma_de_muestra);
		grabarFolioEpivigila(0, $id_atencion, false);
		$id_toma_de_muestra = obtenerTomaDeMuestra($id_atencion);
	}

	$sql_datos_muestra = "SELECT a.ID_ATENCION,
    a.ID_MEDICO, med.NRO_RUT as NRO_RUT_MED, med.DV_RUT as DV_RUT_MED, 
    pac.NRO_RUT as NRO_RUT_PAC, pac.DV_RUT as DV_RUT_PAC, pac.PASAPORTE, cod_2.ATRIBUTO1 AS COD_PAIS, pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO, pac.FECHA_NACIMIENTO, pac.DIRECCION, cod.ATRIBUTO1 AS COD_COMUNA, pac.FONO_1, pac.GENERO, 
    prev.NBR,
    a.FECHA_TM, a.HORA_TM, a.ID_CONVENIO,
    tm.FOLIO_EPIVIGILA, tm.BUSQUEDA_ACTIVA
	FROM toma_de_muestras_minsal tm
	INNER JOIN atenciones a ON tm.ID_ATENCION = a.ID_ATENCION
	INNER JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
	LEFT JOIN personas med ON a.ID_MEDICO = med.ID_PERSONA
	LEFT JOIN empresas prev ON a.ID_PREVISION = prev.ID_EMPRESA
	LEFT JOIN codigos_generales cod ON pac.COMUNA = cod.CODIGO AND cod.COD_TABLA = 'SIS_COMUN'
	LEFT JOIN codigos_generales cod_2 ON pac.PAIS = cod_2.CODIGO AND cod_2.COD_TABLA = 'SIS_PAIS'
	WHERE tm.ID_TOMA_DE_MUESTRA = $id_toma_de_muestra";
	$resultado_datos_muestra = $mysqli->query($sql_datos_muestra);
	$datos_muestra = $resultado_datos_muestra->fetch_assoc();

	$id_atencion = strval($datos_muestra['ID_ATENCION']);

	$error = "Error al crear la muestra para la atención $id_atencion. ";

	if ($datos_muestra['ID_MEDICO'] === null) {
		return $error . '<br />La atención no posee médico.';
	}
	if ($datos_muestra['NRO_RUT_MED'] === null || $datos_muestra['DV_RUT_MED'] === null) {
		return $error . '<br />El RUT del médico no está configurado correctamente.';
	}
	$rut_medico = $datos_muestra['NRO_RUT_MED'] . '-' . $datos_muestra['DV_RUT_MED'];
	$sin_orden_medica = false;
	if ($rut_medico == '11111111-3') {
		$rut_medico = null;
		$sin_orden_medica = true;
	}

	if ($datos_muestra['PASAPORTE'] === null) {
		if ($datos_muestra['NRO_RUT_PAC'] === null || $datos_muestra['DV_RUT_PAC'] === null) return $error . '<br />El RUT del paciente no está configurado correctamente.';
		$paciente_tipodoc = 'RUN';
		$paciente_run = intval($datos_muestra['NRO_RUT_PAC']);
		$paciente_dv = strtoupper(strval($datos_muestra['DV_RUT_PAC']));
	} else {
		if ($datos_muestra['COD_PAIS'] === null) {
			return $error . '<br />El país del paciente no está configurado correctamente.';
		}

		$paciente_tipodoc = 'PASAPORTE';
		$paciente_pasaporte = $datos_muestra['PASAPORTE'];
		$paciente_ext_paisorigen = $datos_muestra['COD_PAIS'];
	}

	if ($datos_muestra['NOMBRES'] === null || $datos_muestra['APELLIDO_PATERNO'] === null) {
		return $error . '<br />El nombre del paciente está incompleto.';
	}
	$paciente_nombres = convertirAUtf8($datos_muestra['NOMBRES']);
	$paciente_ap_pat = convertirAUtf8($datos_muestra['APELLIDO_PATERNO']);
	$paciente_ap_mat = $datos_muestra['APELLIDO_MATERNO'] === null ? '' : convertirAUtf8($datos_muestra['APELLIDO_MATERNO']);

	if ($datos_muestra['FECHA_NACIMIENTO'] === null) return $error . '<br />Falta la fecha de nacimiento del paciente.';
	$paciente_fecha_nac = explode('-', $datos_muestra['FECHA_NACIMIENTO']);
	$paciente_fecha_nac = array_reverse($paciente_fecha_nac);
	$paciente_fecha_nac = implode('-', $paciente_fecha_nac);

	if ($datos_muestra['DIRECCION'] === null) return $error . '<br />Falta la dirección del paciente.';
	$paciente_direccion = strtoupper(convertirAUtf8($datos_muestra['DIRECCION']));

	if ($datos_muestra['COD_COMUNA'] === null) return $error . '<br />Falta la comuna del paciente.';
	$paciente_comuna = intval($datos_muestra['COD_COMUNA']);

	if ($datos_muestra['FONO_1'] === null) return $error . '<br />Falta el teléfono del paciente.';
	$paciente_telefono = $datos_muestra['FONO_1'];

	if ($datos_muestra['GENERO'] === null || !in_array($datos_muestra['GENERO'], ['F', 'M'])) return $error . '<br />Falta el género del paciente o está mal especificado';
	$paciente_sexo = $datos_muestra['GENERO'];

	$paciente_prevision = obtenerPrevision($datos_muestra['NBR']);

	if ($datos_muestra['FECHA_TM'] === null || $datos_muestra['HORA_TM'] === null) return $error . '<br />Falta especificar la fecha de toma de muestra.';

	$fecha_muestra = explode('-', $datos_muestra['FECHA_TM']);
	$fecha_muestra = array_reverse($fecha_muestra);
	$fecha_muestra = implode('-', $fecha_muestra);
	$hora_muestra = $datos_muestra['HORA_TM'];

	$rut_responsable = $usuario_rut;
	$idconv = $datos_muestra['ID_CONVENIO'];
	if ($idconv != 0) {
		$id_laboratorio = isset($id_laboratorio_convenio[$idconv]) ? $id_laboratorio_convenio[$idconv] : $id_laboratorio;
		$codigo_deis = isset($codigo_deis_convenio[$idconv]) ? $codigo_deis_convenio[$idconv] : $codigo_deis;
		$rut_responsable = isset($rut_responsable_convenio[$idconv]) ? $rut_responsable_convenio[$idconv] : $usuario_rut;
	}

	$json_solicitud = [
		'codigo_muestra_cliente' => $id_atencion,
		'id_laboratorio' => $id_laboratorio,
		'rut_responsable' => $rut_responsable,
		'cod_deis' => $codigo_deis,
		'paciente_tipodoc' => $paciente_tipodoc,
		'paciente_nombres' => $paciente_nombres,
		'paciente_ap_pat' => $paciente_ap_pat,
		'paciente_ap_mat' => $paciente_ap_mat,
		'paciente_fecha_nac' => $paciente_fecha_nac,
		'paciente_comuna' => $paciente_comuna,
		'paciente_direccion' => $paciente_direccion,
		'paciente_telefono' => $paciente_telefono,
		'paciente_sexo' => $paciente_sexo,
		'paciente_prevision' => $paciente_prevision,
		'fecha_muestra' => $fecha_muestra . 'T' . $hora_muestra,
		'tecnica_muestra' => 'RT-PCR',
		'tipo_muestra' => 'Tórulas Nasofaríngeas',
		'sin_orden_medica' => $sin_orden_medica
	];

	if ($rut_medico != null) {
		$json_solicitud['rut_medico'] = $rut_medico;
	}

	if ($paciente_tipodoc == 'RUN') {
		$json_solicitud['paciente_run'] = $paciente_run;
		$json_solicitud['paciente_dv'] = $paciente_dv;
	} else {
		$json_solicitud['paciente_pasaporte'] = $paciente_pasaporte;
		$json_solicitud['paciente_ext_paisorigen'] = $paciente_ext_paisorigen;
	}

	if ($datos_muestra['FOLIO_EPIVIGILA'] != 0) $json_solicitud['epivigila'] = $datos_muestra['FOLIO_EPIVIGILA'];

	$json_solicitud['busqueda_activa'] = $datos_muestra['BUSQUEDA_ACTIVA'] == 1 ? 'true' : 'false';

	$data_enviada = json_encode($json_solicitud);
	// print_r(json_encode($json_solicitud));
	// exit(0);

	$cliente = new Client(
		[
			'headers' => [
				'Content-Type' => 'application/json',
				'ACCESSKEY' => $clave_de_acceso_api
			]
		]
	);


	try {
		$respuesta = $cliente->post(
			'https://tomademuestras.api.openagora.cl/crearMuestras_v2',
			[
				'body' => json_encode([$json_solicitud])
			]
		);

		$objeto_respuesta = json_decode($respuesta->getBody()->getContents(), true);

		// print_r($objeto_respuesta);
		// exit(0);

		if ($objeto_respuesta === null || !isset($objeto_respuesta[0]['id_muestra'])) {
			return $error . '<br />El servidor del MINSAL respondió: <br />(1)' . $respuesta->getBody()->getContents();
		}

		$id_muestra_minsal = $objeto_respuesta[0]['id_muestra'];

		$ahora = date('Y-m-d H:i:s');
		$crear_muestra = $mysqli->prepare('UPDATE toma_de_muestras_minsal 
		SET ID_USUARIO_CREACION_MUESTRA = ?, FECHA_HORA_CREACION_MUESTRA = ?, ID_MUESTRA_MINSAL = ?, ID_LABORATORIO = ?, COD_DEIS = ?, DATA_ENVIADA = ?
		WHERE ID_TOMA_DE_MUESTRA = ? LIMIT 1');
		$crear_muestra->bind_param('isssssi', $id_usuario, $ahora, $id_muestra_minsal, $id_laboratorio, $codigo_deis, $data_enviada, $id_toma_de_muestra);
		$crear_muestra->execute();
		$crear_muestra->close();
	} catch (ServerException $e) {
		$respuesta = $e->getResponse()->getBody()->getContents();
		$objeto_respuesta = json_decode($respuesta, true);
		if ($objeto_respuesta === null || !isset($objeto_respuesta['error'])) return $error . '<br />El servidor del MINSAL respondió: <br />(2) ' . $respuesta;
		return $error .	'<br />El servidor del MINSAL respondió: <br />(3) ' . $objeto_respuesta['error'];
	} catch (ClientException $e) {
		$respuesta = $e->getResponse()->getBody()->getContents();
		$objeto_respuesta = json_decode($respuesta, true);
		if ($objeto_respuesta === null || !isset($objeto_respuesta['error'])) return $error . '<br />El servidor del MINSAL respondió: <br />(4) ' . $respuesta;
		return $error .	'<br />El servidor del MINSAL respondió: <br />(5) ' . $objeto_respuesta['error'];
	}

	return true;
}

function recepcionarMuestra($id_usuario, $id_toma_de_muestra)
{
	global $mysqli, $clave_de_acceso_api;

	$sql_datos_muestra = "SELECT tm.ID_MUESTRA_MINSAL, a.ID_ATENCION, a.FECHA_R, a.HORA_R
	FROM toma_de_muestras_minsal tm
	INNER JOIN atenciones a ON tm.ID_ATENCION = a.ID_ATENCION
	WHERE tm.ID_TOMA_DE_MUESTRA = $id_toma_de_muestra
	LIMIT 1";

	$resultado_datos_muestra = $mysqli->query($sql_datos_muestra);
	$num_rows_muestra = $resultado_datos_muestra->num_rows;
	$datos_muestra = $resultado_datos_muestra->fetch_assoc();
	$id_atencion = strval($datos_muestra['ID_ATENCION']);

	$error = "Error al recepcionar la muestra para la atención $id_atencion. ";
	if ($datos_muestra['FECHA_R'] === null || $datos_muestra['HORA_R'] === null) return $error . '<br />La atención no posee fecha de recepción.';

	$fecha_muestra = explode('-', $datos_muestra['FECHA_R']);
	$fecha_muestra = array_reverse($fecha_muestra);
	$fecha_muestra = implode('-', $fecha_muestra);
	$hora_muestra = $datos_muestra['HORA_R'];

	$id_muestra = intval($datos_muestra['ID_MUESTRA_MINSAL']);

	$json_solicitud = [
		'id_muestra' => $id_muestra,
		'fecha_recepcion_laboratorio' => $fecha_muestra . 'T' . $hora_muestra
	];

	$cliente = new Client(
		[
			'headers' => [
				'Content-Type' => 'application/json',
				'ACCESSKEY' => $clave_de_acceso_api
			]
		]
	);

	try {
		$respuesta = $cliente->post(
			'https://tomademuestras.api.openagora.cl/recepcionarMuestra',
			[
				'body' => json_encode([$json_solicitud])
			]
		);

		$objeto_respuesta = json_decode($respuesta->getBody()->getContents(), true);
		if ($objeto_respuesta === null || !isset($objeto_respuesta[0]['id_muestra'])) {
			return $error . '<br />El servidor del MINSAL respondió: ' . $respuesta->getBody()->getContents();
		}

		$ahora = date('Y-m-d H:i:s');
		$recepcionar_muestra = $mysqli->prepare('UPDATE toma_de_muestras_minsal SET ID_USUARIO_RECEPCION_MUESTRA = ?, FECHA_HORA_RECEPCION_MUESTRA = ? WHERE ID_TOMA_DE_MUESTRA = ? LIMIT 1');
		$recepcionar_muestra->bind_param('isi', $id_usuario, $ahora, $id_toma_de_muestra);
		$recepcionar_muestra->execute();
		$recepcionar_muestra->close();
	} catch (ServerException $e) {
		$respuesta = $e->getResponse()->getBody()->getContents();
		$objeto_respuesta = json_decode($respuesta, true);
		if ($objeto_respuesta === null || !isset($objeto_respuesta['error'])) return $error . '<br />El servidor del MINSAL respondió: <br />' . $respuesta;
		return $error .	'<br />El servidor del MINSAL respondió: <br />' . $objeto_respuesta['error'];
	} catch (ClientException $e) {
		$respuesta = $e->getResponse()->getBody()->getContents();
		$objeto_respuesta = json_decode($respuesta, true);
		if ($objeto_respuesta === null || !isset($objeto_respuesta['error'])) return $error . '<br />El servidor del MINSAL respondió: <br />' . $respuesta;
		return $error .	'<br />El servidor del MINSAL respondió: <br />' . $objeto_respuesta['error'];
	}

	return true;
}

function entregarResultado($id_usuario, $id_toma_de_muestra)
{
	global $mysqli, $clave_de_acceso_api;

	$resultado_datos_muestra = $mysqli->query("SELECT tm.ID_MUESTRA_MINSAL, a.ID_ATENCION, a.FECHA_INF, ea.RESULTADO
	FROM toma_de_muestras_minsal tm
	INNER JOIN atenciones a ON tm.ID_ATENCION = a.ID_ATENCION
	INNER JOIN examenes_atenciones ea ON a.ID_ATENCION = ea.ID_ATENCION AND ea.COD_EXAMEN IN ('00.00.069', '00.00.166')
	WHERE tm.ID_TOMA_DE_MUESTRA = $id_toma_de_muestra
	LIMIT 1");
	$num_rows_muestra = $resultado_datos_muestra->num_rows;
	$datos_muestra = $resultado_datos_muestra->fetch_assoc();
	$id_atencion = strval($datos_muestra['ID_ATENCION']);

	$resultado = obtenerResultado($datos_muestra['RESULTADO']);

	$error = "Error al entregar el resultado para la atención $id_atencion. ";
	if ($num_rows_muestra == "0") return $error . '<br />No se encontró examen para la atención.';
	if ($datos_muestra['FECHA_INF'] === null) return $error . '<br />No se ha generado un informe para la atención.';
	if ($resultado === false) return $error . '<br />El resultado ' . $datos_muestra['RESULTADO'] . ' es inválido.';

	$ruta_archivo_temporal = __DIR__ . '/tmp/' . md5(rand()) . '.txt';
	file_put_contents($ruta_archivo_temporal, $datos_muestra['RESULTADO']);
	$id_muestra = intval($datos_muestra['ID_MUESTRA_MINSAL']);

	$json_solicitud = [
		'id_muestra' => $id_muestra,
		'resultado' => $resultado
	];

	$cliente = new Client(
		[
			'headers' => [
				'Content-Type' => 'multipart/form-data',
				'ACCESSKEY' => $clave_de_acceso_api
			]
		]
	);

	try {
		$respuesta = $cliente->post(
			'https://tomademuestras.api.openagora.cl/entregaResultado',
			[
				'multipart' => [
					[
						'name'     => 'parametros',
						'contents' => json_encode($json_solicitud)
					],
					[
						'name'     => 'upfile',
						'contents' => fopen($ruta_archivo_temporal, 'r'),
						'filename' => $id_muestra . '.txt'
					]
				]
			]
		);

		unlink($ruta_archivo_temporal);
		$objeto_respuesta = json_decode($respuesta->getBody()->getContents(), true);
		# print_r($objeto_respuesta);
		if ($objeto_respuesta === null || !isset($objeto_respuesta['case'])) return $error . '<br />(1) El servidor del MINSAL respondió: ' . $respuesta->getBody()->getContents();
		
		$ahora = date('Y-m-d H:i:s');
		$entregar_resultado = $mysqli->prepare('UPDATE toma_de_muestras_minsal SET ID_USUARIO_ENTREGA_RESULTADO = ?, FECHA_HORA_ENTREGA_RESULTADO = ? WHERE ID_TOMA_DE_MUESTRA = ? LIMIT 1');
		$entregar_resultado->bind_param('isi', $id_usuario, $ahora, $id_toma_de_muestra);
		$entregar_resultado->execute();
		$entregar_resultado->close();
	} catch (ServerException $e) {
		unlink($ruta_archivo_temporal);
		$respuesta = $e->getResponse()->getBody()->getContents();
		$objeto_respuesta = json_decode($respuesta, true);
		if ($objeto_respuesta === null || !isset($objeto_respuesta['error'])) return $error . '<br />(2) El servidor del MINSAL respondió: <br />' . $respuesta;
		return $error .	'<br />El servidor del MINSAL respondió: <br />' . $objeto_respuesta['error'];
	} catch (ClientException $e) {
		unlink($ruta_archivo_temporal);
		$respuesta = $e->getResponse()->getBody()->getContents();
		$objeto_respuesta = json_decode($respuesta, true);
		if ($objeto_respuesta === null || !isset($objeto_respuesta['error'])) return $error . '<br />(3) El servidor del MINSAL respondió: <br />' . $respuesta;
		return $error .	'<br />El servidor del MINSAL respondió: <br />' . $objeto_respuesta['error'];
	}

	return true;
}

function responderError($error)
{
	header('Content-Type: application/json');
	echo json_encode(['exito' => false, 'mensaje' => $error]);
	die();
}

$metodo_solicitud = $_SERVER['REQUEST_METHOD'];
$id_usuario = $usuario_id;

switch ($metodo_solicitud) {
	case 'GET':
		break;
	case 'POST':
		$json_solicitud = file_get_contents('php://input');

		$datos_solicitud = json_decode($json_solicitud, true);

		$folios_epivigila = $datos_solicitud['folios_epivigila'];
		foreach ($folios_epivigila as $id_atencion => $folio_epivigila) {
			if (($res = grabarFolioEpivigila($folio_epivigila, $id_atencion)) !== true) {
				responderError($res);
			}
		}

		$busquedas_activas = $datos_solicitud['busquedas_activas'];
		foreach ($busquedas_activas as $id_atencion => $busqueda_activa) {
			if (($res = grabarBusquedaActiva($busqueda_activa, $id_atencion)) !== true) {
				responderError($res);
			}
		}

		$crear = $datos_solicitud['crear'];
		foreach ($crear as $id_toma_de_muestra) {
			if (($res = crearMuestra($id_usuario, $id_toma_de_muestra)) !== true) {
				responderError($res);
			}
		}

		$recepcionar = $datos_solicitud['recepcionar'];
		foreach ($recepcionar as $id_toma_de_muestra) {
			if (($res = recepcionarMuestra($id_usuario, $id_toma_de_muestra)) !== true) {
				responderError($res);
			}
		}

		$entregar = $datos_solicitud['entregar'];
		foreach ($entregar as $id_toma_de_muestra) {
			if (($res = entregarResultado($id_usuario, $id_toma_de_muestra)) !== true) {
				responderError($res);
			}
		}

		break;
	default:
}

header('Content-Type: application/json');
echo json_encode(['exito' => true]);
